#!/bin/bash

# Variablen definieren
# Duplicity-Optionen
DUPLICITY_OPTS="-v5 --no-encryption \
    --archive-dir /tmp \
    --volsize 10 \
    --exclude-filelist /etc/htmbackup.list"

# Backup-Quelle (root-Verzeichnis)
BACKUP_SOURCE="/"

# Backup-Ziel (SCP-URL)
# Die Umgebungsvariable ID wird aus der Datei /etc/os-release geladen
. /etc/os-release

BACKUP_TARGET="sftp://backups@192.168.10.1:/duplicity/${ID}_$(hostname)_$(uname -m)"

# Wiederholungslogik
MAX_RETRIES=5
RETRY_DELAY=30 # Sekunden

# Überprüfen, ob das erste Argument "--dry-run" ist
if [ "$1" == "--dry-run" ]; then
    echo "--- Dry-Run-Modus aktiviert. Es werden keine Daten gesichert. ---"
    # Füge die --dry-run Option hinzu
    DUPLICITY_OPTS="$DUPLICITY_OPTS --dry-run"
    # Im Dry-Run-Modus gibt es keine Wiederholungslogik, da das Backup nie fehlschlägt
    MAX_RETRIES=1
fi

for ((i=1; i<=MAX_RETRIES; i++)); do
    echo "Versuch $i von $MAX_RETRIES: Starte Duplicity-Backup..."
    /usr/bin/duplicity $DUPLICITY_OPTS $BACKUP_SOURCE $BACKUP_TARGET

    # Überprüfen, ob das Backup erfolgreich war
    if [ $? -eq 0 ]; then
        echo "Backup erfolgreich abgeschlossen."
        exit 0
    else
        echo "Backup fehlgeschlagen, versuche es erneut in $RETRY_DELAY Sekunden..."
        sleep $RETRY_DELAY
    fi
done

echo "Backup nach $MAX_RETRIES Versuchen fehlgeschlagen."
exit 1
