require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ASM_S390_SIE_H)) {
    eval 'sub _ASM_S390_SIE_H () {1;}' unless defined(&_ASM_S390_SIE_H);
    eval 'sub diagnose_codes () {{ 0x10, "DIAG (0x10) release pages" }, { 0x44, "DIAG (0x44) time slice end" }, { 0x9c, "DIAG (0x9c) time slice end directed" }, { 0x204, "DIAG (0x204) logical-cpu utilization" }, { 0x258, "DIAG (0x258) page-reference services" }, { 0x288, "DIAG (0x288) watchdog functions" }, { 0x308, "DIAG (0x308) ipl functions" }, { 0x500, "DIAG (0x500) KVM virtio functions" }, { 0x501, "DIAG (0x501) KVM breakpoint" };}' unless defined(&diagnose_codes);
    eval 'sub sigp_order_codes () {{ 0x1, "SIGP sense" }, { 0x2, "SIGP external call" }, { 0x3, "SIGP emergency signal" }, { 0x4, "SIGP start" }, { 0x5, "SIGP stop" }, { 0x6, "SIGP restart" }, { 0x9, "SIGP stop and store status" }, { 0xb, "SIGP initial cpu reset" }, { 0xc, "SIGP cpu reset" }, { 0xd, "SIGP set prefix" }, { 0xe, "SIGP store status at address" }, { 0x12, "SIGP set architecture" }, { 0x13, "SIGP conditional emergency signal" }, { 0x15, "SIGP sense running" }, { 0x16, "SIGP set multithreading"}, { 0x17, "SIGP store additional status at address"};}' unless defined(&sigp_order_codes);
    eval 'sub icpt_prog_codes () {{ 0x1, "Prog Operation" }, { 0x2, "Prog Privileged Operation" }, { 0x3, "Prog Execute" }, { 0x4, "Prog Protection" }, { 0x5, "Prog Addressing" }, { 0x6, "Prog Specification" }, { 0x7, "Prog Data" }, { 0x8, "Prog Fixedpoint overflow" }, { 0x9, "Prog Fixedpoint divide" }, { 0xa, "Prog Decimal overflow" }, { 0xb, "Prog Decimal divide" }, { 0xc, "Prog HFP exponent overflow" }, { 0xd, "Prog HFP exponent underflow" }, { 0xe, "Prog HFP significance" }, { 0xf, "Prog HFP divide" }, { 0x10, "Prog Segment translation" }, { 0x11, "Prog Page translation" }, { 0x12, "Prog Translation specification" }, { 0x13, "Prog Special operation" }, { 0x15, "Prog Operand" }, { 0x16, "Prog Trace table" }, { 0x17, "Prog ASNtranslation specification" }, { 0x1c, "Prog Spaceswitch event" }, { 0x1d, "Prog HFP square root" }, { 0x1f, "Prog PCtranslation specification" }, { 0x20, "Prog AFX translation" }, { 0x21, "Prog ASX translation" }, { 0x22, "Prog LX translation" }, { 0x23, "Prog EX translation" }, { 0x24, "Prog Primary authority" }, { 0x25, "Prog Secondary authority" }, { 0x26, "Prog LFXtranslation exception" }, { 0x27, "Prog LSXtranslation exception" }, { 0x28, "Prog ALET specification" }, { 0x29, "Prog ALEN translation" }, { 0x2a, "Prog ALE sequence" }, { 0x2b, "Prog ASTE validity" }, { 0x2c, "Prog ASTE sequence" }, { 0x2d, "Prog Extended authority" }, { 0x2e, "Prog LSTE sequence" }, { 0x2f, "Prog ASTE instance" }, { 0x30, "Prog Stack full" }, { 0x31, "Prog Stack empty" }, { 0x32, "Prog Stack specification" }, { 0x33, "Prog Stack type" }, { 0x34, "Prog Stack operation" }, { 0x39, "Prog Region first translation" }, { 0x3a, "Prog Region second translation" }, { 0x3b, "Prog Region third translation" }, { 0x40, "Prog Monitor event" }, { 0x80, "Prog PER event" }, { 0x119, "Prog Crypto operation" };}' unless defined(&icpt_prog_codes);
    eval 'sub exit_code_ipa0 {
        my($ipa0, $opcode, $mnemonic) = @_;
	    eval q({ ($ipa0 << 8| $opcode), $ipa0 \\" \\" $mnemonic });
    }' unless defined(&exit_code_ipa0);
    eval 'sub exit_code {
        my($opcode, $mnemonic) = @_;
	    eval q({ $opcode, $mnemonic });
    }' unless defined(&exit_code);
    eval 'sub icpt_insn_codes () { &exit_code_ipa0(0x1, 0x1, "PR"),  &exit_code_ipa0(0x1, 0x4, "PTFF"),  &exit_code_ipa0(0x1, 0x7, "SCKPF"),  &exit_code_ipa0(0xaa, 0x, "RINEXT"),  &exit_code_ipa0(0xaa, 0x1, "RION"),  &exit_code_ipa0(0xaa, 0x2, "TRIC"),  &exit_code_ipa0(0xaa, 0x3, "RIOFF"),  &exit_code_ipa0(0xaa, 0x4, "RIEMIT"),  &exit_code_ipa0(0xb2, 0x2, "STIDP"),  &exit_code_ipa0(0xb2, 0x4, "SCK"),  &exit_code_ipa0(0xb2, 0x5, "STCK"),  &exit_code_ipa0(0xb2, 0x6, "SCKC"),  &exit_code_ipa0(0xb2, 0x7, "STCKC"),  &exit_code_ipa0(0xb2, 0x8, "SPT"),  &exit_code_ipa0(0xb2, 0x9, "STPT"),  &exit_code_ipa0(0xb2, 0xd, "PTLB"),  &exit_code_ipa0(0xb2, 0x10, "SPX"),  &exit_code_ipa0(0xb2, 0x11, "STPX"),  &exit_code_ipa0(0xb2, 0x12, "STAP"),  &exit_code_ipa0(0xb2, 0x14, "SIE"),  &exit_code_ipa0(0xb2, 0x16, "SETR"),  &exit_code_ipa0(0xb2, 0x17, "STETR"),  &exit_code_ipa0(0xb2, 0x18, "PC"),  &exit_code_ipa0(0xb2, 0x20, "SERVC"),  &exit_code_ipa0(0xb2, 0x21, "IPTE"),  &exit_code_ipa0(0xb2, 0x28, "PT"),  &exit_code_ipa0(0xb2, 0x29, "ISKE"),  &exit_code_ipa0(0xb2, 0x2a, "RRBE"),  &exit_code_ipa0(0xb2, 0x2b, "SSKE"),  &exit_code_ipa0(0xb2, 0x2c, "TB"),  &exit_code_ipa0(0xb2, 0x2e, "PGIN"),  &exit_code_ipa0(0xb2, 0x2f, "PGOUT"),  &exit_code_ipa0(0xb2, 0x30, "CSCH"),  &exit_code_ipa0(0xb2, 0x31, "HSCH"),  &exit_code_ipa0(0xb2, 0x32, "MSCH"),  &exit_code_ipa0(0xb2, 0x33, "SSCH"),  &exit_code_ipa0(0xb2, 0x34, "STSCH"),  &exit_code_ipa0(0xb2, 0x35, "TSCH"),  &exit_code_ipa0(0xb2, 0x36, "TPI"),  &exit_code_ipa0(0xb2, 0x37, "SAL"),  &exit_code_ipa0(0xb2, 0x38, "RSCH"),  &exit_code_ipa0(0xb2, 0x39, "STCRW"),  &exit_code_ipa0(0xb2, 0x3a, "STCPS"),  &exit_code_ipa0(0xb2, 0x3b, "RCHP"),  &exit_code_ipa0(0xb2, 0x3c, "SCHM"),  &exit_code_ipa0(0xb2, 0x40, "BAKR"),  &exit_code_ipa0(0xb2, 0x48, "PALB"),  &exit_code_ipa0(0xb2, 0x4c, "TAR"),  &exit_code_ipa0(0xb2, 0x50, "CSP"),  &exit_code_ipa0(0xb2, 0x54, "MVPG"),  &exit_code_ipa0(0xb2, 0x56, "STHYI"),  &exit_code_ipa0(0xb2, 0x58, "BSG"),  &exit_code_ipa0(0xb2, 0x5a, "BSA"),  &exit_code_ipa0(0xb2, 0x5f, "CHSC"),  &exit_code_ipa0(0xb2, 0x74, "SIGA"),  &exit_code_ipa0(0xb2, 0x76, "XSCH"),  &exit_code_ipa0(0xb2, 0x78, "STCKE"),  &exit_code_ipa0(0xb2, 0x7c, "STCKF"),  &exit_code_ipa0(0xb2, 0x7d, "STSI"),  &exit_code_ipa0(0xb2, 0xb0, "STFLE"),  &exit_code_ipa0(0xb2, 0xb1, "STFL"),  &exit_code_ipa0(0xb2, 0xb2, "LPSWE"),  &exit_code_ipa0(0xb2, 0xf8, "TEND"),  &exit_code_ipa0(0xb2, 0xfc, "TABORT"),  &exit_code_ipa0(0xb9, 0x1e, "KMAC"),  &exit_code_ipa0(0xb9, 0x28, "PCKMO"),  &exit_code_ipa0(0xb9, 0x2a, "KMF"),  &exit_code_ipa0(0xb9, 0x2b, "KMO"),  &exit_code_ipa0(0xb9, 0x2d, "KMCTR"),  &exit_code_ipa0(0xb9, 0x2e, "KM"),  &exit_code_ipa0(0xb9, 0x2f, "KMC"),  &exit_code_ipa0(0xb9, 0x3e, "KIMD"),  &exit_code_ipa0(0xb9, 0x3f, "KLMD"),  &exit_code_ipa0(0xb9, 0x8a, "CSPG"),  &exit_code_ipa0(0xb9, 0x8d, "EPSW"),  &exit_code_ipa0(0xb9, 0x8e, "IDTE"),  &exit_code_ipa0(0xb9, 0x8f, "CRDTE"),  &exit_code_ipa0(0xb9, 0x9c, "EQBS"),  &exit_code_ipa0(0xb9, 0xa2, "PTF"),  &exit_code_ipa0(0xb9, 0xab, "ESSA"),  &exit_code_ipa0(0xb9, 0xae, "RRBM"),  &exit_code_ipa0(0xb9, 0xaf, "PFMF"),  &exit_code_ipa0(0xe3, 0x3, "LRAG"),  &exit_code_ipa0(0xe3, 0x13, "LRAY"),  &exit_code_ipa0(0xe3, 0x25, "NTSTG"),  &exit_code_ipa0(0xe5, 0x, "LASP"),  &exit_code_ipa0(0xe5, 0x1, "TPROT"),  &exit_code_ipa0(0xe5, 0x60, "TBEGIN"),  &exit_code_ipa0(0xe5, 0x61, "TBEGINC"),  &exit_code_ipa0(0xeb, 0x25, "STCTG"),  &exit_code_ipa0(0xeb, 0x2f, "LCTLG"),  &exit_code_ipa0(0xeb, 0x60, "LRIC"),  &exit_code_ipa0(0xeb, 0x61, "STRIC"),  &exit_code_ipa0(0xeb, 0x62, "MRIC"),  &exit_code_ipa0(0xeb, 0x8a, "SQBS"),  &exit_code_ipa0(0xc8, 0x1, "ECTG"),  &exit_code(0xa, "SVC"),  &exit_code(0x80, "SSM"),  &exit_code(0x82, "LPSW"),  &exit_code(0x83, "DIAG"),  &exit_code(0xae, "SIGP"),  &exit_code(0xac, "STNSM"),  &exit_code(0xad, "STOSM"),  &exit_code(0xb1, "LRA"),  &exit_code(0xb6, "STCTL"),  &exit_code(0xb7, "LCTL"),  &exit_code(0xee, "PLO");}' unless defined(&icpt_insn_codes);
    eval 'sub sie_intercept_code () {{ 0x, "Host interruption" }, { 0x4, "Instruction" }, { 0x8, "Program interruption" }, { 0xc, "Instruction and program interruption" }, { 0x10, "External request" }, { 0x14, "External interruption" }, { 0x18, "I/O request" }, { 0x1c, "Wait state" }, { 0x20, "Validity" }, { 0x28, "Stop request" }, { 0x2c, "Operation exception" }, { 0x38, "Partial-execution" }, { 0x3c, "I/O interruption" }, { 0x40, "I/O instruction" }, { 0x48, "Timing subset" };}' unless defined(&sie_intercept_code);
    eval 'sub INSN_DECODE_IPA0 {
        my($ipa0, $insn, $rshift, $mask) = @_;
	    eval q(($insn >> 56) == ($ipa0) ? (($ipa0 << 8) | (($insn >> $rshift) & $mask)) :);
    }' unless defined(&INSN_DECODE_IPA0);
    eval 'sub INSN_DECODE {
        my($insn) = @_;
	    eval q(($insn >> 56));
    }' unless defined(&INSN_DECODE);
    eval 'sub icpt_insn_decoder {
        my($insn) = @_;
	    eval q((  &INSN_DECODE_IPA0(0x1, $insn, 48, 0xff)  &INSN_DECODE_IPA0(0xaa, $insn, 48, 0xf)  &INSN_DECODE_IPA0(0xb2, $insn, 48, 0xff)  &INSN_DECODE_IPA0(0xb9, $insn, 48, 0xff)  &INSN_DECODE_IPA0(0xe3, $insn, 48, 0xff)  &INSN_DECODE_IPA0(0xe5, $insn, 48, 0xff)  &INSN_DECODE_IPA0(0xeb, $insn, 16, 0xff)  &INSN_DECODE_IPA0(0xc8, $insn, 48, 0xf)  &INSN_DECODE($insn)));
    }' unless defined(&icpt_insn_decoder);
}
1;
