/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.Statement;
import java.util.Deque;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.SingleExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class MultiIntExecutionResult
extends ExecutionResult {
    MariaSelectResultSet result = null;
    long[] insertId;
    int[] affectedRows;
    int currentStat = 0;

    public MultiIntExecutionResult(Statement statement, int size, int fetchSize, boolean isSelectPossible) {
        super(statement, fetchSize, isSelectPossible, false);
        this.affectedRows = new int[size];
        this.insertId = new long[size];
    }

    @Override
    public void addResult(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.result = result;
        this.insertId[this.currentStat] = -2L;
        this.affectedRows[this.currentStat++] = -1;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId[this.currentStat] = insertId;
        this.affectedRows[this.currentStat++] = (int)affectedRows;
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        return this.insertId;
    }

    public int[] getAffectedRows() {
        return this.affectedRows;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows.length > 0 && this.affectedRows[0] > 1;
    }

    @Override
    public int getFirstAffectedRows() {
        return this.affectedRows[0];
    }

    @Override
    public void addStatsError() {
        this.insertId[this.currentStat] = -3L;
        this.affectedRows[this.currentStat++] = -3;
    }

    public void updateResultsForRewrite() {
        long totalAffectedRows = 0L;
        int row = 0;
        while (row < this.affectedRows.length && this.affectedRows[row] > 0) {
            totalAffectedRows += (long)this.affectedRows[row++];
        }
        int resultVal = totalAffectedRows == (long)this.affectedRows.length ? 1 : -2;
        for (row = 0; row < this.affectedRows.length; ++row) {
            this.affectedRows[row] = resultVal;
        }
    }

    public void updateResultsMultiple(Deque<ExecutionResult> cachedExecutionResults) {
        for (int i2 = 1; i2 < this.affectedRows.length; ++i2) {
            SingleExecutionResult executionResult = (SingleExecutionResult)cachedExecutionResults.poll();
            this.affectedRows[i2] = (int)executionResult.getAffectedRows();
            this.insertId[i2] = executionResult.getInsertId();
        }
        if (!cachedExecutionResults.isEmpty()) {
            SingleExecutionResult executionResult;
            int[] newAffectedRows = new int[this.affectedRows.length + cachedExecutionResults.size()];
            long[] newInsertIds = new long[this.insertId.length + cachedExecutionResults.size()];
            for (int counter = 0; counter < this.affectedRows.length; ++counter) {
                newAffectedRows[counter] = this.affectedRows[counter];
                newInsertIds[counter] = this.insertId[counter];
            }
            while ((executionResult = (SingleExecutionResult)cachedExecutionResults.poll()) != null) {
                newAffectedRows[counter] = (int)executionResult.getAffectedRows();
                newInsertIds[counter++] = executionResult.getInsertId();
            }
            this.affectedRows = newAffectedRows;
            this.insertId = newInsertIds;
        }
    }
}

