/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class SerializableParameter
extends LongDataParameterHolder {
    private Object object;
    private boolean noBackSlashEscapes;
    private byte[] loadedStream = null;

    public SerializableParameter(Object object, boolean noBackslashEscapes) throws IOException {
        this.object = object;
        this.noBackSlashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.loadedStream != null) {
            ParameterWriter.write(os, this.loadedStream, this.noBackSlashEscapes);
        } else {
            ParameterWriter.writeObject(os, this.object, this.noBackSlashEscapes);
        }
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        this.loadedStream = baos.toByteArray();
        this.object = null;
        return this.loadedStream.length;
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.object);
        os.write(baos.toByteArray());
    }

    @Override
    public String toString() {
        return "<Serializable> " + this.object;
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }
}

