/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.couchbase.mock.control.CommandNotFoundException;
import org.couchbase.mock.control.MockCommandDispatcher;
import org.couchbase.mock.control.handlers.MockHelpCommandHandler;

public class ControlHandler
implements HttpHandler {
    private final MockCommandDispatcher dispatcher;

    public ControlHandler(MockCommandDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static JsonObject parseQueryParams(HttpExchange exchange) throws InvalidQueryException {
        String query = exchange.getRequestURI().getRawQuery();
        JsonObject payload = new JsonObject();
        JsonParser parser = new JsonParser();
        if (query == null) {
            throw new InvalidQueryException();
        }
        for (String kv : query.split("&")) {
            JsonElement optVal;
            String[] parts = kv.split("=");
            if (parts.length != 2) {
                throw new InvalidQueryException();
            }
            String optName = parts[0];
            try {
                optVal = parser.parse(URLDecoder.decode(parts[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidQueryException();
            }
            payload.add(optName, optVal);
        }
        return payload;
    }

    private static void sendHelpText(HttpExchange exchange, int code) throws IOException {
        byte[] ret = MockHelpCommandHandler.getIndentedHelp().getBytes();
        exchange.sendResponseHeaders(code, ret.length);
        exchange.getResponseBody().write(ret);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            this._handle(exchange);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void _handle(HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getPath();
        path = path.replaceFirst("^/+", "");
        String[] components = path.split("/");
        OutputStream body = exchange.getResponseBody();
        exchange.getResponseHeaders().set("Content-Type", "application/json");
        try {
            if (components.length != 2) {
                throw new CommandNotFoundException("/mock/<COMMAND>", null);
            }
            if (components[1].equals("help")) {
                throw new WantHelpException();
            }
            JsonObject payload = ControlHandler.parseQueryParams(exchange);
            String cmdStr = URLDecoder.decode(components[1], "UTF-8");
            byte[] response = this.dispatcher.dispatch(cmdStr, payload).toString().getBytes();
            exchange.sendResponseHeaders(200, response.length);
            body.write(response);
        }
        catch (WantHelpException e) {
            ControlHandler.sendHelpText(exchange, 200);
        }
        catch (CommandNotFoundException e) {
            ControlHandler.sendHelpText(exchange, 404);
        }
        catch (InvalidQueryException e) {
            ControlHandler.sendHelpText(exchange, 400);
        }
        catch (RuntimeException e) {
            exchange.sendResponseHeaders(500, -1L);
            e.printStackTrace(new PrintWriter(body));
            throw e;
        }
        finally {
            body.close();
        }
    }

    private class WantHelpException
    extends Exception {
        private WantHelpException() {
        }
    }

    private static class InvalidQueryException
    extends Exception {
        private InvalidQueryException() {
        }
    }
}

