package Net::Async::Spotify::API::Generated::Browse;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Browse - Package representing Spotify Browse API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 get_a_categories_playlists

get_a_categories_playlists - Get a Category's Playlists

Get a list of Spotify playlists tagged with a particular category.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 path_parameter

=over 4

=item category_id

Type: string | Required: required
The Spotify category ID for the category.

=back

=head3 query_parameter

=over 4

=item country

Type: string | Required: optional
A country: an ISO 3166-1 alpha-2 country code. Provide this parameter to ensure that the category exists for a particular country.

=item limit

Type: integer | Required: optional
The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.

=item offset

Type: integer | Required: optional
The index of the first item to return. Default: 0 (the first object). Use with limit to get the next set of items.

=back

and Response Objects being:

- playlist object


On success, the HTTP status code in the response header is 200 OK and the response body contains an array of simplified playlist objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Once you have retrieved the list, you can use Get a Playlist and Get a Playlist’s Tracks to drill down further.Try in our Web Console

=cut

async sub get_a_categories_playlists {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_a_categories_playlists}{method} // 'GET';
    $request->{uri}    = $mapping->{get_a_categories_playlists}{uri} // 'https://api.spotify.com/v1/browse/categories/{category_id}/playlists';
    $request->{param}  = $mapping->{get_a_categories_playlists}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'category_id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'country' => {
                type     => 'string',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_a_categories_playlists}{response} // [
        'playlist object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_a_category

get_a_category - Get a Category

Get a single category used to tag items in Spotify (on, for example, the Spotify player’s “Browse” tab).

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 path_parameter

=over 4

=item category_id

Type: string | Required: required
The Spotify category ID for the category.

=back

=head3 query_parameter

=over 4

=item country

Type: string | Required: optional
A country: an ISO 3166-1 alpha-2 country code. Provide this parameter to ensure that the category exists for a particular country.

=item locale

Type: string | Required: optional
The desired language, consisting of an ISO 639-1 language code and an ISO 3166-1 alpha-2 country code, joined by an underscore. For example: es_MX, meaning "Spanish (Mexico)". Provide this parameter if you want the category strings returned in a particular language. Note that, if locale is not supplied, or if the specified language is not available, the category strings returned will be in the Spotify default language (American English).

=back

and Response Objects being:

- category object


On success, the HTTP status code in the response header is 200 OK and the response body contains a category object in JSON format. On error, the header status code is an error code and the response body contains an error object.Once you have retrieved the category, you can use Get a Category’s Playlists to drill down further.Try in our Web Console

=cut

async sub get_a_category {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_a_category}{method} // 'GET';
    $request->{uri}    = $mapping->{get_a_category}{uri} // 'https://api.spotify.com/v1/browse/categories/{category_id}';
    $request->{param}  = $mapping->{get_a_category}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        path_parameter => {
            'category_id' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'country' => {
                type     => 'string',
                required => 'optional',
            },
            'locale' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_a_category}{response} // [
        'category object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_categories

get_categories - Get All Categories

Get a list of categories used to tag items in Spotify (on, for example, the Spotify player’s “Browse” tab).

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 query_parameter

=over 4

=item country

Type: string | Required: optional
A country: an ISO 3166-1 alpha-2 country code. Provide this parameter if you want to narrow the list of returned categories to those relevant to a particular country. If omitted, the returned items will be globally relevant.

=item limit

Type: integer | Required: optional
The maximum number of categories to return. Default: 20. Minimum: 1. Maximum: 50.

=item locale

Type: string | Required: optional
The desired language, consisting of an ISO 639-1 language code and an ISO 3166-1 alpha-2 country code, joined by an underscore. For example: es_MX, meaning “Spanish (Mexico)”. Provide this parameter if you want the category metadata returned in a particular language. Note that, if locale is not supplied, or if the specified language is not available, all strings will be returned in the Spotify default language (American English). The locale parameter, combined with the country parameter, may give odd results if not carefully matched. For example country=SE&locale=de_DE will return a list of categories relevant to Sweden but as German language strings.

=item offset

Type: integer | Required: optional
The index of the first item to return. Default: 0 (the first object). Use with limit to get the next set of categories.

=back

and Response Objects being:

- an object


On success, the HTTP status code in the response header is 200 OK and the response body contains an object with a categories field, with an array of category objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Once you have retrieved the list, you can use Get a Category to drill down further.Try in our Web Console

=cut

async sub get_categories {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_categories}{method} // 'GET';
    $request->{uri}    = $mapping->{get_categories}{uri} // 'https://api.spotify.com/v1/browse/categories';
    $request->{param}  = $mapping->{get_categories}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'country' => {
                type     => 'string',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'locale' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_categories}{response} // [
        'an object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_featured_playlists

get_featured_playlists - Get All Featured Playlists

Get a list of Spotify featured playlists (shown, for example, on a Spotify player’s ‘Browse’ tab).

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 query_parameter

=over 4

=item country

Type: string | Required: optional
A country: an ISO 3166-1 alpha-2 country code. Provide this parameter if you want the list of returned items to be relevant to a particular country. If omitted, the returned items will be relevant to all countries.

=item limit

Type: integer | Required: optional
The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.

=item locale

Type: string | Required: optional
The desired language, consisting of a lowercase ISO 639-1 language code and an uppercase ISO 3166-1 alpha-2 country code, joined by an underscore. For example: es_MX, meaning “Spanish (Mexico)”. Provide this parameter if you want the results returned in a particular language (where available). Note that, if locale is not supplied, or if the specified language is not available, all strings will be returned in the Spotify default language (American English). The locale parameter, combined with the country parameter, may give odd results if not carefully matched. For example country=SE&locale=de_DE will return a list of categories relevant to Sweden but as German language strings.

=item offset

Type: integer | Required: optional
The index of the first item to return. Default: 0 (the first object). Use with limit to get the next set of items.

=item timestamp

Type: string | Required: optional
A timestamp in ISO 8601 format: yyyy-MM-ddTHH:mm:ss. Use this parameter to specify the user’s local time to get results tailored for that specific date and time in the day. If not provided, the response defaults to the current UTC time. Example: “2014-10-23T09:00:00” for a user whose local time is 9AM. If there were no featured playlists (or there is no data) at the specified time, the response will revert to the current UTC time.

=back

and Response Objects being:

- playlist object
- playlist object


On success, the HTTP status code in the response header is 200 OK and the response body contains a message and a playlists object. The playlists object contains an array of simplified playlist objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Once you have retrieved the list of playlist objects, you can use Get a Playlist and Get a Playlist’s Tracks to drill down further.Try in our Web Console

=cut

async sub get_featured_playlists {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_featured_playlists}{method} // 'GET';
    $request->{uri}    = $mapping->{get_featured_playlists}{uri} // 'https://api.spotify.com/v1/browse/featured-playlists';
    $request->{param}  = $mapping->{get_featured_playlists}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'country' => {
                type     => 'string',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'locale' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
            'timestamp' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_featured_playlists}{response} // [
        'playlist object',
        'playlist object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_new_releases

get_new_releases - Get All New Releases

Get a list of new album releases featured in Spotify (shown, for example, on a Spotify player’s “Browse” tab).

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 query_parameter

=over 4

=item country

Type: string | Required: optional
A country: an ISO 3166-1 alpha-2 country code. Provide this parameter if you want the list of returned items to be relevant to a particular country. If omitted, the returned items will be relevant to all countries.

=item limit

Type: integer | Required: optional
The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.

=item offset

Type: integer | Required: optional
The index of the first item to return. Default: 0 (the first object). Use with limit to get the next set of items.

=back

and Response Objects being:

- album object


On success, the HTTP status code in the response header is 200 OK and the response body contains a message and analbums object. The albums object contains an array of simplified album objects (wrapped in a paging object) in JSON format. On error, the header status code is an error code and the response body contains an error object.Once you have retrieved the list, you can use Get an Album’s Tracks to drill down further.The results are returned in an order reflected within the Spotify clients, and therefore may not be ordered by date.Try in our Web Console

=cut

async sub get_new_releases {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_new_releases}{method} // 'GET';
    $request->{uri}    = $mapping->{get_new_releases}{uri} // 'https://api.spotify.com/v1/browse/new-releases';
    $request->{param}  = $mapping->{get_new_releases}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'country' => {
                type     => 'string',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'offset' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_new_releases}{response} // [
        'album object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_recommendation_genres

get_recommendation_genres - Get Recommendation Genres

Retrieve a list of available genres seed parameter values for recommendations.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

and Response Objects being:

- response object


On success, the HTTP status code in the response header is 200 OK and the response body contains a recommendations response object in JSON format.Try in our Web Console

=cut

async sub get_recommendation_genres {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_recommendation_genres}{method} // 'GET';
    $request->{uri}    = $mapping->{get_recommendation_genres}{uri} // 'https://api.spotify.com/v1/recommendations/available-genre-seeds';
    $request->{param}  = $mapping->{get_recommendation_genres}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_recommendation_genres}{response} // [
        'response object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_recommendations

get_recommendations - Get Recommendations

Recommendations are generated based on the available information for a given seed entity and matched against similar artists and tracks. If there is sufficient information about the provided seeds, a list of tracks will be returned together with pool size details.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid user access token or your client credentials.

=back

=head3 query_parameter

=over 4

=item limit

Type: integer | Required: optional
The target size of the list of recommended tracks. For seeds with unusually small pools or when highly restrictive filtering is applied, it may be impossible to generate the requested number of recommended tracks. Debugging information for such cases is available in the response. Default: 20. Minimum: 1. Maximum: 100.

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code or the string from_token. Provide this parameter if you want to apply Track Relinking. Because min_*, max_* and target_* are applied to pools before relinking, the generated results may not precisely match the filters applied. Original, non-relinked tracks are available via the linked_from attribute of the relinked track response.

=item max_acousticness

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_danceability

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_duration_ms

Type: integer | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_energy

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_instrumentalness

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_key

Type: integer | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_liveness

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_loudness

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_mode

Type: integer | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_popularity

Type: integer | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_speechiness

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_tempo

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_time_signature

Type: integer | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item max_valence

Type: number | Required: optional
For each tunable track attribute, a hard ceiling on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, max_instrumentalness=0.35 would filter out most tracks that are likely to be instrumental.

=item min_acousticness

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_danceability

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_duration_ms

Type: integer | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_energy

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_instrumentalness

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_key

Type: integer | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_liveness

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_loudness

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_mode

Type: integer | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_popularity

Type: integer | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_speechiness

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_tempo

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_time_signature

Type: integer | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item min_valence

Type: number | Required: optional
For each tunable track attribute, a hard floor on the selected track attribute’s value can be provided. See tunable track attributes below for the list of available options. For example, min_tempo=140 would restrict results to only those tracks with a tempo of greater than 140 beats per minute.

=item seed_artists

Type: string | Required: required
A comma separated list of Spotify IDs for seed artists.  Up to 5 seed values may be provided in any combination of seed_artists, seed_tracks and seed_genres.

=item seed_genres

Type: string | Required: required
A comma separated list of any genres in the set of available genre seeds.  Up to 5 seed values may be provided in any combination of seed_artists, seed_tracks and seed_genres.

=item seed_tracks

Type: string | Required: required
A comma separated list of Spotify IDs for a seed track.  Up to 5 seed values may be provided in any combination of seed_artists, seed_tracks and seed_genres.

=item target_acousticness

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_danceability

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_duration_ms

Type: integer | Required: optional
Target duration of the track (ms)

=item target_energy

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_instrumentalness

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_key

Type: integer | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_liveness

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_loudness

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_mode

Type: integer | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_popularity

Type: integer | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_speechiness

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_tempo

Type: number | Required: optional
Target tempo (BPM)

=item target_time_signature

Type: integer | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=item target_valence

Type: number | Required: optional
For each of the tunable track attributes (below) a target value may be provided. Tracks with the attribute values nearest to the target values will be preferred. For example, you might request target_energy=0.6 and target_danceability=0.8. All target values will be weighed equally in ranking results.

=back

and Response Objects being:

- response object


On success, the HTTP status code in the response header is 200 OK and the response body contains a recommendations response object in JSON format.Try in our Web Console

=cut

async sub get_recommendations {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_recommendations}{method} // 'GET';
    $request->{uri}    = $mapping->{get_recommendations}{uri} // 'https://api.spotify.com/v1/recommendations';
    $request->{param}  = $mapping->{get_recommendations}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
            'max_acousticness' => {
                type     => 'number',
                required => 'optional',
            },
            'max_danceability' => {
                type     => 'number',
                required => 'optional',
            },
            'max_duration_ms' => {
                type     => 'integer',
                required => 'optional',
            },
            'max_energy' => {
                type     => 'number',
                required => 'optional',
            },
            'max_instrumentalness' => {
                type     => 'number',
                required => 'optional',
            },
            'max_key' => {
                type     => 'integer',
                required => 'optional',
            },
            'max_liveness' => {
                type     => 'number',
                required => 'optional',
            },
            'max_loudness' => {
                type     => 'number',
                required => 'optional',
            },
            'max_mode' => {
                type     => 'integer',
                required => 'optional',
            },
            'max_popularity' => {
                type     => 'integer',
                required => 'optional',
            },
            'max_speechiness' => {
                type     => 'number',
                required => 'optional',
            },
            'max_tempo' => {
                type     => 'number',
                required => 'optional',
            },
            'max_time_signature' => {
                type     => 'integer',
                required => 'optional',
            },
            'max_valence' => {
                type     => 'number',
                required => 'optional',
            },
            'min_acousticness' => {
                type     => 'number',
                required => 'optional',
            },
            'min_danceability' => {
                type     => 'number',
                required => 'optional',
            },
            'min_duration_ms' => {
                type     => 'integer',
                required => 'optional',
            },
            'min_energy' => {
                type     => 'number',
                required => 'optional',
            },
            'min_instrumentalness' => {
                type     => 'number',
                required => 'optional',
            },
            'min_key' => {
                type     => 'integer',
                required => 'optional',
            },
            'min_liveness' => {
                type     => 'number',
                required => 'optional',
            },
            'min_loudness' => {
                type     => 'number',
                required => 'optional',
            },
            'min_mode' => {
                type     => 'integer',
                required => 'optional',
            },
            'min_popularity' => {
                type     => 'integer',
                required => 'optional',
            },
            'min_speechiness' => {
                type     => 'number',
                required => 'optional',
            },
            'min_tempo' => {
                type     => 'number',
                required => 'optional',
            },
            'min_time_signature' => {
                type     => 'integer',
                required => 'optional',
            },
            'min_valence' => {
                type     => 'number',
                required => 'optional',
            },
            'seed_artists' => {
                type     => 'string',
                required => 'required',
            },
            'seed_genres' => {
                type     => 'string',
                required => 'required',
            },
            'seed_tracks' => {
                type     => 'string',
                required => 'required',
            },
            'target_acousticness' => {
                type     => 'number',
                required => 'optional',
            },
            'target_danceability' => {
                type     => 'number',
                required => 'optional',
            },
            'target_duration_ms' => {
                type     => 'integer',
                required => 'optional',
            },
            'target_energy' => {
                type     => 'number',
                required => 'optional',
            },
            'target_instrumentalness' => {
                type     => 'number',
                required => 'optional',
            },
            'target_key' => {
                type     => 'integer',
                required => 'optional',
            },
            'target_liveness' => {
                type     => 'number',
                required => 'optional',
            },
            'target_loudness' => {
                type     => 'number',
                required => 'optional',
            },
            'target_mode' => {
                type     => 'integer',
                required => 'optional',
            },
            'target_popularity' => {
                type     => 'integer',
                required => 'optional',
            },
            'target_speechiness' => {
                type     => 'number',
                required => 'optional',
            },
            'target_tempo' => {
                type     => 'number',
                required => 'optional',
            },
            'target_time_signature' => {
                type     => 'integer',
                required => 'optional',
            },
            'target_valence' => {
                type     => 'number',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_recommendations}{response} // [
        'response object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
