package Net::Async::Spotify::Object::Generated::ExplicitContentSettings;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::ExplicitContentSettings - Package representing Spotify ExplicitContentSettings Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify ExplicitContentSettings Object attributes:

=over 4

=item filter_enabled

Type:Boolean
Description:When true, indicates that explicit content should not be played.

=item filter_locked

Type:Boolean
Description:When true, indicates that the explicit content setting is locked and can’t be changed by the user.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        filter_enabled => 'Boolean',
        filter_locked => 'Boolean',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
