package App::Zealc::Command::list;

use 5.014000;
use strict;
use warnings;

our $VERSION = '0.000_001';

use App::Zealc '-command';
use Term::FormatColumns qw/format_columns/;

sub opt_spec {
	(['long|l', 'Display more information about each docset'])
}

sub execute {
	my ($self, $opts, $args) = @_;
	if ($opts->{long}) {
		my $maxlen = 0;
		my @args;
		for my $set (sort {$a->name cmp $b->name} $self->app->zeal->sets) {
			push @args, [$set->name, $set->family];
			$maxlen = length $set->name if length $set->name > $maxlen
		}
		printf "%-${maxlen}s %s:\n", @$_ for @args;
	} else {
		my @sets = sort map {$_->name} $self->app->zeal->sets;
		print format_columns @sets;
	}
}

1;
__END__

=encoding utf-8

=head1 NAME

App::Zealc::Command::list - list the installed docsets

=head1 SYNOPSIS

  zealc list
  # Ansible       Bootstrap 3   Perl          Sass

  zealc list -l
  # Ansible     ansible:
  # Bootstrap 3 bootstrap:
  # Perl        perl:
  # Sass        sass:

=head1 DESCRIPTION

The list command displays the installed docsets. With the -l argument
it also displays their keywords.

=head1 SEE ALSO

L<zealc>, L<Zeal>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
