package WordList::Phrase::ZH::CCIC;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_unicode",30001,"num_words",30001,"avg_word_len",2.35575480817306,"shortest_word_len",2,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"longest_word_len",7); # STATS

1;
# ABSTRACT: Mainland Mandarin vocabulary from Chinese Community Information Center

=pod

=encoding UTF-8

=head1 NAME

WordList::Phrase::ZH::CCIC - Mainland Mandarin vocabulary from Chinese Community Information Center

=head1 VERSION

This document describes version 0.01 of WordList::Phrase::ZH::CCIC (from Perl distribution WordList-Phrase-ZH-CCIC), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::Phrase::ZH::CCIC;

 my $wl = WordList::Phrase::ZH::CCIC->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 2.35575480817306 |
 | longest_word_len                 | 7                |
 | num_words                        | 30001            |
 | num_words_contains_nonword_chars | 0                |
 | num_words_contains_unicode       | 30001            |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 2                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-Phrase-ZH-CCIC>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-Phrase-ZH-CCIC>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-Phrase-ZH-CCIC>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<http://www.ifcss.org>

L<http://technology.chtsai.org/wordlist/>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一下
一世
一丝一毫
一丝不苟
一个劲儿
一举
一举两得
一事
一事无成
一二
一五一十
一些
一介
一任
一体
一例
一偏
一元化
一元论
一共
一再
一准
一刀切
一分为二
一分子
一切
一刻
一力
一动
一劳永逸
一千
一去不复返
一又
一发
一口
一口咬定
一口气
一句话
一叶
一同
一向
一味
一场空
一堆
一壁
一声不响
一天
一天到晚
一夫
一夫一妻制
一头
一如
一如既往
一定
一对一
一小撮
一山
一己
一帆风顺
一带
一席话
一干
一干二净
一年到头
一年四季
一并
一应
一度
一律
一得
一心
一心一意
一忽儿
一总
一意孤行
一成不变
一手
一把手
一把抓
一抹
一无
一无所知
一日
一旦
一早
一时
一时一刻
一是
一晃
一曲
一朝
一本正经
一条龙
一来
一概
一概而论
一模一样
一次
一次方程
一毫
一民
一气
一清二楚
一清早
一点一滴
一点儿
一片
一班人
一生
一番
一目了然
一直
一眨眼
一瞥
一瞬
一窍不通
一端
一笔勾销
一等
一筹莫展
一系列
一线
一经
一统
一网打尽
一脉相承
一致
一般化
一般等价物
一般说来
一色
一行
一视同仁
一览
一角
一言堂
一败涂地
一贯
一起
一路
一蹶不振
一身
一辈子
一边
一连
一道
一部分
一间
一阵
一隅
一青
一面
一齐
丁二烯
丁基橡胶
丁烯
丁烷
丁男
丁种维生素
丁腈橡胶
丁苯橡胶
丁酸
丁醇
丁香
七一
七七
七公
七声
七尺
七律
七手八脚
七星
七星岩
七步
七音
万一
万万
万丈
万世
万事
万事大吉
万代
万众
万众一心
万全
万分
万千
万历
万县
万古
万古长青
万向节
万寿无疆
万岁
万年
万恶
万户
万方
万无一失
万有
万有引力
万物
万状
万用电表
万福
万紫千红
万能
万象
万里长城
万里长征
万难
万马奔腾
丈人
丈夫
丈量
三七
三三两两
三世
三个世界
三九
三从四德
三代
三侠五义
三元
三元里
三公
三关
三军
三原
三叉戟
三台
三叶期
三合
三同
三吴
三和弦
三品
三国
三国志
三国演义
三复
三大差别
三大政策
三大革命运动
三好
三季
三定
三宝
三害
三尺
三峡
三师
三废
三座大山
三张
三弦
三户
三才
三方
三时
三星
三春柳
三更
三权分立
三极管
三棱
三棱镜
三正
三段式
三民主义
三水
三法
三生
三百篇
三相
三礼
三秋
三纲五常
三结合
三统
三老
三老四严
三脚架
三节
三行
三角
三角函数
三角学
三角形
三角方程
三角板
三角洲
三角皮带
三言两语
三轮车
三通
三通阀
三部曲
三长制
三门
三门峡
三青团
三面红旗
三项式
三餐
三麦
上万
上上
上下
上世
上中农
上乘
上书
上交
上人
上代
上任
上体
上供
上光
上党
上关
上农
上列
上前
上升
上午
上原
上去
上变
上口
上古
上台
上司
上吊
上告
上品
上国
上场
上声
上夜
上天
上头
上好
上学
上官
上将
上尉
上层
上层建筑
上届
上山
上山下乡
上岸
上工
上市
上帝
上年
上床
上弦
上当
上心
上思
上房
上手
上报
上操
上文
上日
上旬
上明
上映
上来
上杭
上林
上校
上次
上水
上沃尔特
上油
上流
上浆
上海
上涨
上清
上游
上溯
上演
上火
上灯
上班
上皮
上盘
上相
上真
上石
上空
上章
上第
上等
上算
上簇
上紧
上级
上缴
上缴利润
上联
上肢
上臂
上色
上蜡
上行
上街
上衣
上装
上计
上议院
上访
上诉
上课
上谕
上路
上身
上轨道
上边
上达
上进
上述
上部
上金
上铺
上门
上阵
上限
上集
上面
上颌
上风
上首
上马
下一步
下中农
下乡
下人
下令
下作
下关
下凡
下列
下午
下半夜
下厂
下去
下发
下台
下同
下品
下回
下土
下地
下场
下坡路
下垂
下处
下头
下子
下官
下定
下层
下属
下山
下工
下巴
下弦
下情
下意识
下手
下摆
下放
下文
下方
下旬
下木
下来
下棋
下次
下毒手
下水
下水道
下沉
下河
下法
下流
下海
下游
下滑
下狱
下班
下生
下痢
下盘
下直
下相
下种
下笔
下第
下等
下级
下结论
下联
下肢
下脚
下脚料
下落
下蛋
下行
下课
下贱
下走
下身
下车
下边
下达
下酒
下降
下限
下面
下颌
下颚
下马
不一
不一而足
不中
不中用
不久
不乏
不了
不予
不争气
不仁
不仅
不仅仅
不仅仅是
不以为然
不休
不会
不但
不但是
不依
不便
不借
不值
不做声
不光
不克
不免
不公
不共戴天
不关
不兴
不准
不凡
不分
不切实际
不利
不力
不动产
不动声色
不劳而获
不单
不厌
不及
不变
不变资本
不只
不可
不可一世
不可告人
不可多得
不可思议
不可想象
不可战胜
不可捉摸
不可知论
不可磨灭
不可终日
不可胜数
不可避免
不合
不同
不名数
不含糊
不和
不善
不图
不在
不在乎
不在了
不在意
不堪
不堪设想
不备
不外
不多见
不够
不失为
不失时机
不好意思
不如
不妙
不妥
不妨
不孕
不孝
不安
不定
不定根
不宜
不客气
不容
不对
不对头
不少
不尽
不尽然
不屈
不屈不挠
不屑
不巧
不已
不干涉
不平
不平等条约
不平衡
不幸
不当
不待
不待说
不得
不得不
不得了
不得人心
不得已
不得而知
不必
不必要
不忍
不忙
不快
不怎么
不怕
不惜
不惟
不惯
不意
不愧
不慎
不懈
不成
不折不扣
不拘
不择手段
不振
不敏
不敢
不敢当
不散
不敬
不文
不料
不断
不断革命论
不无
不日
不时
不明
不是
不景气
不暇
不曾
不服
不朽
不果
不根
不止
不正之风
不比
不法
不测
不消
不满
不灵
不然
不特
不犯
不独
不理
不甘
不甘心
不用
不用说
不由分说
不由得
不由自主
不相上下
不相容
不相干
不知
不知不觉
不知所措
不短
不破不立
不祥
不禁
不符
不第
不等
不等价交换
不等号
不等式
不简单
不管
不约而同
不经济
不结盟
不结盟国家
不结盟运动
不置
不肖
不胜
不胜枚举
不能
不能不
不自在
不至于
不致
不良
不良倾向
不良导体
不行
不行了
不要
不要紧
不要脸
不见
不见了
不见得
不规则
不解
不言而喻
不计
不计其数
不讲条件
不许
不论
不该
不谓
不象样
不象话
不足
不足为奇
不足道
不轨
不过
不过如此
不迟
不迭
不送
不适
不透明
不透水
不通
不道德
不遗余力
不配
不锈钢
不错
不问
不顾
与与
与众不同
与会
与共
与其
与国
与日俱增
与此同时
丑剧
丑化
丑态
丑恶
丑陋
专一
专业
专业公司
专业化
专业教育
专业知识
专业课
专业银行
专人
专任
专使
专利
专利权
专制
专制制度
专区
专卖
专员
专家
专属经济区
专心
专心致志
专政
专断
专机
专权
专栏
专案
专横
专款
专注
专用
专用基金
专用线
专电
专科学校
专程
专职
专著
专责
专车
专长
专门
专门人民法院
专门化
专门机构
专题
专题讨论
世上
世事
世人
世仇
世代
世俗
世兄
世家
世界
世界大战
世界市场
世界报
世界文化
世界经济危机
世界观
世界货币
世系
世纪
世纪末
世臣
世袭
世道
世间
丘陵
丙丁
丙烯酸
丙烷
丙纶
丙酮
业主
业务
业已
业经
业绩
丛书
丛刊
丛林
丛生
丛谈
东三省
东乡
东亚
东京
东北
东北军
东升
东南
东南亚
东南亚国家联盟
东印度
东印度公司
东厂
东吴
东周
东坡
东城
东夷
东安
东宫
东家
东山
东帝汶
东平
东张西望
东德
东捻军
东方
东方红
东晋
东来
东欧
东欧平原
东汉
东洋
东流
东海
东湖
东经
东至
东西
东边
东道
东郊
东都
东门
东阳
东陵
东非
东面
东风
东魏
丝光
丝弦
丝束
丝毫
丝状
丝瓜
丝素
丝线
丝织厂
丝织品
丝绒
丝绸
丝绸之路
丝网
丝胶
丞相
丢人
丢失
丢弃
丢掉
丢脸
两利
两口子
两回事
两头
两审终审制
两广
两性
两手
两旁
两晋
两条腿走路
两条道路
两极
两极分化
两栖
两样
两汉
两江
两河
两淮
两湖
两潘
两班
两相
两码事
两立
两端
两翼
两者
两肋
两脚规
两边
两造
两重
两重性
两霸
两面
两面性
两面派
严令
严冬
严刑
严办
严厉
严复
严守
严密
严寒
严峻
严惩
严整
严明
严格
严正
严禁
严肃
严词
严酷
严重
严重事故
严重性
严防
丧事
丧命
丧失
丧服
丧气
丧胆
丧钟
个个
个人
个人主义
个人利益
个人得失
个人消费
个位
个体
个体发育
个体所有制
个体手工业
个体经济
个儿
个别
个别差异
个别生产价格
个子
个性
个把
个旧
个里
丫头
中上
中专
中世纪
中东
中书令
中亚
中人
中介
中伤
中位数
中使
中保
中共
中共中央
中兴
中军
中农
中医
中午
中华
中华书局
中华民族
中南
中卫
中原
中古
中叶
中听
中和
中固
中国
中国人民
中国同盟会
中国工人
中国文学
中国画
中国社会科学院
中土
中坚
中垂线
中型
中外
中天
中央
中央军
中央委员会
中央情报局
中央政府
中央集权
中央革命根据地
中子
中子星
中学
中学生
中将
中尉
中小
中小学
中局
中层
中山
中州
中常
中平
中年
中庸
中式
中弹
中微子
中德
中心
中心任务
中心体
中心内容
中心对称
中心思想
中心角
中性
中性染料
中情
中意
中指
中支
中文
中断
中旬
中景
中暑
中朝
中期
中极
中枢
中枢神经
中栏
中校
中欧
中止
中段
中毒
中气
中法战争
中波
中派
中流
中游
中点
中生代
中用
中看
中知
中短波
中碳钢
中秋
中秋节
中程
中稻
中立
中立国
中等
中等专业学校
中等教育
中级
中级人民法院
中纬度
中线
中经
中统
中继
中继站
中美
中美洲
中耕
中肯
中草药
中药
中营
中落
中行
中表
中装
中西
中计
中论
中距离
中路
中转
中近东
中选
中途
中道
中部
中铁
中锋
中间
中间人
中间体
中队
中青年
中非
中频
中风
中饭
中饱
中黄
中龄林
丰产
丰产田
丰功伟绩
丰南
丰厚
丰台
丰富
丰富多彩
丰富多采
丰年
丰收
丰沛
丰满
丰盛
丰硕
串联
串通
临刑
临到
临危不惧
临头
临安
临床
临摹
临时
临时代办
临时工
临死
临水
临汾
临海
临清
临界
临界压
临界温度
临界点
临终
临行
临近
丸子
丹徒
丹心
丹田
丹阳
丹顿
丹麦
为主
为了
为人
为什么
为何
为力
为名
为我
为所欲为
为数
为期
为止
为此
为生
为着
为重
为间
为难
为非作歹
为首
主义
主事
主人
主人公
主人翁
主从
主任
主任委员
主伐
主体
主值
主刑
主力
主力军
主办
主动
主动权
主动轴
主名
主妇
主子
主客
主宰
主导
主将
主峰
主帅
主席
主席团
主干
主应力
主张
主意
主持
主攻
主教
主旋律
主旨
主机
主权
主权国
主枝
主根
主次
主流
主犯
主笔
主管
主编
主要
主要原因
主要树种
主要矛盾
主要问题
主见
主观
主观主义
主观和客观
主观唯心主义
主观能动性
主视图
主讲
主轴
主音
主顾
主题
主食
举世
举世闻名
举事
举人
举例
举凡
举动
举国
举国上下
举手
举杯
举止
举目
举行
举足轻重
举重
乃是
乃至
久久
久仰
久已
久而久之
久远
久违
义务
义务劳动
义勇
义勇军
义和团
义和团运动
义和拳
义士
义律
义愤
义旗
义气
义理
之上
之下
之中
之内
之前
之后
之外
之所以
之无
之间
乌云
乌克兰
乌尔
乌干达
乌托邦
乌拉
乌桓
乌江
乌苏
乌苏里江
乌达
乌鲁木齐
乌鸦
乌黑
乌龙茶
乌龟
乍得
乏味
乏汽
乐于
乐句
乐器
乐团
乐园
乐土
乐天
乐山
乐府
乐得
乐意
乐曲
乐段
乐章
乐观
乐谱
乐趣
乐队
乐音
乒乓
乒乓球
乔木
乔治
乔治敦
乖乖
乘号
乘客
乘数
乘方
乘机
乘法
乘积
乘胜
乘间
乘除
乘风破浪
乙丙橡胶
乙二醇
乙炔
乙烯
乙烷
乙种维生素
乙苯
乙酰
乙酸
乙醇
乙醚
乙醛
九九
九九表
九五
九卿
九品
九品中正
九天
九州
九成
九月
九江
九泉
九百
九皋
九章
九章算术
九经
九龙
乞丐
乞求
乞讨
也先
也好
也是
也罢
也许
也门
习俗
习性
习惯
习惯性
习惯法
习气
习用
习见
习题
乡下
乡亲
乡人
乡党
乡勇
乡土
乡村
乡绅
乡里
乡镇
乡间
书信
书写
书刊
书包
书卷
书名
书后
书呆子
书学
书局
书店
书房
书报
书斋
书本
书架
书法
书生
书画
书目
书简
书籍
书经
书记
书院
书面
买主
买价
买办
买办阶级
买卖
买卖人
买进
乱七八糟
乱世
乱动
乱哄哄
乱子
乱真
乱跑
乳儿
乳制品
乳剂
乳化
乳化剂
乳头
乳房
乳母
乳汁
乳浊液
乳液聚合
乳牛
乳白
乳白色
乳粉
乳糖
乳胶
乳酸
乾坤
乾隆
了不得
了不起
了事
了得
了望
了结
了解
了解情况
予以
争先
争先恐后
争光
争分夺秒
争取
争吵
争夺
争夺战
争执
争持
争斗
争权夺利
争端
争艳
争议
争论
争辩
争霸
争鸣
事与愿违
事业
事业单位
事事
事件
事体
事例
事儿
事先
事前
事务
事变
事后
事宜
事实
事实上
事态
事情
事故
事机
事权
事物
事理
事由
事端
事迹
事项
二万
二万五千里长征
二三
二亿
二倍体
二元
二元论
二八
二副
二十一条
二十四史
二十天
二千
二哥
二天
二姐
二年生
二年级
二弦
二心
二把手
二指
二来
二极管
二次方程
二次电子
二次破碎
二次革命
二段式
二氧化氮
二氧化硅
二氧化硫
二氧化碳
二氧化锰
二氯乙烷
二甲苯
二百二
二百五
二硫化碳
二硫化钼
二等
二簧
二老
二老板
二者
二胡
二话
二象性
二轮
二进位制
二进制
二郎山
二重性
二门
二面角
二项式
于七
于于
于今
于思
于是
于是乎
于田
于飞
亏心
亏损
亏本
亏空
云云
云南
云天
云室
云层
云山
云彩
云杉
云梯
云母
云贵
云贵高原
云雀
云集
云雨
云雾
云霞
云顶
云龙
互不侵犯条约
互不干涉内政
互利
互助
互助组
互惠
互感
互换
互换性
互派
互溶
互生
互相
互访
互通
互通有无
五一
五两
五中
五代
五代十国
五体投地
五保
五光十色
五公里
五刑
五反运动
五台
五台山
五味
五味子
五四运动
五声
五岭
五常
五年计划
五彩
五彩缤纷
五律
五指
五指山
五方
五星
五星红旗
五更
五权宪法
五梏
五毒
五洲
五种
五脏
五色
五花八门
五营
五行
五角星
五言诗
五谷
五路
五边形
五铢
五霸
五音
五项原则
五颜六色
五香
五龙
井冈山
井口
井台
井喷
井底
井架
井水
井灌
井然
井田
井田制
井盐
井筒
井陉
亚丁
亚东
亚军
亚历山大
亚当
亚斯
亚洲
亚热带
亚硝酸
亚硫酸
亚硫酸盐
亚纲
亚细亚生产方式
亚铁
亚非会议
亚马孙河
亚麻
些小
亡命
亡国
亡国奴
交互
交付
交代
交会法
交出
交加
交叉
交响乐
交响曲
交售
交城
交尾
交工
交往
交情
交战
交战国
交换
交换价值
交接
交易
交易所
交替
交流
交流电力机车
交涉
交点
交班
交界
交纳
交织
交融
交角
交谈
交趾
交还
交通
交通工具
交通线
交通部
交配
交锋
交错
交际
交集
亦即
产业
产业后备军
产业工人
产业资本
产业革命
产仔
产值
产儿
产前
产卵
产卵场
产卵洄游
产后
产品
产地
产妇
产婆
产权
产物
产状
产生
产蛋鸡
产量
产销
产销合同
亨利
享乐
享受
享有
享用
享福
京剧
京华
京口
京城
京山
京师
京戏
京房
京汉铁路
京畿
京胡
京西
京都
亭子
亮光
亮堂
亮度
亮晶晶
亮相
亲事
亲亲
亲人
亲信
亲切
亲友
亲口
亲和力
亲娘
亲密
亲属
亲征
亲戚
亲手
亲政
亲族
亲昵
亲热
亲爱
亲王
亲生
亲眼
亲自
亲身
亵渎
人世
人丛
人中
人为
人为地
人主
人事
人人
人们
人伦
人体
人像
人儿
人剥削人
人力
人力车
人参
人口
人口增加
人口论
人口过剩
人命
人和
人品
人士
人声
人大
人头
人字架
人定
人家
人寿保险
人工
人工授精
人工林
人影
人心
人心所向
人性
人性论
人情
人情味
人手
人才
人文
人日
人时
人权
人材
人极
人格
人格化
人次
人欲
人氏
人民
人民之声报
人民代表大会
人民党
人民公社
人民公社化
人民内部矛盾
人民军队
人民出版社
人民团体
人民大会堂
人民委员会
人民币
人民性
人民意志
人民战争
人民报
人民政府
人民日报
人民武装
人民民主专政
人民民主国家
人民法庭
人民法院
人民警察
人民阵线
人治
人流
人浮于事
人烟
人物
人物性格
人生
人生哲学
人生观
人种
人称
人类
人粪尿
人群
人行道
人言
人证
人质
人身
人身依附
人身自由
人迹
人选
人造
人造丝
人造卫星
人造地球卫星
人造板
人造棉
人造橡胶
人造纤维
人道
人道主义
人间
人马
亿万
什么
什么的
仁义
仁义道德
仁兄
仁弟
仁慈
仁政
仁爱
仅仅
仅只
仅次于
仅见
仆人
仆从
仆役
仇人
仇恨
仇敌
仇视
今世
今人
今儿
今后
今天
今年
今文
今文经学
今日
今朝
今生
介入
介子
介意
介电常数
介绍
介绍人
介绍信
介质
仍旧
仍然
从业人员
从严
从中
从事
从事于
从今
从先
从军
从前
从动
从化
从头
从子
从容
从容不迫
从宽
从小
从属
从属关系
从打
从政
从新
从未
从未有过
从来
从来没有过
从此
从母
从江
从父
从犯
从略
从简
从而
从轮
从速
从难从严
从风
仓促
仓卒
仓库
仓廪
仓皇
仔细
他人
他们
他侬
他国
他妈的
他日
他杀
他的
付出
付款
仙人
仙女
仙姑
代之以
代价
代偿
代办
代办处
代劳
代号
代名词
代数
代数和
代数式
代替
代理
代理人
代用
代用品
代码
代管
代耕
代行
代表
代表团
代表大会
代言人
代议制
代谢
代谢能
代购
代金
代销
令人
令弟
以上
以下
以东
以为
以便
以免
以内
以前
以北
以南
以及
以后
以外
以太
以往
以来
以次
以求
以点带面
以理服人
以至
以至于
以致
以色列
以西
以资
以身作则
以近
以远
仪器
仪式
仪的
仪表
仰光
仰卧
仰望
仰角
仰面
仲吕
仲尼
仲裁
价值
价值尺度
价值形式
价值规律
价值论
价值量
价廉物美
价格
价电子
价钱
任人
任何
任侠
任免
任凭
任务
任劳任怨
任命
任性
任意
任教
任期
任用
任职
份地
份子
份额
仿佛
仿制
仿古
仿效
仿照
仿生学
仿造
企业
企业化
企业基金
企业家
企业管理
企业管理费
企业财务
企图
企望
企求
伊东
伊拉克
伊斯兰堡
伊斯兰教
伊朗
伊红
伍廷芳
伎俩
伏兵
伏击
伏地
伏安
伏尔加河
伏特
伏特计
伏罗希洛夫
伏虎
伐区
伐木
休假
休养
休息
休想
休整
休止
休止符
休眠
休谟
休闲
众人
众叛亲离
众多
众所周知
众数
众生
众议院
优先
优先发展
优先股
优劣
优势
优异
优待
优惠
优抚
优点
优生学
优秀
优等
优美
优胜
优良
优良单株
优质
优质钢
优越性
优选法
伙伴
伙同
伙房
伙计
伙食
会不会
会儿
会党
会办
会合
会同
会员
会员国
会商
会场
会子
会审
会客
会师
会当
会心
会意
会战
会晤
会演
会理
会聚
会见
会计
会计凭证
会计分录
会计制度
会计报表
会计核算
会议
会试
会话
会谈
会通
会集
会面
会馆
伞兵
伞齿轮
伟大
传世
传习
传令
传入神经
传动
传动带
传动比
传动轴
传单
传唤
传奇
传导
传导电流
传布
传感器
传授
传播
传教
传教士
传来
传染
传染病
传热
传热系数
传真
传神
传票
传统
传统教育
传言
传讯
传记
传说
传诵
传质
传达
传送
传送带
传递
传递性
传遍
传闻
伢子
伤亡
伤兵
伤势
伤口
伤员
伤害
伤寒
伤心
伤感
伤疤
伤病员
伤痕
伤痛
伤脑筋
伤风
伦常
伦敦
伦理
伦理学
伦琴
伦琴射线
伪军
伪善
伪装
伪证
伪造
伫立
伯伯
伯利
伯尔
伯尔尼
伯德
伯恩
伯爵
伯父
估价
估测
估计
估量
伴侣
伴奏
伴随
伴音
伶俐
伸冤
伸出
伸展
伸开
伸张
伸手
伸直
伸缩
伸长
伺候
伺机
似乎
似的
伽利略
佃农
佃客
佃户
佃权
佃租
但书
但愿
但是
但马
位似中心
位似变换
位子
位次
位相
位移
位移电流
位置
位能
低下
低产
低估
低低的
低值易耗品
低劣
低压
低合金钢
低地
低垂
低声
低头
低廉
低微
低栏
低档
低气压
低沉
低洼
低消耗
低温
低潮
低矮
低碳钢
低空
低级
低耗
低能
低落
低语
低速
低音
低频
住口
住址
住处
住宅
住家
住宿
住户
住房
住所
住手
住院
佐证
体会
体例
体制
体力
体力劳动
体型
体壁
体察
体已
体形
体态
体操
体格
体检
体液
体温
体现
体积
体系
体细胞
体罚
体育
体育场
体育运动
体育馆
体胀系数
体腔
体裁
体谅
体质
体贴
体面
体验
体魄
何不
何以
何其
何况
何国
何在
何处
何如
何妨
何尝
何必
何承天
何晏
何曾
何止
何等
何苦
何谓
佘太君
余下
余党
余切
余利
余割
余地
余姚
余家
余年
余弦
余弦定理
余数
余步
余毒
余氯
余粮
余粮收集制
余缺
余角
余音
余额
佛像
佛图澄
佛学
佛山
佛得角
佛教
佛法
佛经
作业
作为
作主
作乐
作乱
作价
作伪
作伴
作保
作准
作古
作品
作图
作坊
作客
作家
作对
作废
作怪
作恶
作成
作战
作文
作曲
作曲家
作案
作法
作物
作用
作用力
作者
作证
作陪
作难
作风
佝偻病
你们
你好
你死我活
你的
你追我赶
佣工
佩服
佳人
佳木斯
佳节
佳音
使出
使劲
使君
使命
使唤
使女
使役
使徒
使得
使气
使用
使用价值
使用权
使相
使者
使臣
使节
使馆
侄女
侄子
侈谈
例外
例如
例子
例行
例证
例题
侍中
侍从
侍候
侍卫
侍女
侍者
侍郎
供不应求
供养
供应
供暖
供求
供电
供给
供职
供认
供词
供销
供销合作社
依仗
依依
依存
依恋
依据
依旧
依次
依此类推
依然
依照
依稀
依赖
依附
依附于
依靠
侠义
侠客
侥幸
侦察
侦察机
侦探
侦探小说
侦查
侦缉
侧枝
侧根
侧线
侧耳
侧芽
侧身
侧重
侧门
侧面
侨务
侨居
侨民
侨汇
侨眷
侨胞
侮辱
侵入
侵入体
侵占
侵吞
侵夺
侵害
侵扰
侵犯
侵略
侵略战争
侵略者
侵蚀
侵蚀作用
侵袭
侵越
便中
便于
便利
便宜
便当
便服
便衣
便道
促使
促性腺激素
促成
促进
促进派
俄国
俄而
俄语
俊杰
俏皮
俗名
俗话
俗语
俘获
俘虏
保不住
保人
保佑
保健
保全
保加利亚
保卫
保卫和平
保卫祖国
保卫者
保墒
保姆
保存
保守
保安
保安队
保定
保密
保山
保护
保护人
保护关税
保护国
保持
保持警惕
保有
保温
保温瓶
保甲
保留
保皇党
保管
保罗
保育
保育员
保苗
保荐
保证
保证人
保证供应
保重
保险
保险丝
保险公司
保险柜
保险金额
保障
保驾
信义
信从
信件
信任
信号
信号弹
信号灯
信号系统
信奉
信封
信徒
信心
信念
信息
信息论
信托
信托贸易
信服
信条
信用
信用证
信纸
信誉
信贷
信贷资金
信赖
信阳
俨然
修修
修剪
修复
修好
修建
修成
修改
修整
修正
修正主义
修水
修理
修筑
修缮
修行
修补
修订
修路
修蹄
修身
修辞
修辞学
修造
修配
修配厂
修饰
俯卧撑
俯瞰
俯视
俯视图
俯角
俯首
俱乐部
俱全
俸禄
倍数
倒伏
倒卖
倒反
倒台
倒塌
倒影
倒悬
倒戈
倒把
倒换
倒放
倒数
倒是
倒楣
倒流
倒灌
倒立
倒置
倒行逆施
倒车
倒转
倒过来
倒退
倒闭
倒霉
倔强
倘使
倘然
倘若
候审
候机室
候补
候车室
候选人
候鸟
倚赖
倚靠
倚音
借以
借债
借光
借助
借口
借据
借故
借方
借款
借用
借端
借调
借贷
借贷资本
借鉴
倡导
倡言
倡议
倪嗣冲
倭寇
债主
债券
债务
债务人
债权
债权人
值得
值此
值班
值钱
倾侧
倾倒
倾动
倾吐
倾向
倾向性
倾听
倾复
倾心
倾斜
倾斜度
倾斜角
倾注
倾泻
倾覆
倾角
倾销
假使
假借
假冒
假分数
假名
假如
假定
假山
假想
假惺惺
假意
假托
假日
假期
假植
假若
假装
假言判断
假设
假话
假说
假象
假释
假面具
偏于
偏偏
偏僻
偏压
偏向
偏差
偏心
偏心轮
偏振
偏振光
偏振片
偏析
偏流
偏爱
偏离
偏袒
偏见
偏角
偏转
偏转线圈
偏远
偏重
偏颇
做主
做买卖
做事
做人
做作
做到
做功
做官
做工
做成
做文章
做梦
做法
做诗
做饭
停产
停刊
停办
停工
停当
停息
停战
停放
停显
停歇
停止
停泊
停滞
停滞不前
停火
停电
停留
停留时间
停经片
停车
停车场
停靠
停顿
停食
健儿
健全
健在
健壮
健将
健康
健美
偶像
偶合
偶尔
偶数
偶然
偶然性
偷偷
偷偷摸摸
偷听
偷工减料
偷懒
偷看
偷税
偷袭
偿清
偿还
傅会
傅立叶
傍晚
傣族
储备
储备粮
储存
储油
储蓄
储藏
储量
催产
催促
催化
催化作用
催化剂
催化裂化
催眠
催肥
催芽
傲慢
傻子
傻瓜
僧人
僧侣
僧尼
僧格林沁
僵化
僵尸
僵局
僵死
僵硬
僻静
儒墨
儒学
儒家
儒术
儒林
儒林外史
儒生
儒者
儿女
儿媳妇
儿子
儿孙
儿戏
儿时
儿童
儿童团
儿童心理学
儿茶
儿茶酚
允许
元世祖
元件
元初
元史
元嘉
元子
元宝
元山
元帅
元年
元旦
元曲
元月
元朝
元本
元气
元素
元素周期律
元素符号
元老
元老院
元音
元首
兄弟
兄弟党
充任
充其量
充军
充分
充分条件
充填
充实
充当
充沛
充满
充电
充血
充裕
充足
充饥
兆赫
先人
先令
先例
先公
先决
先前
先后
先声
先天
先头
先导
先手
先是
先期
先烈
先生
先知
先秦
先端
先行
先辈
先进
先进集体
先遣
先锋
先锋队
先驱
先验
先验论
光临
光亮
光化
光华
光合作用
光和
光圈
光复
光复会
光大
光天化日
光头
光子
光学
光学玻璃
光山
光州
光带
光度
光彩
光敏
光明
光明日报
光明正大
光明磊落
光是
光景
光束
光棍
光武
光气
光波
光泽
光洁
光洁度
光润
光源
光滑
光照
光照阶段
光电
光电二极管
光电子
光电效应
光电池
光电流
光电管
光秃秃
光纤通信
光线
光绪
光绪帝
光缆
光能
光芒
光荣
光荣革命
光谱
光谱分析
光谱线
光轴
光辉
光辉灿烂
光辐射
光速
光闪闪
光阴
光面
光顾
克分子
克分子浓度
克利
克制
克复
克尔
克己复礼
克扣
克拉
克服
克服困难
克罗齐
克莱
克里
克里姆林宫
克食
克鲁克斯
免不了
免役
免得
免疫
免税
免费
免除
兑换
兑现
兔子
兔毛
兖州
党人
党代表
党内
党内斗争
党务
党史
党团
党外
党委
党委书记
党委会
党小组
党性
党总支
党报
党政
党政机关
党校
党派
党的基本路线
党章
党籍
党纪
党纪国法
党纲
党组
党羽
党课
党费
党风
兜兜
兜售
兢兢业业
入五
入仓
入伍
入会
入侵
入党
入冬
入口
入味
入团
入土
入场
入境
入夜
入学
入室
入射
入射角
入库
入座
入微
入手
入托
入时
入梦
入狱
入画
入直
入睡
入社
入超
入迷
入门
入院
入骨
全世界
全人
全会
全体
全党
全军
全副
全力
全力以赴
全县
全反射
全国
全国各地
全国性
全国纪录
全国运动会
全场
全套
全家
全局
全年
全开
全心全意
全息
全数
全文
全新
全日制
全景
全权
全权代表
全村
全民
全民所有制
全民投票
全然
全球
全生育期
全盘
全盛
全神贯注
全程
全等
全线
全胜
全能
全貌
全身
全速
全部
全都
全集
全面
全面性
全音
八仙桌
八分
八分音符
八十
八千
八国联军
八字
八字宪法
八宝
八家
八成
八户
八方
八旗
八百
八股
八节
八角
八路
八路军
八边形
八项注意
公主
公举
公事
公产
公人
公仆
公众
公会
公使
公倍数
公债
公公
公共
公共场所
公共汽车
公共积累
公函
公分
公切线
公刘
公制
公务
公务员
公升
公历
公厘
公司
公司法
公告
公因式
公因数
公园
公垂线
公堂
公墓
公婆
公子
公孙龙
公安
公安人员
公安局
公安部
公安部队
公审
公害
公家
公寓
公尺
公差
公布
公平
公开
公开信
公式
公式化
公意
公愤
公推
公敌
公文
公斤
公断
公族
公有
公有制
公案
公款
公正
公比
公民
公民权
公法
公海
公海自由
公演
公然
公爵
公物
公理
公用
公用事业
公畜
公益
公益金
公社
公社化
公私
公私合营
公称
公立
公粮
公约数
公署
公羊
公职
公营
公认
公议
公论
公设
公证
公诉
公诉人
公费
公路
公转
公输
公道
公里
公顷
公馆
公鸡
六六六
六军
六安
六家
六师
六度
六朝
六条
六根
六法
六经
六艺
六角
六边形
六道
六部
六镇
兰州
兰斯
兰新铁路
兰溪
兰考
兰花
共事
共产主义
共产主义世界观
共产主义者
共产主义道德
共产党
共产党人
共产党宣言
共产国际
共享
共价
共价键
共发射极
共同
共同体
共同市场
共同海损
共同纲领
共同语
共和
共和党
共和制
共和国
共基极
共处
共存
共性
共性和个性
共患难
共振
共有
共析
共析钢
共犯
共生
共聚
共聚反应
共聚物
共计
共轭
共轭复数
共轭点
共进会
共通
共需
共青团
共鸣
关上
关东
关东糖
关中
关书
关内
关切
关卡
关口
关外
关头
关心
关怀
关押
关注
关照
关税
关系
关紧
关联
关节
关节炎
关西
关键
关门
兴中会
兴亡
兴修
兴冲冲
兴办
兴化
兴味
兴国
兴奋
兴安
兴安岭
兴建
兴旺
兴盛
兴致
兴致勃勃
兴许
兴起
兴趣
兴隆
兴风作浪
兴高采烈
兵丁
兵书
兵制
兵力
兵变
兵员
兵器
兵团
兵士
兵备
兵家
兵工厂
兵役
兵权
兵法
兵种
兵舰
兵船
兵营
兵部
兵马
其一
其中
其二
其他
其它
其实
其次
其间
具体
具体劳动
具体化
具体地说
具备
具文
具有
具结
典型
典型化
典型性
典型调查
典当
典故
典礼
典章
典籍
典范
养亲
养伤
养兵
养分
养地
养子
养家
养成
养护
养料
养殖
养气
养活
养父
养猪场
养生
养病
养老
养育
养蜂
养路
养鱼池
养鸡场
兼任
兼备
兼容
兼并
兼爱
兼程
兼职
兼顾
兽医
兽性
兽类
内中
内主
内乱
内人
内伤
内公切线
内分泌
内分泌腺
内切圆
内制
内力
内务
内务府
内务部
内包
内史
内因
内在
内地
内场
内外
内外交困
内外跤困
内奸
内存
内学
内容
内容和形式
内幕
内平
内应
内应力
内心
内心世界
内情
内战
内戮
内摩擦
内政
内服
内河
内海
内涝
内涵
内热
内焰
内燃机
内燃机车
内环境
内电阻
内皮
内科
内线
内经
内罗毕
内耗
内胎
内能
内脏
内蒙古
内行
内衣
内角
内转
内部
内部矛盾
内部联系
内酰胺
内销
内错角
内阁
内阻
内项
冈比亚
册子
册页
再三
再不
再也不会
再也没有
再会
再保险
再入
再则
再审
再度
再拜
再接再厉
再教育
再来一个
再次
再版
再现
再生
再生产
再生制动
再生缘
再结晶
再者
再见
再认
再说
再起
再造
再问
冒充
冒口
冒昧
冒火
冒烟
冒牌
冒进
冒险
冒险主义
冒雨
冒顶
写作
写入
写出
写字台
写实
写意
写法
写照
写生
写真
写稿
军事
军事化
军事基地
军事家
军事法庭
军事训练
军人
军令
军分区
军制
军力
军功
军务
军务院
军区
军医
军号
军国主义
军士
军备
军备竞赛
军委
军官
军属
军屯
军工
军师
军帽
军心
军情
军户
军政
军政府
军方
军服
军机
军机处
军校
军械
军民
军法
军火
军管
军粮
军纪
军统
军舰
军营
军装
军警
军谘府
军费
军车
军部
军长
军阀
军队
军需
军饷
农业
农业中学
农业合作化
农业国
农业大学
农业学大寨
农业工人
农业总产值
农业技术
农业机器
农业机械
农业机械化
农业生产合作社
农业社
农业税
农业贷款
农业资本家
农业集体化
农中
农事
农产品
农产品收购
农会
农作物
农具
农副产品
农历
农场
农夫
农奴
农奴主
农奴制
农妇
农学
农家
农家品种
农家肥料
农忙
农户
农时
农机
农村
农村人民公社
农村公社
农林
农林牧副渔
农民
农民协会
农民战争
农民起义
农民阶级
农民革命
农活
农渠
农田
农田基本建设
农田小气候
农田水利
农畜
农艺
农艺师
农药
农谚
农闲
冠冕堂皇
冠军
冠心病
冤仇
冤家
冤屈
冤枉
冤狱
冤魂
冥王星
冬天
冬季
冬学
冬小麦
冬瓜
冬眠
冬笋
冬耕
冬闲
冬麦
冯国璋
冯梦龙
冯特
冯玉祥
冯雪峰
冰冷
冰冻
冰凉
冰凌
冰场
冰天雪地
冰封
冰岛
冰川
冰晶
冰晶石
冰期
冰棍儿
冰点
冰球
冰箱
冰糖
冰雪
冰雹
冲冲
冲决
冲击
冲击波
冲击韧性
冲刷
冲刺
冲力
冲动
冲压
冲天
冲天炉
冲撞
冲沟
冲洗
冲淡
冲破
冲积
冲积平原
冲程
冲突
冲绳
冲锋
冲锋枪
冲锋陷阵
决不
决口
决定
决定性
决定论
决心
决意
决战
决斗
决断
决然
决策
决算
决裂
决计
决议
决赛
况且
冶炼
冶金
冶金工业
冷作
冷光
冷冰冰
冷冷清清
冷冷的
冷冻
冷凝
冷加工
冷却
冷却器
冷天
冷库
冷战
冷暖
冷杉
冷气
冷水
冷汗
冷淡
冷漠
冷笑
冷落
冷藏
冷轧
冷酷
冷静
冷风
冻伤
冻僵
冻土
冻害
冻死
冻结
冻胀
冼星海
净化
净尽
净是
凄凉
凄惨
凄然
准予
准则
准噶尔
准备
准备好的
准备活动
准时
准确
准确度
准确性
准确无误
准线
准绳
准许
凉山
凉快
凉水
凉爽
凉鞋
凉风
凋敝
凌乱
凌云
凌晨
凌空
凌辱
减产
减价
减低
减免
减刑
减压
减压塔
减压渣油
减压蒸馏
减少
减弱
减数
减数分裂
减法
减租减息
减缓
减轻
减退
减速剂
减速器
减震
凑合
凑巧
凛冽
凛凛
凝固
凝固点
凝望
凝汽器
凝神
凝结
凝结水
凝聚
凝视
凝集
凝集反应
几乎
几何
几何体
几何图形
几何学
几内亚
几内亚比绍
几几
几分
几度
几微
几时
几率
几许
凡事
凡人
凡士林
凡尔
凡尔赛
凡是
凡此种种
凡百
凤凰
凤凰山
凤山
凤翔
凤阳
凭借
凭单
凭单日记帐
凭空
凭证
凯恩斯
凯旋
凯歌
凳子
凶器
凶恶
凶手
凶杀
凶残
凶犯
凶狠
凶猛
凸出
凸多边形
凸缘
凸轮
凸轮轴
凹陷
凹面镜
出世
出乎
出乎意料
出乱子
出产
出任
出众
出使
出入
出兵
出其不意
出典
出击
出力
出动
出勤
出勤率
出卖
出厂
出厂价格
出去
出发
出口
出名
出品
出售
出国
出土
出场
出塞
出境
出处
出外
出头
出奇
出嫁
出家
出局
出山
出巡
出工
出差
出师
出席
出庭
出征
出息
出手
出操
出来
出毛病
出气
出水管
出江
出没
出洋
出活
出海
出版社
出现
出生
出生入死
出生率
出神
出科
出租
出笼
出纳
出缺
出航
出色
出芽
出苗
出苗率
出血
出血病
出让
出访
出谋划策
出走
出超
出路
出身
出车
出轨
出逃
出铁
出错
出门
出院
出险
出面
出风头
出马
击中
击伤
击剑
击毁
击毙
击水
击沉
击溃
击球
击破
击穿
击落
击败
击退
函授
函授教育
函数
函梏关
函电
凿井
凿岩
凿岩机
刀具
刀具耐用度
刀刃
刀口
刀子
刀尖
刀山
刀枪
刀架
刀柄
刀法
刀片
刀背
刁难
刃具
分之
分享
分付
分会
分光
分光镜
分内
分别
分割
分力
分化
分压力
分发
分句
分地
分场
分外
分头
分娩
分子
分子力
分子式
分子生物学
分子电流
分子筛
分子结构
分子论
分子运动论
分子量
分宜
分家
分寸
分封
分居
分工
分布
分布区
分度头
分开
分式
分式方程
分录
分得
分心
分手
分批
分担
分摊
分支
分散
分散主义
分散介质
分散剂
分散度
分散染料
分散相
分数
分文
分明
分期
分析
分析和综合
分析器
分歧
分母
分水
分水岭
分泌
分派
分流
分清
分点
分生孢子
分生组织
分界
分界线
分离
分种
分秒
分立
分等
分管
分米
分类
分类学
分类帐
分红
分级
分级淬火
分组
分群
分色
分色镜
分葱
分蘖
分蘖期
分蘖节
分行
分裂
分裂主义
分解
分设
分说
分贝
分赃
分赴
分路
分辨
分辩
分送
分选
分道
分配
分配器
分配律
分配阀
分量
分钟
分门别类
分队
分隔
分馏
分馏塔
切分音
切切
切削
切削力
切削性能
切削用量
切削角
切削速度
切割
切口
切合
切块
切实
切实可行
切屑
切开
切忌
切断
切点
切片
切线
切身
切除
切面
切齿
刊印
刊布
刊物
刊登
刊行
刊载
刑书
刑事
刑事犯罪
刑事责任
刑具
刑名
刑律
刑期
刑法
刑法志
刑罚
刑讯
刑部
划一
划分
划定
划归
划时代
划清
划破
划线
列举
列传
列入
列出
列国
列夫
列子
列宁
列宁主义
列宁全集
列宁选集
列席
列强
列甯格勒
列车
列队
刘体纯
刘向
刘坤一
刘备
刘安
刘宋
刘宗敏
刘少奇
刘师培
刘徽
刘玄
刘琨
刘福通
刘秀
刘聪
刘胡兰
刘表
刘裕
刘邦
刚体
刚健
刚刚
刚好
刚度
刚强
刚性
刚才
刚果
刚毅
刚毛
刚玉
创业
创举
创伤
创作
创作实践
创作方法
创刊
创刊号
创制
创办
创口
创始
创建
创新
创立
创见
创设
创造
创造性
初一
初中
初二
初八
初十
初始
初审
初期
初次
初步
初版
初稿
初等
初级
初级社
初级线圈
初速
判例
判决
判决书
判别
判别式
判处
判官
判定
判断
判明
判案
判罪
刨刀
刨床
刨花
利剑
利器
利害
利己
利己主义
利弊
利息
利权
利比亚
利比里亚
利民
利润
利润率
利润留成
利率
利玛窦
利用率
利用系数
利益
利索
利落
利诱
利雅得
利马
别个
别人
别动
别动队
别名
别后
别国
别墅
别处
别开生面
别後
别扭
别提
别是
别有用心
别的
别看
别管
别致
别说
刮刀
刮研
到任
到会
到场
到处
到头
到头来
到家
到底
到手
到时候
到期
到来
到点
到站
到达
到顶
制件
制作
制冷
制冷机
制剂
制动
制动器
制动缸
制品
制图
制备
制定
制宪会议
制度
制成品
制服
制止
制版
制糖
制表
制裁
制订
制造
制醣
制钱
制面
制革
制音器
刷子
刷新
刷洗
刹车
刹那
刺刀
刺史
刺客
刺探
刺杀
刺槐
刺毛辊
刺激
刺眼
刺绣
刺网
刺耳
刺骨
刻下
刻不容缓
刻划
刻字
刻度
刻度尺
刻意
刻本
刻板
刻画
刻苦
刻薄
刻骨
刽子手
剂量
削减
削弱
前世
前人
前仆后继
前件
前任
前作
前例
前列
前前后后
前卫
前去
前台
前后
前哨
前场
前夕
前夜
前天
前夫
前头
前奏
前年
前庭
前往
前所
前所未有
前排
前提
前敌
前方
前日
前景
前期
前来
前桥
前次
前汉
前沿
前清
前秦
前程
前线
前者
前肢
前脚
前臂
前言
前身
前车
前轮
前辈
前边
前进
前途
前锋
前门
前院
前面
前项
前额
前驱
剑侠
剑叶
剑桥
剑麻
剔出
剔除
剖析
剖腹
剖视图
剖面
剖面图
剥削
剥削阶级
剥夺
剥离
剥落
剥蚀
剧中人
剧作家
剧团
剧场
剧情
剧本
剧烈
剧目
剧种
剧院
剩下
剩余产品
剩余价值
剩余价值率
剩余劳动
剩磁
剪刀
剪刀差
剪切
剪力
剪子
剪应力
剪毛
剪毛机
剪裁
副业
副主任委员
副井
副产品
副刊
副反应
副官
副将
副总理
副教授
副本
副线圈
副署
副翼
副职
副食
割地
割据
割断
割线
割绒
割裂
割让
剽窃
剿灭
劈柴
力不从心
力主
力争
力争上游
力偶
力图
力场
力多边形
力学
力度
力役
力战
力所能及
力气
力求
力点
力疾
力矩
力系
力臂
力行
力量
力量对比
劝告
劝学篇
劝导
劝慰
劝说
劝进
劝阻
办不到
办事
办事处
办公
办公厅
办公室
办到
办学
办得到
办案
办法
办理
办货
功利
功利主义
功力
功劳
功勋
功名
功夫
功效
功率
功率因数
功率放大器
功绩
功耗
功能
功臣
功课
功过
加上
加仑
加以
加以解决
加倍
加入
加利福尼亚
加剧
加力
加力燃烧室
加勒比海
加压
加厚
加固
加大
加宽
加密
加尔各答
加尼
加工
加工余量
加工工业
加工硬化
加工订货
加强
加德满都
加快
加急
加拈
加拉加斯
加拿大
加捻
加数
加料
加氢
加氢精制
加氢裂化
加油
加法
加注
加深
加点
加热
加热器
加热炉
加班
加盟共和国
加紧
加纳
加聚反应
加蓬
加西亚
加速
加速器
加速泵
加速运动
加里宁
加重
加高
务使
务农
务头
务必
务求
务须
劣势
劣弧
劣等
劣绅
动不动
动乱
动产
动人
动作
动力
动力学
动力机
动力装置
动向
动听
动地
动工
动弹
动心
动态
动态平衡
动情
动手
动手术
动摇
动机
动滑轮
动物
动物园
动物学
动物性饲料
动物油
动用
动笔
动能
动脉
动脉弓
动脉血
动脑筋
动荡
动觉
动议
动身
动辄
动配合
动量
动量矩
动静
助人为乐
助战
助手
助攻
助燃
助理
助跑
助长
助饷
努力
努尔哈赤
努瓦克肖特
劫夺
劫掠
励磁机
劲头
劲敌
劲旅
劳伦斯
劳作
劳保
劳力
劳务
劳动
劳动产品
劳动人民
劳动保护
劳动保险
劳动力
劳动化
劳动定额
劳动对象
劳动工具
劳动工分
劳动强度
劳动改造
劳动新闻
劳动日
劳动时间
劳动条件
劳动模范
劳动法
劳动生产力
劳动生产率
劳动竞赛
劳动纪律
劳动群众
劳动者
劳动英雄
劳动资料
劳动过程
劳工
劳役
劳役地租
劳心者治人
劳改
劳模
劳累
劳苦
劳资
势不两立
势力
势均力敌
势头
势如破竹
势能
勃列日涅夫
勃勃
勃发
勃然
勇于
勇士
勇往直前
勇敢
勇气
勇猛
勉励
勉强
勋章
勒令
勒索
勘察
勘探
勘探工程
勘测
募捐
募集
勤俭
勤务兵
勤务员
勤劳
勤奋
勤工俭学
勤快
勤恳
勤王
勺子
勾引
勾当
勾心斗角
勾画
勾结
勾股定理
勾芡
匀整
匀染
匀称
匀速圆周运动
匀速直线运动
匀速转动
匀速运动
包下来
包产
包产到户
包办
包含
包围
包围圈
包头
包子
包工
包干
包庇
包扎
包抄
包括
包揽
包梏
包涵
包皮
包罗
包藏
包袱
包装
包裹
包谷
包车
包销
匆促
匆匆
匆匆忙忙
匆忙
匈奴
匈牙利
匍匐
化为乌有
化合价
化合物
化处
化妆
化妆品
化子
化学
化学元素
化学分析
化学反应
化学反应速度
化学变化
化学合成
化学工业
化学平衡
化学性质
化学方程式
化学武器
化学纤维
化学肥料
化学能
化学键
化工
化工厂
化性
化油器
化生
化石
化纤
化肥
化脓
化装
化费
化身
化铁炉
化验
北京
北京大学
北京市
北京鸭
北伐军
北伐战争
北冰洋
北半球
北周
北宋
北山
北戴河
北房
北方
北朝
北极
北极星
北欧
北洋
北洋军阀
北海
北海道
北爱尔兰
北纬
北美洲
北边
北郊
北部
北部湾
北非
北魏
北齐
匠人
匠心
匡复
匣子
匣钵
匪军
匪帮
匪徒
匪首
匮乏
匹夫
匹配
区分
区划
区区
区域
区域性
区委
区有
区长
区间
医务
医务室
医士
医学
医学院
医师
医术
医治
医生
医疗
医科
医药
医药学
匾额
十一万
十一月
十万
十三点
十三陵
十之八九
十二分
十二平均律
十二指肠
十二月
十全十美
十六分音符
十六进制
十冬腊月
十分
十字头
十字架
十字路口
十恶
十成
十月革命
十足
十进位制
十进制
千万
千丝万缕
千亩
千伏
千克
千军万马
千分表
千千万万
千卡
千变万化
千古
千家万户
千岁
千差万别
千户
千斤
千斤顶
千方百计
千瓦
千百万
千真万确
千秋
千篇一律
千米
千粒重
千赫
千辛万苦
千里眼
千里马
千金
升力
升华
升压
升号
升天
升学
升官
升平
升水
升汞
升级
升腾
升降
升降机
升限
升高
午后
午夜
午时
午饭
半世
半个
半制品
半场
半壁
半夜
半大
半天
半失业
半导体
半封建
半封建半殖民地
半岛
半工半读
半年
半开
半径
半成品
半截
半数
半晌
半月刊
半死
半殖民地
半点
半球
半生
半自动
半衰期
半路
半辈子
半边
半边天
半透明
半途
半途而废
半部
半音
华东
华中
华丽
华人
华佗
华侨
华兴会
华北
华北平原
华南
华夏
华山
华沙
华灯
华生
华盛顿
华美
华而不实
华西
华达呢
华里
华阳国志
协会
协作
协力
协助
协同
协同动作
协和
协商
协奏曲
协定
协理
协约国
协统
协议
协调
卑下
卑劣
卑贱
卑鄙
卓有成效
卓越
单丝
单于
单交
单交种
单产
单价
单位
单位制
单位工程
单位根
单位面积产量
单体
单作
单倍体
单元
单养
单单
单名数
单向
单向阀
单子
单子叶植物
单字
单宁
单干
单干户
单打
单据
单摆
单数
单方
单方面
单晶体
单机
单杠
单株选择
单独
单相
单眼
单程
单糖
单纯
单线
单细胞
单色
单色光
单薄
单行
单衣
单词
单调
单质
单身
单车
单边
单项
单项工程
单项式
卖主
卖价
卖力
卖力气
卖命
卖国
卖国贼
卖弄
卖文
卖淫
卖给
卖身
卖钱
南中
南亚
南京
南人
南充
南关
南军
南匈奴
南北
南北朝
南北议和
南半球
南华
南口
南史
南吕
南和
南唐
南国
南城
南宁
南宋
南宫
南山
南岭
南市
南平
南开
南征北战
南斯拉夫
南方
南昌
南明
南朝
南朝鲜
南极
南极洲
南欧
南汇
南汉
南洋
南流
南海
南王
南瓜
南皮
南社
南罗得西亚
南美
南美洲
南至
南诏
南越
南边
南通
南郡
南部
南门
南阳
南非
南面
南齐书
博士
博学
博得
博爱
博物
博物馆
博茨瓦纳
博览会
卜辞
占便宜
占先
占城
占据
占有
占有权
占领
占领者
卡其
卡塔尔
卡尔
卡尺
卡拉奇
卡洛斯
卡片
卡特
卡特尔
卡盘
卡翁达
卡芬雅克
卡诺
卡车
卡里
卢布
卢森堡
卢比
卢萨卡
卤化
卤化物
卤族
卤水
卤素
卧室
卧房
卧薪尝胆
卧铺
卫兵
卫国
卫士
卫戍
卫所
卫护
卫星
卫星通信
卫生
卫生所
卫生标准
卫生部
卫生防护
卫生防疫
卫道
卫队
印信
印刷
印刷机
印发
印子
印度
印度尼西亚
印度支那
印把子
印染
印痕
印章
印第安人
印花
印行
印证
印象
印象派
危亡
危及
危地马拉
危害
危害性
危急
危机
危险
危险性
危难
即令
即位
即使
即便
即兴
即刻
即将
即席
即或
即日
即时
即景
却不
却说
卵块
卵子
卵巢
卵形
卵泡
卵生
卵石
卵细胞
卵裂
卵黄
卷入
卷取
卷土重来
卷子
卷扬机
卷曲
卷染
卷烟
卷筒
卷纬
卷绕
卷装
卸货
卸车
卿大夫
厂主
厂商
厂子
厂房
厂用电
厂矿
厂长
厂长负责制
厄瓜多尔
厄运
厅堂
历书
历代
历任
历历
历史
历史剧
历史性
历史意义
历史潮流
历届
历年
历数
历时
历月
历来
历次
历法
历程
厉声
厉害
厉行
厉行节约
压下量
压价
压低
压倒
压制
压力
压力机
压力表
压力降
压头
压延
压延机
压强
压抑
压挤
压服
压条
压榨
压气
压电
压盖
压缩
压缩机
压缩比
压缩空气
压迫
压迫者
压铸
厌倦
厌恶
厌烦
厕所
厘米
厘金
厚利
厚厚的
厚实
厚度
厚漆
厚薄
原主
原价
原体
原作
原先
原函数
原则
原则性
原动力
原动机
原原本本
原叶体
原告
原因
原地
原型
原基
原始
原始公社
原始公社制度
原始凭证
原始社会
原始积累
原始记录
原子
原子价
原子光谱
原子序数
原子弹
原子核
原子核反应堆
原子结构
原子能
原子能发电
原子说
原子量
原审
原封不动
原形
原性
原意
原故
原文
原料
原料及主要材料
原有
原木
原本
原材料
原来
原案
原棉
原油
原煤
原物
原状
原理
原生动物
原生晕
原生质
原由
原电池
原盐
原矿
原种
原稿
原籍
原粮
原线圈
原肠胚
原色
原著
原虫
原诗
原谅
原野
原音
厢房
厦门
厨子
厨师
厨房
厩肥
去世
去伪存真
去去
去向
去处
去就
去岁
去年
去思
去掉
去杂去劣
去粗取精
去职
去路
去雄
县令
县城
县委
县官
县志
县知事
县长
参与
参与制
参事
参军
参加
参天
参差
参差不齐
参战
参政
参政权
参数
参照
参照物
参看
参考
参考书
参见
参观
参议
参议员
参议院
参谋
参谋长
参赞
参酌
参量
参阅
参预
又及
又红又专
又要
叉子
及早
及时
及格
及第
及至
友人
友军
友好
友好代表团
友情
友爱
友生
友谊
友邦
双丰
双亲
双关
双双
双喜
双子叶植物
双季稻
双层
双手
双打
双折射
双数
双方
双曲线
双氧水
双流
双生
双管
双糖
双职工
双边
双重
双重国籍
双键
双面
反之
反作用
反作用力
反侵略战争
反修
反倒
反光
反光镜
反冲
反击
反函数
反切
反刍
反动
反动分子
反动派
反反
反叛
反右派斗争
反向
反响
反复
反对
反对党
反对关系
反对派
反射
反射定律
反射弧
反射炉
反射角
反差
反帝
反常
反应
反应器
反应堆
反应式
反应方程
反应时间
反应热
反感
反手
反扑
反抗
反接
反推力
反攻
反攻倒算
反映
反映论
反是
反杜林论
反正
反殖
反比例
反民主
反法西斯
反浪费
反演
反潜
反电动势
反省
反码
反经
反而
反证
反证法
反诉
反转
反转片
反过来
反过来说
反问
反霸
反面
反面人物
反面教员
反革命
反革命分子
反馈
反驳
发亮
发作
发信
发光
发冷
发出
发刊
发刊词
发动
发动机
发动机短舱
发包
发号施令
发呆
发声
发奋
发奖
发家
发射
发射机
发射极
发展
发展不平衡
发展中国家
发展生产
发展观
发展速度
发布
发怒
发急
发情
发情周期
发情期
发愁
发扬
发扬光大
发抖
发报
发挥
发掘
发放
发散
发明
发明创造
发昏
发条
发毛
发泄
发泡剂
发源
发源地
发火
发炎
发炮
发烧
发热
发热量
发狂
发狠
发现
发球
发生
发生器
发生炉煤气
发电
发电厂
发电机
发电站
发电量
发疯
发病
发病率
发白
发票
发端
发笑
发紫
发红
发给
发育
发育条件
发胀
发脾气
发臭
发芽
发芽势
发芽率
发菜
发蓝
发行
发表
发觉
发言
发言人
发言权
发誓
发财
发货
发起
发起人
发软
发辫
发达
发达国家
发还
发迹
发送
发送机
发配
发酵
发酵饲料
发酸
发难
发霉
发面
发音
发颤
发黑
叔叔
叔本华
叔父
取下
取代
取保
取决
取出
取巧
取得
取景
取暖
取材
取样
取法
取消
取火
取笑
取经
取缔
取而代之
取胜
取舍
取道
取长补短
受不了
受伤
受到
受制
受力钢筋
受命
受奖
受孕
受审
受害
受寒
受尽
受惊
受托
受挫
受援
受气
受潮
受灾
受热
受理
受病
受益
受粉
受精
受精卵
受累
受罚
受罪
受胎
受胎率
受苦
受训
受贿
受难
受骗
变为
变乱
变位
变修
变动
变化
变卖
变压器
变幻
变异
变异性
变异系数
变形
变形虫
变态
变性
变戏法
变成
变换
变换器
变故
变数
变易
变更
变本加厉
变样
变法
变流器
变电所
变相
变种
变红
变色
变节
变质
变质处理
变迁
变通
变速
变速器
变速运动
变量
变阻器
变革
变频
变频器
变频管
叙事
叙事诗
叙利亚
叙述
叛乱
叛党
叛军
叛匪
叛卖
叛变
叛国
叛徒
叛逆
叠韵
口中
口令
口供
口口声声
口号
口吃
口吻
口味
口器
口外
口头
口头语
口子
口实
口岸
口形
口径
口技
口授
口服
口气
口水
口渴
口琴
口盖
口粮
口罩
口腔
口舌
口袋
口角
口语
口述
口音
口风
古为今用
古书
古人
古今
古今中外
古代
古典
古典主义
古典文学
古城
古巴
古往今来
古怪
古文
古旧
古时候
古来
古物
古生物
古籍
古老
古董
古诗
古话
古迹
古都
古雅
句子
句法
另一方面
另外
另行
叨叨
叩头
只好
只当
只得
只怕
只是
只有
只求
只消
只管
只要
只身
只限
只顾
叫做
叫卖
叫唤
叫喊
叫嚣
叫嚷
叫好
叫苦
叫门
叫骂
召募
召唤
召回
召安
召开
召见
召集
叮咛
叮嘱
叮当
可不
可不可以
可乘之机
可亲
可人
可以
可取
可变
可变电容器
可变资本
可口
可可
可否
可喜
可塑性
可好
可巧
可怕
可怜
可恨
可恶
可悲
可惜
可想而知
可控硅
可敬
可是
可有可无
可望
可汗
可溶性
可燃性
可爱
可疑
可知
可笑
可耻
可能
可能性
可行
可行性
可见
可见光
可观
可谓
可贵
可逆
可逆反应
可锻铸铁
可靠
可靠性
可风
台上
台中
台前
台北
台地
台子
台安
台布
台湾
台灯
台词
台车
台阶
台风
史书
史册
史前
史学
史官
史实
史密斯
史料
史无前例
史略
史籍
史蒂文斯
史记
史论
史诗
史馆
右倾
右倾机会主义
右军
右手
右手定则
右方
右派
右翼
右耳
右边
右面
叶子
叶子烟
叶宗留
叶挺
叶斑病
叶柄
叶片
叶绿体
叶绿素
叶耳
叶肉
叶脉
叶腋
叶芽
叶轮
叶酸
叶面
叶鞘
号令
号召
号子
号数
号码
号称
号角
司令
司令员
司务
司寇
司徒
司机
司法
司法制度
司法权
司法独立
司马
叹息
叹气
吁请
吃上
吃不上
吃不下
吃不开
吃不消
吃了饭
吃亏
吃光
吃力
吃吃
吃奶
吃尽
吃惊
吃水
吃粮
吃紧
吃苦
吃苦耐劳
吃败仗
吃醋
吃食
吃饭
吃香
各个
各个击破
各人
各位
各别
各半
各单位
各各
各向异性
各国
各地
各处
各尽所能
各式各样
各得其所
各族
各界
各省市
各种
各类
各级
各级党委
各级领导
各自
各自为政
各色
各行其是
各行各业
各项
吆喝
合乎
合乎逻辑
合伙
合作
合作化
合作商店
合作社
合剂
合力
合口
合同
合唱
合奏
合子
合宜
合并
合影
合情合理
合意
合成
合成树脂
合成橡胶
合成氨
合成洗涤剂
合成纤维
合拍
合拢
合数
合格
合欢
合法
合法斗争
合流
合理
合理化
合理密植
合理布局
合用
合算
合群
合而为一
合股
合肥
合营
合著
合葬
合计
合议制
合议庭
合谋
合资
合身
合适
合金
合金钢
合闸
吉利
吉安
吉尔
吉布提
吉普车
吉林
吉祥
吉隆坡
吊杆
吊架
吊桶
吊环
吊盘
吊索
吊装
吊车
吊钩
同一
同一性
同上
同业公会
同乡
同事
同产
同人
同仁
同伙
同伴
同位素
同位角
同僚
同化
同化作用
同名
同名数
同姓
同学
同宗
同居
同工同酬
同年
同归
同心
同心协力
同心同德
同志
同性
同情
同意
同感
同旁内角
同时
同期
同样
同案
同正
同步
同步电动机
同气
同治
同源
同甘共苦
同盟
同盟会
同盟军
同盟国
同盟条约
同盟罢工
同知
同科
同等
同类
同类项
同素异形体
同胞
同行
同谋
同轴电缆
同辈
同道
同龄林
名下
名主
名义
名义工资
名人
名册
名分
名利
名副其实
名医
名单
名厨
名号
名堂
名士
名声
名子
名字
名存实亡
名学
名实
名家
名将
名山
名教
名数
名次
名流
名片
名牌
名理
名目
名称
名胜
名菜
名著
名言
名誉
名词
名贵
名额
后世
后主
后事
后于
后人
后代
后件
后任
后作
后勤
后半夜
后卫
后台
后周
后唐
后土
后备
后备军
后天
后头
后学
后宫
后尘
后年
后悔
后患
后手
后排
后掠角
后效
后方
后期
后来
后果
后桥
后梁
后母
后汉
后汉书
后燕
后生
后盾
后秦
后空翻
后者
后肢
后脑
后脚
后行
后裔
后记
后起
后起之秀
后跟
后路
后身
后车
后辈
后边
后进
后退
后送
后门
后院
后面
后项
后顾之忧
吏治
吏部
吐气
吐絮
吐蕃
吐露
吐鲁番
向上
向下
向东
向前进
向北
向右
向后
向学
向导
向左
向往
向心力
向性
向斜
向日
向日葵
向来
向火
向用
向着
向秀丽
向背
向西
向量
向阳
吓倒
吓唬
吓坏
吗啡
君主
君主专制
君主专制制
君主制
君主国
君主立宪
君主立宪制
君子
君权
君王
吞吐
吞吐量
吞吞吐吐
吞噬
吞并
吞没
吞食
否决
否决权
否则
否定
否定一切
否定的否定
否认
吨位
吨公里
吩咐
含义
含冤
含水
含水层
含水量
含混
含笑
含糊
含羞
含胡
含蓄
含蜡
含量
含金量
听从
听任
听众
听信
听候
听凭
听取
听命
听差
听戏
听筒
听见
听觉
听讲
听诊
听话
听说
听课
吭声
吭气
吮吸
启动
启发
启用
启示
启程
启蒙
启蒙运动
启闭
吴中
吴兴
吴县
吴广
吴庭艳
吴敬梓
吴晗
吴梅
吴淞
吴禄贞
吴起
吴越
吵吵
吵吵嚷嚷
吵嘴
吵嚷
吵架
吵闹
吸力
吸取
吸吮
吸引
吸引力
吸收
吸收光谱
吸收剂
吸收塔
吸气
吸湿
吸湿性
吸烟
吸热
吸盘
吸管
吸管虫
吸血鬼
吸附
吸附剂
吸附水
吸食
吹动
吹嘘
吹奏
吹拂
吹捧
吹炼
吹牛
吹风
吹鼓手
吻合
吾人
吾辈
呀呀
呆滞
呈报
呈文
呈现
呈递
告一段落
告别
告发
告密
告急
告成
告状
告知
告示
告终
告诉
告诫
告辞
呋喃
呐喊
呕吐
员工
呜呜
呜呼
呢绒
周书
周公
周刊
周到
周勃
周围
周天
周家
周密
周岁
周年
周折
周报
周文
周旋
周易
周期
周期函数
周期律
周期性
周末
周武王
周波
周游
周率
周瑜
周相
周知
周而复始
周至
周角
周身
周转
周边
周道
周长
呱呱
味精
味道
呵呵
呵斥
呵欠
呻吟
呼叫
呼号
呼吁
呼吸
呼吸困难
呼吸系统
呼吸道
呼和浩特
呼唤
呼啸
呼喊
呼声
呼应
呼救
命中
命令
命令
命名
命根子
命脉
命题
咀嚼
咆哮
咋办
和丰
和买
和亲
和会
和加
和南
和县
和善
和声
和头
和好
和尚
和局
和州
和平
和平共处
和平谈判
和平过渡
和弦
和政
和数
和文
和易
和春
和暖
和服
和村
和棋
和气
和田
和睦
和约
和缓
和蔼
和解
和议
和诗
和谈
和谐
和静
和顺
和风
咒骂
咕咕
咕嘟
咖啡
咖啡色
咬住
咬牙
咬牙切齿
咯咯
咱们
咱俩
咱家
咳嗽
咸丰
咸宁
咸水
咸海
咸淡
咸菜
咸阳
咽喉
咽头
哀乐
哀号
哀叹
哀悼
哀愁
哀歌
哀求
哀鸣
品位
品名
品尝
品德
品性
品格
品种
品类
品系
品级
品花宝鉴
品行
品评
品质
品质因数
哄抬
哆嗦
哇啦
哈佛大学
哈克
哈利
哈吉
哈哈
哈密
哈尔滨
哈尼族
哈桑
哈特
哈瓦那
哈达
响亮
响动
响声
响应
响彻
哎呀
哎哟
哑巴
哑谜
哑铃
哔叽
哗变
哗啦
哗啦啦
哗然
哥伦布
哥伦比亚
哥儿
哥儿俩
哥哥
哥斯达黎加
哥本哈根
哥白尼
哥老会
哥达纲领批判
哨兵
哨子
哨所
哪个
哪些
哪儿
哪怕
哪能
哪里
哭丧着脸
哭哭啼啼
哭泣
哭诉
哲学
哲学家
哲理
哺乳
哺乳动物
哺育
哼哼
哽咽
唁电
唆使
唉声叹气
唐中
唐人
唐太宗
唐山
唐律
唐才常
唐玄宗
唐甄
唐绍仪
唐继尧
唐赛儿
唛头
唠叨
唢呐
唤起
唤醒
唧唧
售价
售卖
售货
唯一
唯利是图
唯心
唯心主义
唯心史观
唯心论
唯恐
唯物
唯物主义
唯物史观
唯物论
唯物辩证法
唯独
唱名
唱和
唱戏
唱本
唱歌
唱片
唱腔
唱词
唾弃
唾沫
唾液
唾液腺
啄食
商丘
商业
商业利润
商业网
商业资本
商业部
商业银行
商人
商人资本
商会
商务
商务印书馆
商号
商君
商君书
商品
商品流转
商品流通
商品流通费
商品生产
商品粮
商品经济
商品资本
商品资金
商品输出
商团
商场
商埠
商定
商州
商店
商数
商标
商标法
商榷
商法
商洛
商界
商约
商船
商讨
商议
商谈
商谜
商贩
商贾
商路
商量
商鞅
啊哈
啤酒
啥子
啧啧
啮合
啼哭
喀土穆
喀布尔
喀斯特
喀斯特水
喀琅施塔得
喀麦隆
喂养
喃喃
善后
善心
善意
善战
善本
善良
喇叭
喇叭口
喇嘛
喉咙
喉头
喉舌
喊叫
喋喋不休
喘气
喜事
喜人
喜出望外
喜剧
喜好
喜子
喜庆
喜怒哀乐
喜悦
喜报
喜欢
喜气
喜气洋洋
喜爱
喜讯
喜酒
喜闻乐见
喜马拉雅山
喜鹊
喝道
喝酒
喝采
喧哗
喧嚣
喧嚷
喧闹
喷丝头
喷嘴
喷嚏
喷头
喷射
喷射泵
喷枪
喷气
喷气发动机
喷气式
喷气式飞机
喷油器
喷泉
喷洒
喷溅
喷漆
喷管
喷粉器
喷花
喷镀
喷雾
喷雾器
喷香
嗅觉
嗉囊
嗓子
嗓门
嗓音
嗜好
嗜欲
嗡嗡
嗣后
嘀咕
嘈杂
嘉兴
嘉奖
嘉定
嘉庆
嘉禾
嘉靖
嘎嘎
嘟嘟
嘟囔
嘱咐
嘲弄
嘲笑
嘲讽
嘴唇
嘴巴
嘴脸
嘶哑
嘹亮
嘻嘻
嘻嘻哈哈
嘿嘿
器乐
器件
器使
器具
器官
器材
器械
器物
器用
器皿
器重
噪声
噪音
噬菌体
嚣张
嚷嚷
囊胚
囚禁
四个现代化
四乡
四书
四五运动
四人帮
四倍体
四分五裂
四分音符
四则
四则运算
四化
四周
四围
四国
四国银行团
四声
四处
四外
四大
四大家族
四季
四川
四川盆地
四川省
四平
四散
四方
四旁
四时
四月八
四极管
四氯化碳
四洲志
四海
四端
四类
四美
四肢
四至
四舍五入
四行
四角
四象
四起
四边
四边形
四通八达
四邻
四部
四镇
四面
四面体
四面八方
四顾
回丝
回中
回乡
回交
回信
回击
回动
回升
回去
回合
回味
回响
回回
回填
回声
回复
回头
回头一看
回家
回师
回归
回忆
回忆录
回忆说
回想
回手
回扣
回收
回收率
回教
回旋
回旋加速器
回族
回来
回民
回水
回波
回游
回潮
回潮率
回火
回环
回电
回程
回笼
回答
回老家
回荡
回见
回赎
回路
回转
回转半径
回采
回音
回顾
回风
回首
因为
因势利导
因地制宜
因子
因式
因式分解
因循
因循守旧
因故
因数
因果
因次
因此
因素
因缘
因而
因袭
因陋就简
团体
团体操
团员
团团
团圆
团委
团练
团结
团聚
团茶
团长
囤积
园丁
园地
园子
园寝
园林
园田
园田化
园艺
困倦
困境
困惑
困苦
困难
围剿
围困
围垦
围城
围墙
围岩
围巾
围攻
围歼
围绕
围网
围裙
固体
固体燃料
固化
固化剂
固守
固定
固定床
固定资产
固定资产大修理
固定资产折旧
固定资本
固定资金
固山
固态
固执
固有
固有频率
固氮
固氮作用
固溶体
固然
固结
固醇
国书
国事
国产
国人
国会
国会制
国体
国债
国公
国内
国内外
国内战争
国内法
国力
国务
国务会议
国务卿
国务总理
国务部长
国务院
国号
国君
国土
国境
国外
国子监
国学
国家
国家与革命
国家元首
国家利益
国家制度
国家基金
国家形式
国家报
国家机关
国家机器
国家机密
国家机构
国家权力
国家权力机关
国家标准
国家法
国家社会主义
国家积累
国家考试
国家行政机关
国家资本主义
国家银行
国家预算
国庆
国庆节
国库
国度
国徽
国情
国戚
国故
国文
国旗
国是
国有
国有化
国朝
国歌
国民
国民会议
国民党
国民报
国民收入
国民政府
国民生产总值
国民经济
国民经济计划
国民警卫队
国民革命军
国法
国王
国用
国画
国界
国立
国策
国籍
国粹
国联
国舅
国营
国营企业
国营农场
国营商业
国语
国语罗马字
国货
国贼
国都
国防
国防军
国防力量
国防委员会
国防工业
国际
国际主义
国际公约
国际劳动节
国际单位制
国际博览会
国际局势
国际帝国主义
国际惯例
国际收支
国际标准
国际歌
国际法
国际法院
国际私法
国际经济新秩序
国际联盟
国际舞台
国际贸易
国际钢铁卡特尔
国际铝卡特尔
国难
国音
国风
图为
图书
图书馆
图例
图式
图形
图拉
图景
图样
图案
图片
图画
图章
图纸
图表
图解
图解法
图说
图谋
图象
圆台
圆周
圆周率
圆周角
圆圆的
圆圈
圆弧
圆形
圆心
圆心角
圆柱
圆柱体
圆柱面
圆桌
圆润
圆滑
圆满
圆球
圆盘
圆筒
圆经
圆规
圆钢
圆锥
圆锥曲线
圆面积
圈地
圈套
圈子
圈梁
圈点
土产
土人
土匪
土地
土地国有化
土地改革
土地改革运动
土地税
土地证
土地革命
土坯
土壤
土壤微生物
土壤有机质
土壤水
土壤温度
土壤湿度
土壤溶液
土壤结构
土壤肥力
土壤胶体
土崩瓦解
土工
土布
土性
土改
土断
土方
土族
土气
土法
土法生产
土洋并举
土洋结合
土温
土特产
土石方
土粪
土耳其
土著
土话
土豆
土豪
土豪劣绅
土门
土霉素
土黄
圣上
圣人
圣地
圣地亚哥
圣旨
圣明
圣母
圣洁
圣经
圣贤
在下
在世
在乎
在产品
在位
在先
在制品
在即
在在
在场
在家
在帮
在座
在心
在意
在押
在握
在教
在望
在朝
在案
在理
在编
在职
在职干部
在行
在逃
在野
圭亚那
地下
地下室
地下害虫
地下开采
地下水
地下水位
地下茎
地中海
地主
地主分子
地主阶级
地产
地亩
地价
地位
地位级
地保
地利
地力
地动
地势
地区
地压
地名
地图
地地道道
地址
地块
地域
地基
地基承载力
地壳
地大物博
地头
地委
地学
地层
地带
地幔
地平
地平线
地形
地形图
地心
地拉那
地支
地政
地方
地方军
地方分权
地方国营
地方工业
地方戏
地方政府
地方武装
地方病
地方税
地方自治
地方部队
地板
地步
地段
地毯
地波
地洞
地温
地滚球
地点
地热
地物
地狱
地球
地球化学
地理
地理位置
地理学
地理环境
地瓜
地电
地界
地痞
地皮
地盘
地磁
地租
地积
地税
地窖
地线
地维
地脚
地蜡
地衣
地表
地貌
地质
地质图
地质学
地质编录
地轴
地道
地铁
地雷
地震
地震学
地震预报
地面
地面水
地面温度
地面站
地面部队
地龙
场合
场地
场子
场所
场效应晶体管
场景
场院
场面
场频
均一
均分
均势
均匀
均热
均热炉
均田
均田制
均相
均等
均衡
均贫富
坍塌
坍落度
坎坷
坎帕拉
坏人
坏分子
坏处
坏死
坏蛋
坏话
坐定
坐待
坐标
坐牢
坐立不安
坐落
坐视
坐谈会
坐镇
坑木
坑道
块儿
块块
块根
块煤
块状
块茎
坚信
坚决
坚固
坚守
坚定
坚定不移
坚实
坚强
坚持
坚持不懈
坚毅
坚牢度
坚硬
坚韧
坚韧不拔
坛子
坝子
坟墓
坠落
坡地
坡度
坡道
坦克
坦桑尼亚
坦然
坦率
坦白
坦荡
坩坩
坯布
坯料
垂体
垂危
垂头丧气
垂心
垂死
垂死挣扎
垂直
垂直平分线
垂直线
垂直面
垂线
垂足
垄断
垄断价格
垄断利润
垄断组织
垄断资产阶级
垄断资本
垄断资本主义
型号
型砂
型钢
垒球
垦区
垦复
垦殖
垦荒
垫付
垫圈
垫子
垫支资本
垫板
垫片
垮台
埃及
埃塞俄比亚
埋伏
埋头
埋头苦干
埋怨
埋没
埋葬
埋藏
城乡
城区
城南
城堡
城墙
城市
城市国家
城市规划
城市贫民
城旦
城楼
城池
城西
城郊
城郭
城里
城镇
城门
城防
城隍
域外
培养基
培养目标
培土
培根
培植
培训
基准
基准面
基因
基因型
基团
基地
基坑
基尔
基尔霍夫
基层
基层人民法院
基岩
基干
基底
基建
基态
基本
基本上
基本功
基本原则
基本建设
基本建设投资
基本建设项目
基本核算单位
基本生产
基本矛盾
基本粒子
基本经济规律
基本苗
基本路线
基极
基洛夫
基点
基督
基督教
基石
基础
基础理论
基础科学
基础课
基线
基肥
基色
基调
基质
基辅
基辛格
基金
基音
堂上
堂会
堂倌
堂堂
堂子
堂客
堂屋
堂皇
堆放
堆焊
堆积
堆肥
堕入
堕落
堡垒
堡子
堤坝
堤岸
堤防
堵住
堵口
堵塞
堵截
塌方
塌陷
塑像
塑性
塑性变形
塑性材料
塑料
塑胶
塑造
塔吉克
塔式起重机
塔斯社
塘泥
塞上
塞内加尔
塞外
塞子
塞尔维亚
塞拉利昂
塞浦路斯
塞舌尔
填充
填写
填平
填料
填料函
填补
填鸭
境况
境地
境界
境遇
墒情
墓地
墓志铭
墓碑
墓葬
墙基
墙头
墙根
墙脚
墙角
增产
增产节约
增值
增兵
增减
增加
增压
增塑剂
增多
增大
增强
增强塑料
增拨
增援
增殖
增氧机
增添
增生
增益
增补
增订
增设
增进
增量
增长
增长率
增长速度
增音机
增高
墨子
墨家
墨水
墨汁
墨笔
墨索里尼
墨线
墨经
墨绿
墨翟
墨西哥
墨西哥城
墨西哥湾
墨西哥湾暖流
墨鱼
壁垒
壁报
壁炉
壁画
壕沟
壤土
士人
士兵
士卒
士大夫
士女
士官
士族
士林
士民
士气
士绅
壮丁
壮丽
壮健
壮士
壮大
壮年
壮志
壮族
壮烈
壮美
壮苗
壮观
声东击西
声乐
声势
声势浩大
声区
声名
声响
声地
声威
声学
声带
声张
声息
声援
声明
声望
声母
声气
声波
声浪
声称
声纳
声色
声言
声誉
声讨
声调
声速
声部
声音
声频
处事
处于
处决
处分
处刑
处境
处处
处女
处心积虑
处所
处方
处暑
处死
处治
处理
处理机
处罚
处置
处长
备件
备品
备忘录
备战
备料
备查
备案
备用
备耕
备至
备荒
备课
复习
复仇
复位
复信
复兴社
复写
复分解反应
复利
复制
复印
复原
复发
复古
复句
复合
复合材料
复名数
复员
复员军人
复壮
复审
复工
复数
复数的模
复旦大学
复旧
复杂
复杂劳动
复杂生产
复查
复核
复次
复活
复电
复盖
复种
复种指数
复苏
复议
复课
复赛
复述
复选
复音
夏令营
夏历
夏天
夏季
夏完淳
夏收
夏种
夏粮
夏至
夕阳
外乡
外事
外交
外交代表
外交使节
外交官
外交特权
外人
外侨
外侮
外债
外公
外公切线
外力
外力作用
外加
外务
外勤
外史
外号
外商
外因
外因论
外围
外国
外国语
外在
外地
外场
外壳
外头
外套
外套膜
外婆
外孙
外学
外宾
外层空间
外屋
外延
外弦
外形
外心
外患
外戚
外接圆
外援
外敌
外文
外族
外来
外水
外汇
外洋
外流
外海
外焰
外生
外甥
外用
外电
外电路
外界
外省
外线
外行
外衣
外表
外观
外角
外语
外调
外貌
外货
外贸
外资
外转
外边
外逃
外部
外销
外长
外间
外面
外项
多久
多么
多事
多亏
多云
多伦多
多位数
多倍体
多分
多功能
多加
多劳多得
多变
多咱
多哥
多嘴
多多
多头
多孔
多孔塑料
多寡
多少
多年
多年来
多年生
多德
多心
多快好省
多情
多拉
多数
多方
多方面
多时
多普勒
多样化
多次
多民族国家
多玛河
多相
多种
多种多样
多种经营
多端
多米尼加
多肽
多臂机
多角形
多谢
多边
多边形
多远
多醣
多长
多面体
多面角
多项式
多高
夜以继日
夜半
夜叉
夜大学
夜市
夜幕
夜晚
夜景
夜来
夜校
夜班
夜航
夜色
夜袭
夜里
夜间
大一
大一统
大丈夫
大不列颠
大专院校
大世界
大业
大东
大个儿
大个子
大中
大丰
大主教
大举
大义
大书
大事
大于
大人
大人物
大仲马
大众
大众化
大众语
大伙儿
大会
大伯
大体
大体上
大作
大使
大使级
大使馆
大便
大修
大修理
大修理基金
大儒
大元帅
大公
大公报
大公无私
大关
大兴
大兴土木
大兴安岭
大兵
大典
大写
大军
大冶
大凡
大刀
大刀阔斧
大分
大分子
大别山
大前提
大力
大办
大功
大功告成
大功率
大动脉
大势
大势已去
大势所趋
大化
大区
大半
大协作
大卡
大卫
大印
大厂
大厅
大历
大厦
大叔
大受
大叶桉
大号
大司马
大合唱
大同
大同书
大同小异
大名
大吏
大吕
大员
大命
大和
大哥
大商人
大喊大叫
大喜
大圆
大土
大地
大坂
大块
大坝
大型
大型企业
大城
大堂
大声疾呼
大多
大多数
大大
大大的
大夫
大头
大头针
大好
大妈
大姐
大姑娘
大姓
大娘
大嫂
大字报
大学
大学士
大学生
大安
大宗
大定
大客车
大家
大家庭
大寨
大将
大将军
大尉
大小
大少爷
大局
大川
大师
大帽子
大幅度
大干
大平
大年
大庆
大庙
大建
大张旗鼓
大德
大志
大忙
大总统
大悟
大患
大惊小怪
大意
大戏
大成
大户
大批
大抵
大拇指
大指
大捷
大敌
大教堂
大数
大料
大新
大方
大方向
大族
大无畏
大无畏精神
大春
大昭寺
大显身手
大曲
大曲酒
大月
大有
大有可为
大本营
大权
大杨树
大林
大校
大梁
大棒
大楼
大概
大模大样
大步
大殿
大比
大毛
大民主
大气
大气压
大气层
大水
大汉
大江
大河
大油
大治
大沽
大泉眼
大法
大法官
大洋
大洋洲
大洲
大流
大海
大渡河
大港
大湖
大漠
大火
大灯
大炮
大烟
大爷
大率
大王
大理
大理寺
大理石
大理院
大用
大田
大略
大白
大白菜
大白鼠
大真
大石
大石头
大秦
大端
大竹
大笔
大管
大米
大粪
大红
大约
大纲
大经
大统
大老
大肆
大肚子
大肠
大肠杆菌
大胆
大脑
大脑皮层
大脚
大腿
大臣
大自然
大致
大节
大草原
大菜
大葱
大蒜
大虾
大行
大行政区
大行星
大街
大衣
大褂
大西
大西洋
大要
大观
大规模
大规模集成电路
大角
大解
大计
大话
大诰
大调
大豆
大象
大败
大资产阶级
大赦
大跃进
大路
大踏步
大车
大辩论
大过
大运河
大连
大逆
大逆不道
大选
大通
大道
大道理
大部
大部分
大都
大量
大量生产
大金
大钱
大钳
大锅饭
大错
大门
大门外
大队
大陆
大陆架
大限
大院
大院君
大难
大雁
大雅
大雨
大雪
大青
大面
大革命
大音阶
大顺
大颚
大风
大风大浪
大饼
大马士革
大麦
大麻
大黄
大黄鱼
大鼓
天一
天上
天下
天下太平
天主
天主教
天书
天井
天京
天亮
天人
天会
天佑
天体
天使
天保
天光
天全
天兵
天半
天后
天命
天和
天国
天地
天地会
天坛
天堂
天天
天头
天契
天子
天安门
天安门事件
天安门广场
天完
天宝
天山
天工
天工开物
天幕
天干
天平
天底下
天开
天性
天意
天成
天才
天才论
天择
天授
天放
天敌
天数
天文
天文单位
天文台
天文学
天日
天时
天明
天柱
天桥
天棚
天正
天气
天气形势
天气现象
天气预报
天水
天沟
天波
天津
天津市
天涯
天演论
天灾
天然
天然丝
天然更新
天然杂交
天然林
天然树脂
天然橡胶
天然气
天然气井
天然漆
天然碱
天然纤维
天然饵料
天王
天王星
天球
天理
天理教
天生
天电
天皇
天目山
天真
天祚帝
天神
天空
天窗
天竺
天纵
天线
天经地义
天色
天花
天花乱坠
天花板
天葬
天蓝
天论
天说
天象
天资
天赋
天赐
天车
天边
天道
天长
天门
天际
天险
天雄
天顺
天鹅
太仓
太保
太傅
太公
太医院
太原
太原市
太古
太后
太君
太和
太太
太子
太学
太守
太尉
太师
太平
太平军
太平天国
太平天国革命
太平广记
太平洋
太平道
太平门
太康
太极
太极拳
太湖
太爷
太甚
太甲
太白
太监
太祖
太空
太虚
太阳升
太阳日
太阳活动
太阳电池
太阳穴
太阳系
太阳能
太阳辐射
夫人
夫妇
夫妻
夫子
夫权
夫琅和费
夭折
央求
失业
失事
失传
失信
失修
失利
失势
失却
失去
失地
失声
失学
失守
失常
失当
失手
失掉
失措
失效
失散
失明
失望
失水
失火
失灵
失真
失眠
失职
失色
失落
失血
失误
失调
失足
失踪
失速
失重
失陷
头像
头发
头号
头天
头头是道
头套
头子
头寸
头巾
头年
头晕
头版
头痛
头皮
头目
头等
头绪
头羊
头胸部
头脑
头茬
头衔
头部
头里
头面人物
头顶
头颅
头颈
头骨
夸大
夸奖
夸张
夸耀
夹具
夹击
夹子
夹层
夹带
夹心
夹攻
夹杂
夹板
夹角
夹道
夺取
夺回
夺得
夺目
奄奄一息
奇事
奇兵
奇妙
奇峰
奇异
奇怪
奇数
奇景
奇特
奇观
奇谈
奇谈怪论
奇迹
奇闻
奈何
奉公
奉告
奉命
奉天
奉承
奉献
奉系军阀
奉节
奉行
奉送
奋不顾身
奋力
奋勇
奋发
奋发图强
奋战
奋斗
奋起
奏折
奏效
奏疏
奏章
奏议
奏鸣曲
契丹
契卡
契机
奔放
奔波
奔流
奔腾
奔走
奔走相告
奔赴
奔跑
奔驰
奖励
奖品
奖售
奖惩
奖状
奖章
奖赏
奖金
套作
套套
套子
套种
套筒
套间
奚落
奠基
奠基人
奠定
奢侈
奢侈品
奢望
奥古斯丁
奥地利
奥妙
奥斯戮
奥斯特
奥林
奥氏体
奥秘
奥运会
女主人
女人
女人家
女仆
女儿
女同志
女士
女婿
女子
女孩
女孩子
女工
女性
女方
女服务员
女王
女皇
女真
女神
女贞
女郎
女高音
奴仆
奴婢
奴役
奴才
奴隶
奴隶主
奴隶制
奴隶制度
奴隶劳动
奴隶社会
奴隶起义
奶头
奶奶
奶妈
奶油
奶牛
奶粉
奶糖
奸商
奸淫
奸细
奸臣
奸诈
奸雄
她们
她们的
她的
好一个
好不
好久
好事
好些
好人
好似
好使
好像
好几个
好友
好受
好吃
好听
好在
好坏
好处
好多
好天儿
好奇
好奇心
好好
好好的
好学
好孩子
好客
好家伙
好容易
好心
好意
好意思
好感
好戏
好战
好手
好日子
好极了
好歹
好比
好汉
好球
好生
好的
好看
好端端
好笑
好评
好话
好说
好象
好起来
好转
好过
如上
如上所述
如下
如东
如云
如今
如何
如兄
如其
如同
如实
如常
如干
如意
如愿
如故
如数
如是
如月
如期
如来
如果
如次
如此
如此等等
如火如荼
如皋
如若
如雨
如饥似渴
妄图
妄想
妇产科
妇人
妇女
妇幼
妇联
妈妈
妊娠
妓女
妓院
妖道
妖风
妖魔
妙计
妥协
妥善
妥当
妨害
妨碍
妩媚
妹夫
妹妹
妹子
妻子
姊妹
始末
始祖
始终
始终不渝
始终如一
姐夫
姐妹
姐姐
姑且
姑妈
姑姑
姑娘
姑娘家
姑母
姑洗
姑父
姑爷
姓名
姓氏
委任
委内瑞拉
委员
委员会
委员长
委实
委屈
委托
委派
姥姥
姨太太
姨妈
姻亲
姻缘
姿势
姿态
威严
威信
威力
威势
威吓
威尔
威尔逊
威尼斯
威廉
威慑
威望
威权
威武
威海
威胁
威逼
威风
娃娃
娃子
娇嫩
娘儿
娘儿们
娘娘
娘子
娘子军
娘家
娜拉
娱乐
娲杆
娲轮
娼妓
婆姨
婆娘
婆婆
婆媳
婆家
婆罗门
婉言
婚事
婚姻
婚姻制度
婚姻法
婚姻自由
婚期
婚礼
婚约
婚配
婴儿
婴孩
婶子
媒人
媒介
媒婆
媒质
媚外
媲美
媳妇
媳妇儿
媾和
嫁妆
嫁接
嫂嫂
嫂子
嫉妒
嫌疑
嫡系
嫣然
嫦娥
嫩绿
嬉戏
嬷嬷
子产
子代
子儿
子午线
子口
子叶
子囊
子囊壳
子夏
子女
子孙
子实
子宫
子弟
子弟兵
子弹
子思
子房
子时
子来
子棉
子粒
孔丘
孔口
孔型
孔墨
孔孟之道
孔庙
孔径
孔德
孔教
孔数
孔洞
孔穴
孔道
孔隙
孔雀
孔雀东南飞
孔雀石
孕妇
孕期
孕穗
孕穗期
孕育
字义
字体
字儿
字典
字句
字号
字形
字据
字样
字母
字画
字眼
字符
字迹
字面
字音
存亡
存储
存储器
存在
存心
存放
存栏
存款
存货
存贮器
孙中山
孙传庭
孙传芳
孙吴
孙女
孙子
孙悟空
孙文
孙权
孙武
孙竹
孙膑
孜孜
孝子
孝廉
孝弟
孝感
孝敬
孝经
孝顺
孟买
孟什维克
孟加拉国
孟子
孟德斯鸠
孟轲
孢子
孢子囊
季度
季节
季节性
季风
孤儿
孤军
孤单
孤注一掷
孤独
孤立
孤苦
孤零零
学业
学习
学习班
学会
学位
学军
学分
学制
学博
学历
学名
学堂
学士
学好
学子
学工
学年
学徒
学徒工
学报
学政
学文
学时
学期
学术
学术界
学校
学派
学海
学理
学生
学生会
学生自治会
学生运动
学界
学科
学究
学系
学者
学艺
学识
学说
学费
学问
学风
学龄
孩儿
孩子
孩子气
孩童
孵化
孵化率
孵卵
孺子
宁冈
宁可
宁夏
宁夏回族自治区
宁愿
宁波
宁肯
宁静
它们
它们的
它的
宇宙
宇宙空间
宇宙线
宇宙观
宇宙飞船
宇文化及
宇文泰
宇航
守候
守军
守则
守卫
守备
守恒定律
守护
守旧
守法
守节
守车
守门
安丘
安东
安乐
安乡
安于
安人
安全
安全带
安全措施
安全检查
安全理事会
安全生产
安全系数
安全阀
安分守己
安南
安卡拉
安危
安史之乱
安哥拉
安国
安培
安好
安娜
安宁
安安静静
安定
安家
安家落户
安居
安居乐业
安平
安庆
安徽
安徽省
安心
安息
安慰
安戮
安抚
安排
安插
安放
安民
安源
安然
安理会
安生
安甯
安禄山
安福
安第斯山
安第斯山脉
安置
安葬
安装
安设
安详
安身
安逸
安闲
安阳
安静
安顿
宋书
宋儒
宋史
宋太祖
宋学
宋庆
宋徽宗
宋教仁
宋文帝
完事
完人
完全
完善
完备
完好
完完全全
完工
完成
完整
完满
完结
完美
完蛋
宏伟
宏图
宏大
宏观
宗主
宗主国
宗子
宗室
宗庙
宗教
宗教改革
宗族
宗旨
宗法
宗法制度
宗派
宗派主义
官人
官价
官僚
官僚主义
官僚资产阶级
官僚资本
官僚资本主义
官兵
官军
官办
官司
官吏
官地
官场
官家
官属
官庄
官府
官方
官气
官渡
官爵
官田
官窑
官署
官职
官能
官能团
官话
官长
定义
定产
定价
定位
定准
定则
定制
定单
定县
定名
定向
定向天线
定员
定型
定婚
定子
定局
定居
定居点
定州
定幅
定弦
定当
定形
定影
定律
定心
定性
定户
定日
定时
定期
定本
定案
定植
定海
定滑轮
定点
定然
定理
定神
定稿
定罪
定苗
定规
定计划
定论
定调
定货
定都
定量
定额
宛如
宜人
宜兴
宜宾
宜昌
宜春
宜阳
宝丰
宝剑
宝塔
宝宝
宝山
宝庆
宝库
宝座
宝成铁路
宝物
宝石
宝藏
宝贝
宝贵
宝鸡
实业
实业家
实业界
实习
实事求是
实体
实体法
实例
实况
实则
实力
实力派
实在
实地
实学
实实
实实在在
实干
实心
实心球
实情
实惠
实战
实效
实数
实施
实权
实根
实物
实物地租
实现
实生林
实用
实用主义
实益
实相
实行
实话
实质
实践
实践论
实践证明
实际
实际上
实际工资
实际情况
实际成本
实际气体
实验
实验心理学
宠信
宠爱
审判
审判员
审判官
审判权
审判长
审察
审慎
审批
审查
审核
审理
审美
审美活动
审视
审议
审讯
审问
审阅
客人
客体
客厅
客商
客土
客堂
客户
客房
客机
客气
客舱
客船
客观
客观主义
客观唯心主义
客观存在
客观实在
客观真理
客货
客车
客轮
客运
宣传
宣传员
宣传部
宣传队
宣判
宣告
宣告成立
宣布
宣德
宣战
宣武
宣示
宣称
宣纸
宣统
宣言
宣誓
宣讲
宣读
室内
室外
宦官
宪兵
宪政
宪法
宪法大纲
宪章
宫保
宫墙
宫女
宫室
宫廷
宫殿
宫调
宫里
宰割
宰杀
宰相
害处
害怕
害羞
害臊
宴会
宴席
宴请
家世
家业
家乡
家书
家事
家产
家人
家伙
家信
家兔
家具
家务
家史
家喻户晓
家园
家境
家奴
家学
家室
家家
家家户户
家属
家山
家常
家底
家庭
家庭副业
家庭手工业
家当
家族
家法
家父
家用
家畜
家破人亡
家蚕
家谱
家财
家长
家长制
家门
家鸽
容器
容幸
容忍
容抗
容易
容积
容纳
容许
容貌
容重
容量
容量瓶
宽厚
宽大
宽容
宽广
宽度
宽慰
宽敞
宽窄
宽裕
宽阔
宾主
宾客
宾州
宾馆
宿卫
宿命论
宿舍
宿营
寂寞
寂静
寄主
寄予
寄信
寄存
寄存器
寄寓
寄托
寄生
寄生物
寄生虫
密云
密令
密切
密实
密密的
密密麻麻
密封
密布
密度
密探
密接
密植
密电
密码
密谈
密谋
密闭
密集
富丽
富丽堂皇
富农
富农分子
富农经济
富庶
富强
富春江
富有
富民
富海
富源
富矿
富裕中农
富豪
富贵
富足
富饶
寒假
寒冬
寒冷
寒带
寒心
寒气
寒流
寒潮
寒热
寒衣
寒露
寒风
寓于
寓所
寓言
寝室
察哈尔
察看
察觉
察院
寡不敌众
寡头
寡妇
寥寥
寨子
寸土
寸步
寸长
对不住
对不起
对付
对位
对保
对偶
对儿
对光
对内
对准
对半
对口
对口相声
对外
对外贸易
对头
对子
对局
对山
对岸
对峙
对应
对开
对当
对待
对得起
对心
对手
对抗
对抗性
对折
对数
对数函数
对数方程
对文
对方
对本
对案
对流
对流层
对消
对照
对生
对症下药
对白
对眼
对硫磷
对称
对称中心
对称轴
对立
对立统一
对立统一规律
对立面
对等
对策
对红
对联
对苯二甲酸
对苯二酚
对虾
对角
对角线
对证
对话
对读
对调
对象
对质
对路
对转
对过
对门
对面
对顶角
寺庙
寺院
寻常
寻找
寻求
寻觅
寻访
导体
导向
导师
导弹
导数
导板
导流
导演
导火索
导热
导电
导盘
导管
导纳
导线
导致
导航
导言
导轨
导轮
寿命
寿州
寿阳
封冻
封口
封地
封存
封山
封山育林
封建
封建主
封建主义
封建割据
封建性
封建文化
封建残余
封建礼教
封建社会
封建道德
封条
封锁
封面
射击
射向
射影
射手
射流
射箭
射线
射门
射阳
将军
将士
将官
将就
将帅
将来
将校
将要
将近
将领
尊严
尊卑
尊崇
尊敬
尊称
尊贵
尊重
尊长
小丑
小业主
小东
小书
小五
小井
小人
小伙子
小体
小便
小偷
小儿
小兴安岭
小册子
小写
小农
小农经济
小刀
小分队
小功
小半
小口径
小可
小叶
小号
小吃
小名
小品
小商品
小商品生产
小商品经济
小型
小城
小姐
小姑
小子
小字
小学
小学生
小孩
小家庭
小将
小小
小小的
小工
小巧
小市民
小康
小建
小弟
小弟弟
小张
小心
小心翼翼
小心谨慎
小意思
小戏
小户
小报
小指
小提琴
小数
小数点
小时
小时候
小春
小曲
小朋友
小朝廷
小样
小步
小步舞曲
小毛
小气
小气候
小水
小河
小溪
小班
小生
小生产
小生产者
小白
小白菜
小白鼠
小看
小秋收
小穗
小站
小算盘
小米
小组
小结
小老婆
小肠
小脑
小脚
小腹
小腿
小船
小艇
小节
小苏打
小行星
小解
小说
小说家
小说月报
小调
小贩
小资产阶级
小车
小轿车
小辫子
小道
小量
小金
小队
小队长
小雅
小集团
小雨
小项
小高炉
小鬼
小麦
小黄
小黄鱼
少不了
少不得
少先队
少壮
少女
少奶奶
少妇
少将
少尉
少年
少年先锋队
少年宫
少数
少数民族
少时
少校
少爷
少见
少许
少量
少顷
尔后
尔格
尔雅
尖兵
尖刀
尖利
尖头
尖子
尖晶石
尖端
尖锐
尖顶
尘世
尘土
尘埃
尚且
尚书
尚书省
尚未
尝试
尤其
尧舜
就业
就中
就义
就事
就任
就便
就势
就医
就地
就地取材
就学
就座
就是
就是说
就正
就此
就算
就绪
就职
就范
就要
就让
就近
就餐
尸体
尸僵
尸斑
尸身
尸首
尸骨
尺寸
尺度
尼克
尼克松
尼加拉瓜
尼古拉
尼姑
尼斯
尼日利亚
尼日尔
尼泊尔
尼罗河
尼赫鲁
尼采
尼龙
尽义务
尽人皆知
尽先
尽力
尽可能
尽头
尽心
尽忠
尽快
尽情
尽是
尽管
尽自
尽量
尾声
尾巴
尾数
尾气
尾矿
尾翼
尾随
尾鳍
尿素
局促
局促不安
局势
局外人
局部
局长
局限
局限性
局面
屁股
层出不穷
层压
层压板
层层
层次
层流
层理
层高
居中
居于
居住
居士
居多
居心
居民
居民点
居然
居留
居里
居高临下
屈从
屈伸
屈原
屈服
屈氏体
屈膝
屈辱
届时
届满
屋头
屋子
屋宇
屋架
屋檐
屋脊
屋面
屋面板
屋顶
屏幕
屏极
屏蔽
屏障
屏风
展出
展品
展开
展弦比
展望
展期
展现
展示
展翅
展览
展览会
展览馆
属于
属国
属地
属实
属性
属概念
屠刀
屠宰
屠宰场
屠杀
屡教不改
屡次
屡见不鲜
履历
履带
履行
屯子
屯田
屯田客
屯里
山东
山东半岛
山东省
山乡
山人
山前
山包
山区
山南
山口
山地
山坡
山城
山墙
山头
山寨
山岭
山岳
山峦
山峰
山崖
山崩
山川
山庄
山房
山杨
山林
山查
山根
山梁
山歌
山水
山水画
山沟
山河
山泉
山洞
山洪
山洼
山海关
山海经
山炮
山系
山羊
山脉
山脚
山腰
山芋
山茶
山药
山西
山谷
山货
山路
山里红
山门
山阳
山阴
山顶
山风
山麓
屹立
岁入
岁出
岁数
岁月
岂敢
岂有此理
岂止
岂能
岂非
岑春煊
岔子
岔开
岔路
岗位
岗位责任制
岗哨
岗地
岛国
岛屿
岩层
岩心
岩洞
岩浆
岩溶
岩盐
岩石
岭南
岳州
岳母
岳飞
岷江
岸边
峡口
峡江
峡谷
峨眉山
峭壁
峰值
峰峦
峰峰
峻岭
崇山峻岭
崇拜
崇敬
崇明
崇祯
崇高
崖壁
崛起
崩塌
崩溃
崩裂
崩解
崭新
崽子
嵩县
巍峨
巍巍
川军
川汉铁路
川江
川流不息
巡回
巡回医疗
巡抚
巡按使
巡捕
巡查
巡检
巡洋舰
巡游
巡航
巡行
巡视
巡警
巡逻
巢穴
巢脾
工业
工业中心
工业体系
工业化
工业原料
工业品
工业国
工业基地
工业大学
工业战线
工业无产阶级
工业电视
工业部
工业部门
工业革命
工事
工人
工人日报
工人运动
工人阶级
工件
工会
工伤
工作
工作上
工作制度
工作地
工作日
工作服
工作者
工作面
工党
工兵
工具
工具书
工具钢
工农
工农业
工农业总产值
工农兵
工农红军
工农联盟
工况
工分
工匠
工区
工厂
工友
工商业
工商界
工商联
工地
工场
工场手工业
工夫
工头
工字钢
工宣队
工序
工效
工整
工日
工时
工期
工本
工段
工矿企业
工种
工科
工程
工程兵
工程塑料
工程师
工程设计
工程项目
工艺
工艺品
工艺性能
工艺流程
工艺程序
工艺美术
工蜂
工读
工质
工贼
工资
工资劳动
工资总额
工资附加费
工运
工部
工钱
工长
工龄
左倾
左右
左右手
左手
左派
左翼
左耳
左转
左边
左近
左面
巧克力
巧取豪夺
巧合
巧妙
巧干
巧立名目
巨人
巨变
巨型
巨大
巨头
巨幅
巨著
巨额
巩县
巩固
巫婆
巫山
巫峡
差不多
差不多的
差事
差人
差价
差使
差别
差动
差异
差役
差数
差点儿
差等
差距
差速器
差错
差额
己二酸
己任
已婚
已往
已故
已极
已然
已知数
已经
已而
巴不得
巴勒斯坦
巴基斯坦
巴尔干
巴尼
巴山
巴巴
巴库
巴拿马
巴拿马运河
巴掌
巴林
巴格达
巴比伦
巴比特
巴结
巴西
巴西利亚
巴赫
巴里
巴顿
巴马科
巴黎
巴黎公社
巷口
巷战
巷道
币值
币制
市上
市中心
市亩
市价
市侩
市内
市分
市区
市场
市场价格
市委
市尺
市政
市斤
市民
市电
市立
市郊
市里
市镇
市集
市面
布依族
布加勒斯特
布匹
布告
布头
布宜诺斯艾利斯
布尔乔亚
布尔什维克
布局
布帛
布拉柴维尔
布拉格
布景
布朗
布朗运动
布梏
布满
布特
布线
布置
布衣
布谷鸟
布达佩斯
布达拉宫
布防
布阵
布隆迪
布雷
布面
布鲁塞尔
布鲁诺
帆布
帆船
师傅
师兄
师团
师弟
师徒
师徒合同
师母
师爷
师生
师范
师范学校
师说
师资
师长
希图
希尔
希尔伯特
希望
希望
希法亭
希特勒
希罕
希腊
希腊人
帐子
帐户
帐房
帐款
帐目
帐簿
帕尔
帘子
帘子线
帝俄
帝制
帝国
帝国主义
帝国主义分子
帝王
帝王将相
带下
带分数
带动
带头
带子
带方
带来
带电
带病
带路
带钢
带锯
带领
带鱼
帧频
席位
席勒
席卷
席地
席子
帮凶
帮办
帮助
帮工
帮忙
帮手
帮派
帮腔
帷幕
常人
常任
常会
常务
常压塔
常备军
常委
常州
常常
常年
常德
常态
常情
常数
常有
常温
常用对数
常绿阔叶林
常见
常见于
常规
常规武器
常言
常言道
常识
常量
常青
常驻
帽子
幅员
幅宽
幅度
幌子
幕后
幕府
干了
干事
干什么
干冰
干净
干制
干劲
干吗
干将
干尸
干巴巴
干干净净
干性油
干戈
干扰
干掉
干支
干旱
干时
干杯
干枯
干校
干活
干流
干涉
干涉现象
干涸
干渠
干燥
干燥器
干燥机
干燥箱
干球温度
干电池
干瘪
干笑
干粉
干粮
干线
干群关系
干脆
干草粉
干菜
干裂
干贝
干路
干部
干酪
干酵母
干预
干馏
平一
平仄
平价
平凉
平凡
平分
平动
平反
平台
平和
平地
平均
平均主义
平均值
平均分子量
平均利润
平均利润率
平均地权
平均工资
平均数
平均气温
平均速度
平坦
平壤
平头
平安
平定
平峒
平川
平巷
平常
平平
平平加
平度
平庸
平息
平房
平整
平整土地
平方
平方公里
平方根
平方米
平日
平时
平板
平板仪
平板车
平正
平民
平淡
平滑
平炉
平生
平移
平稳
平等
平粜
平素
平纹
平绒
平缓
平行
平行作业
平行六面体
平行四边形
平行四边形法则
平行线
平衡
平衡常数
平衡木
平装
平西
平视
平角
平话
平调
平谷
平车
平野
平阳
平静
平面
平面几何
平面图
平面角
平面镜
平顶
平顶山
平顺
年下
年事
年产量
年代
年份
年会
年光
年关
年刊
年初
年利
年华
年历
年号
年头儿
年富力强
年少
年岁
年年
年底
年度
年成
年所
年时
年景
年来
年根
年画
年级
年纪
年终
年表
年谱
年轮
年轻
年轻人
年迈
年长
年间
年限
年青
年龄
年龄特征
并不
并不是
并且
并举
并入
并列
并力
并发
并合
并吞
并当
并排
并条
并没有
并立
并联
并肩
并肩作战
并行
并论
并进
并重
并驾齐驱
幸亏
幸免
幸好
幸福
幸而
幸运
幻想
幻灭
幻灯
幻觉
幼体
幼儿
幼小
幼年
幼林
幼根
幼稚
幼芽
幼苗
幼虫
幼龄林
幽州
幽幽
幽明
幽暗
幽深
幽灵
幽静
幽默
广东
广义
广元
广南
广博
广告
广场
广大
广大群众
广安
广宗
广川
广州
广度
广播
广播体操
广播电台
广汉
广泛
广西
广阔
广陵
庄严
庄员
庄周
庄园
庄子
庄户
庄田
庄稼
庄稼人
庄里
庄重
庆元
庆典
庆幸
庆祝
庆贺
庇护
床位
床单
床头
床铺
序列
序幕
序数
序文
序时帐
序曲
序言
庐山
庐州
庐江
库仑
库仑定律
库存
库容
库尔斯克
库尔曼
库房
应付
应允
应制
应力
应变
应否
应和
应声
应对
应当
应征
应得
应急
应战
应承
应收
应时
应有
应有尽有
应用
应用技术
应用科学
应考
应试
应该
应运
应邀
应酬
应验
底下
底子
底层
底座
底数
底本
底架
底柱
底止
底漆
底片
底盘
底细
底肥
底色
底角
底质
底边
底里
店员
店家
店铺
庙会
庙堂
庙宇
庚子
府上
府兵制
府城
府库
府绸
庞大
庞杂
废品
废品率
废墟
废寝忘食
废弃
废弃物
废料
废止
废液
废渣
废物
废纸
废话
废醣蜜
废除
度数
度日
度过
度量
度量衡
座位
座谈
庭园
庭长
庭院
庶人
庶务
庶民
康乐
康庄大道
康德
康有为
康熙
康采恩
庸人
庸俗
庸俗化
庸俗进化论
廉价
廉洁
廉耻
廊坊
延伸
延安
延展性
延年
延期
延河
延续
延缓
延误
延迟
延长
廷尉
建业
建中
建交
建元
建党
建军
建制
建和
建国
建国大纲
建宁
建安
建州
建康
建成
建树
建武
建瓯
建立
建筑
建筑业
建筑工业
建筑工地
建筑工程
建筑机械
建筑材料
建筑材料工业
建筑物
建筑结构
建筑艺术
建筑设计
建筑面积
建议
建设
建设单位
建设性
建造
建都
开业
开会
开元
开关
开凿
开刀
开列
开创
开办
开动
开化
开发
开口
开国
开场
开垦
开城
开外
开头
开契
开始
开学
开导
开封
开小差
开局
开展
开展工作
开山
开工
开市
开幕
开幕式
开幕词
开平
开庭
开张
开征
开心
开战
开户
开拓
开掘
开支
开放
开放电路
开方
开明
开春
开朗
开枪
开棉机
开水
开火
开炮
开玩笑
开球
开皇
开盘
开眼
开矿
开票
开端
开缺
开罗
开脱
开船
开花
开花期
开花结果
开荒
开设
开诚布公
开课
开赴
开足马力
开路
开车
开辟
开远
开通
开采
开销
开门
开门办学
开门见山
开间
开阔
开除
开饭
异乡
异化
异化作用
异口同声
异同
异味
异国
异地
异型
异己
异常
异彩
异性
异想天开
异文
异族
异日
异构体
异构化
异样
异步
异步电动机
异物
异端
异类
异议
弃权
弄坏
弄清
弄虚作假
弄通
弄错
弊病
弊端
式子
弓子
弓形
弓背
引人
引人入胜
引人注目
引入
引出
引力
引发
引子
引导
引得
引文
引桥
引水
引流
引渡
引潮力
引理
引用
引申
引种
引线
引言
引证
引诱
引起
引路
引进
引述
弗兰格尔
弘农
弟兄
弟妹
弟子
弟弟
张之洞
张伟
张伯伦
张作霖
张先
张力
张勋
张华
张口
张嘴
张大
张宗禹
张宝
张家口
张德成
张敬尧
张望
张浩
张照
张献忠
张百祥
张目
张秀眉
张继
张网
张罗
张衡
张角
张说
张贴
张遇贤
张顺
张骞
弥勒
弥漫
弥补
弦乐器
弦切角
弧光灯
弧度
弧形
弧菌
弯头
弯度
弯弯曲曲
弯曲
弯矩
弯路
弱国
弱小
弱点
弱电
弱碱
弱者
弱酸
弹力
弹力丝
弹劾
弹压
弹头
弹奏
弹性
弹性体
弹琴
弹簧
弹簧秤
弹簧钢
弹药
弹跳
弹道
强作
强使
强健
强制
强加
强加于
强加于人
强化
强占
强固
强国
强壮
强大
强奸
强度
强度极限
强弱
强悍
强拍
强暴
强有力
强权
强求
强渡
强烈
强电
强盗
强盛
强硬
强碱
强者
强行
强调
强迫
强酸
强风
归于
归侨
归公
归功
归化
归咎
归国
归宿
归属
归并
归根到底
归根结蒂
归案
归类
归纳
归纳法
归结
归罪于
归路
归还
归队
归附
归顺
当下
当世
当中
当事人
当事国
当今
当代
当令
当众
当做
当儿
当先
当兵
当初
当前
当务之急
当即
当地
当场
当天
当头
当官
当家
当家作主
当家的
当局
当差
当年
当当
当心
当政
当日
当时
当晚
当月
当权
当权派
当然
当真
当空
当选
当道
当量
当量浓度
当铺
当阳
当面
录像机
录取
录用
录音
录音室
录音机
彝族
形似
形体
形制
形势
形变
形容
形式
形式上
形式主义
形式逻辑
形形色色
形态
形态学
形成
形成层
形数
形状
形相
形而上学
形象
形象化
形象思维
彩云
彩礼
彩绘
彩色
彩色片
彩色电视
彩虹
彩陶
彩霞
彩饰
彭城
彭德怀
彰德
影像
影响
影子
影射
影戏
影片
影调
影象
役使
役畜
彻夜
彻头彻尾
彻底
彻底清除
彼岸
彼得
彼得一世
彼得格勒
彼此
往事
往后
往复
往复泵
往常
往年
往往
往日
往来
往返
征伐
征兆
征兵
征兵制
征发
征战
征收
征服
征求
征用
征税
征询
征调
征象
征购
征途
征集
径向
径流
径直
径自
径赛
待会
待制
待命
待摊费用
待遇
徇私
很大程度上
很早以前
很难说
律令
律例
律历志
律吕
律师
律诗
徐世昌
徐寿辉
徐州
徐徐
徐福
徐锡麒
徒刑
徒劳
徒工
徒弟
徒手
徒步
徒然
徒长
徒长枝
得不偿失
得了
得以
得体
得出
得分
得到
得力
得势
得天独厚
得失
得奖
得安
得当
得心应手
得悉
得意
得意洋洋
得手
得救
得数
得气
得法
得用
得病
得益
得知
得罪
得胜
得色
得过且过
得逞
御史大夫
御寒
御用
循序
循序渐进
循环
循环小数
循环气
循环系统
徭役
微不足道
微分
微分方程
微分电路
微型
微型机
微妙
微安
微小
微带
微弱
微微
微微的
微波
微生
微生物学
微积分
微笑
微米
微粒
微细
微薄
微观
微观世界
微观粒子
微言
微调
微量
微量元素
微风
德兴
德国
德州
德意志
德智体
德治
德育
德行
德黑兰
心不在焉
心中
心中有数
心事
心内膜
心切
心力
心动
心包
心口
心土
心地
心坎
心境
心声
心头
心学
心安理得
心室
心平气和
心底
心得
心怀
心思
心急
心性
心情
心想
心意
心愿
心慌
心慌意乱
心房
心服
心术
心机
心满意足
心潮
心灵
心爱
心理
心理学
心疼
心目
心眼儿
心神
心绪
心耳
心肌
心肌炎
心肝
心肠
心胸
心脏
心腹
心虚
心血
心裁
心跳
心轴
心连心
心酸
心里
心里话
必不可少
必修
必修课
必定
必将
必得
必然
必然性
必然王国
必由之路
必胜
必要
必要劳动
必要性
必需
必需品
必须
必须的
忆苦思甜
忌讳
忍不住
忍受
忍心
忍无可忍
忍痛
忍耐
忍让
志同道合
志向
志士
志愿
志愿军
志气
志留纪
志趣
忘却
忘形
忘怀
忘情
忘我
忘掉
忘本
忘记
忙乱
忙于
忙碌
忠义
忠于
忠信
忠厚
忠告
忠孝
忠实
忠实的
忠心
忠心耿耿
忠臣
忠诚
忠贞
忧伤
忧心忡忡
忧患
忧愁
忧愤
忧虑
忧郁
快中子
快乐
快事
快干
快快
快意
快感
快慢
快报
快攻
快板
快步
快活
快艇
快要
快车
快速
快门
快马
念书
念头
念念
念念不忘
念经
忽地
忽忽
忽然
忽略
忽而
忽视
忿忿
怀仁堂
怀古
怀孕
怀德
怀念
怀恨
怀抱
怀柔
怀疑
怀疑论
态度
怅然
怎么
怎么样
怎么着
怎生
怒吼
怒放
怒斥
怒气
怒涛
怒潮
怒火
怒目
怔怔
怕人
怕死
怜悯
思弓
思忖
思念
思恩
思想
思想上
思想体系
思想内容
思想准备
思想家
思想性
思想感情
思想战线
思想方法
思潮
思盖
思索
思绪
思维
思考
思虑
思路
思量
怠工
急于
急促
急先锋
急切
急剧
急变
急忙
急性
急性子
急救
急流
急用
急电
急行军
急起直追
急躁
急进
急迫
急速
急遽
急需
性交
性别
性命
性子
性急
性情
性格
性欲
性气
性激素
性病
性相
性能
性腺
性行
性质
怨声载道
怨恨
怨愤
怨气
怨言
怪不得
怪事
怪物
怪话
怯懦
怯生生
总之
总书记
总产值
总产量
总人口
总体
总值
总共
总兵
总分类帐户
总分类核算
总则
总办
总务
总动员
总参谋部
总参谋长
总司令
总合
总后勤部
总吨
总和
总商
总图
总局
总工会
总帐
总归
总得
总成
总括
总指挥
总揽
总攻
总政
总政治部
总教习
总数
总方针
总星系
总是
总汇
总理
总的说来
总监
总目
总督
总算
总管
总结
总结经验
总统
总统制
总罢工
总而言之
总能
总裁
总计
总谱
总路线
总部
总长
总预算
总领事
总额
恋爱
恍惚
恍然
恍然大悟
恐吓
恐怕
恐怖
恐惧
恐慌
恒定
恒温
恒等
恒等式
恒量
恢复
恣意
恨不得
恨透
恩人
恩克鲁玛
恩典
恩情
恩惠
恩格斯
恩爱
恩赐
恪守
恫吓
恬静
恭喜
恭恭敬敬
恭敬
恭维
恭顺
恰到好处
恰好
恰如
恰如其分
恰巧
恰当
恰恰
恰恰相反
恳切
恳求
恶习
恶人
恶劣
恶化
恶心
恶性
恶性循环
恶意
恶感
恶果
恶梦
恶棍
恶毒
恶狠狠
恶臭
恶霸
恶霸地主
恶魔
恼怒
恼火
悄悄
悄悄的
悉心
悍然
悔恨
悔改
悟性
悠久
悠悠
悠扬
悠然
悠长
悠闲
患者
患难
悦目
悦耳
悬垂
悬崖
悬挂
悬殊
悬浊液
悬浮
悬浮液
悬空
悬臂
悲伤
悲剧
悲哀
悲壮
悲惨
悲愤
悲歌
悲痛
悲苦
悲观
悼念
悼词
情不自禁
情书
情事
情人
情况
情势
情境
情形
情怀
情意
情感
情愿
情操
情景
情欲
情歌
情爱
情状
情理
情绪
情节
情调
情谊
情趣
情面
惊人
惊动
惊叹
惊吓
惊喜
惊天动地
惊奇
惊异
惊心动魄
惊恐
惊恐万状
惊惶
惊惶失措
惊愕
惊慌
惊涛骇浪
惊疑
惊蜇
惊讶
惊诧
惊醒
惊险
惊骇
惋惜
惘然
惟恐
惟有
惠州
惠施
惠更斯
惠灵顿
惠阳
惦念
惦记
惧怕
惨叫
惨案
惨死
惨淡
惨状
惨痛
惨白
惨败
惨遭
惨重
惩办
惩处
惩治
惩罚
惭愧
惯例
惯性
惯性力
惯性定律
惯犯
惯用
惰性
想不通
想像
想头
想得到
想念
想方设法
想望
想来
想法
想见
想象
想象力
想起
惶恐
惶惑
惶惶
愁眉苦脸
愁苦
愈加
愈合
愈好
愉快
意义
意向
意味
意味着
意图
意境
意外
意大利
意志
意思
意想
意愿
意料
意旨
意气
意气风发
意见
意识
意识到
意识形态
意象
愕然
愚人
愚公移山
愚弄
愚弟
愚昧
愚昧无知
愚民
愚蠢
感人
感伤
感光
感光度
感光片
感光纸
感冒
感到
感动
感化
感受
感受器
感受性
感召
感叹
感官
感应
感应电流
感性
感性认识
感情
感想
感慨
感抗
感染
感染率
感激
感生
感生电流
感知
感觉
感觉到
感觉器官
感觉神经
感触
感谢
愣住
愤怒
愤恨
愤愤
愤愤不平
愤慨
愤懑
愤激
愤然
愿意
愿望
慈善
慈悲
慈母
慈爱
慈祥
慌乱
慌张
慌张张
慌忙
慎到
慎重
慕容
慕尼黑
慢化剂
慢吞吞
慢性
慢性病
慢慢
慢条斯理
慧远
慨叹
慨然
慰劳
慰问
慷慨
慷慨激昂
憋气
憎恨
憎恶
憧憬
憨厚
懂事
懂得
懊丧
懊恼
懊悔
懒得
懒惰
懒散
懒汉
懒洋洋
懦夫
懦弱
戈兰高地
戈壁
戊戌变法
戊戌政变
戋戋
戎马
戏剧
戏台
戏弄
戏曲
戏法
戏班
戏院
成为
成事
成交
成亲
成人
成体
成例
成倍
成兆才
成全
成分
成功
成化
成千上万
成千成万
成单
成吉思汗
成名
成品
成因
成型
成堆
成天
成套
成套设备
成家
成就
成年
成年人
成心
成批
成效
成数
成文
成文法
成方
成本
成本核算
成本计算
成材
成果
成活
成活率
成灾
成熟
成熟林
成立
成约
成绩
成群
成色
成药
成虫
成衣
成见
成规
成语
成说
成象
成败
成都
成长
成问题
成风
我们
我党
我军
我国
我方
我的
我辈
戒严
戒备
戒律
戒心
戒指
戒骄戒躁
或体
或多或少
或是
或者
或许
战书
战乱
战争
战争与和平
战争状态
战事
战俘
战前
战功
战区
战友
战后
战国
战国时代
战国策
战地
战场
战壕
战士
战备
战天斗地
战局
战役
战报
战斗
战斗力
战斗员
战斗机
战斗英雄
战无不胜
战时
战术
战果
战栗
战歌
战死
战火
战略
战祸
战线
战胜
战舰
战费
战车
战马
战鼓
戚继光
截击
截断
截止
截止频率
截然
截然不同
截留
截至
截面
戳穿
戴维
戴高乐
户主
户口
户头
户籍
户调
户部
房东
房产
房子
房屋
房山
房捐
房租
房间
房顶
所以
所以然
所向披靡
所在
所属
所得
所得税
所有
所有制
所有权
所生
所由
所罗门
所至
所谓
所部
所长
扁圆
扁平
扁担
扁豆
扁鹊
扇子
扇风机
手下
手书
手倒立
手册
手写
手制动
手势
手印
手卷
手头
手套
手工
手工业
手工业者
手巾
手帕
手心
手忙脚乱
手感
手扶拖拉机
手指
手指头
手掌
手推车
手无寸铁
手札
手术
手杖
手板
手枪
手柄
手榴弹
手段
手法
手球
手电筒
手稿
手笔
手紧
手绢
手续
手背
手脚
手腕
手艺
手表
手足
手轮
手轻
手边
手铐
手风琴
才具
才分
才华
才子
才干
才是
才智
才有
扎伊尔
扎实
扎扎实实
扎根
扑克
扑打
扑灭
扑通
扑鼻
扒开
打下
打中
打主意
打乱
打交道
打仗
打倒
打光
打入
打击
打击报复
打动
打劫
打包
打印
打印机
打发
打听
打响
打场
打坏
打天下
打头
打头阵
打字
打字机
打官司
打底
打开
打成一片
打手
打扫
打扮
打扰
打拍子
打招呼
打捞
打掉
打搅
打散
打断
打更
打杈
打枪
打架
打桩
打棍子
打气
打浆
打浆机
打消
打游击
打滑
打滚
打炮
打点
打猎
打球
打眼
打瞌睡
打破
打砸抢
打碎
打磨
打算
打算盘
打紧
打纬
打结
打翻
打胜仗
打落
打落水狗
打败
打趣
打转
打进
打退
打通
打量
打针
打铁
打雷
打靶
打顶
打鬼
打鼓
扔下
扔掉
托儿所
托尔斯泰
托拉斯
托架
托洛茨基
托盘
托维
托运
托马
托马斯
扣子
扣帽子
扣押
扣留
扣除
扦插
执事
执勤
执掌
执政
执政党
执法
执笔
执行
扩充
扩军
扩军备战
扩大
扩大会议
扩大再生产
扩大化
扩孔
扩展
扩建
扩张
扩散
扩编
扩音器
扩音机
扫兴
扫地
扫射
扫帚
扫描
扫盲
扫荡
扫选
扫除
扫雷
扬威
扬子
扬州
扬弃
扬眉吐气
扬程
扬花
扬言
扭亏增盈
扭力
扭榘
扭矩
扭秧歌
扭结
扭转
扮演
扰乱
扰动
扳子
扳手
扳道
扶养
扶手
扶梯
扶犁
扶老携幼
批准
批判
批判地
批发
批复
批改
批斗
批示
批评和自我批评
批评家
批量
批量生产
批驳
扼守
扼杀
扼流圈
扼要
找事
找寻
找平
承保
承办
承包
承受
承天
承平
承德
承担
承接
承继
承袭
承认
承认错误
承诺
承载
承运
承运人
承重
技工
技巧
技巧运动
技师
技术
技术员
技术性
技术指导
技术水平
技术装备
技术革命
技术革新
技法
技能
技艺
抄写
抄家
抄录
抄本
抄袭
抉择
把儿
把兄弟
把关
把头
把子
把守
把家
把式
把戏
把手
把握
把柄
把这两
把酒
把门
把集
把风
抑制
抑制作用
抑制剂
抑或
抑止
抒发
抒情
抒情诗
抓岩机
抓斗
抓点
抓紧
抓纲治国
抓走
抓革命促生产
投产
投入
投奔
投射
投弹
投影
投影面
投掷
投放
投敌
投机
投机倒把
投梭
投票
投稿
投篮
投考
投药
投诚
投资
投身
投递
投降
投降主义
投靠
抖动
抗争
抗体
抗击
抗力
抗压强度
抗原
抗坏血酸
抗大
抗张强度
抗御
抗性
抗战
抗拉强度
抗拒
抗日战争
抗旱
抗暴
抗洪
抗热
抗病
抗病品种
抗税
抗菌素
抗衡
抗议
抗诉
抗逆性
抗震
折中
折价
折光
折半
折叠
折合
折回
折射
折射率
折扣
折旧
折旧基金
折磨
折算
折线
折腾
折衷
抚养
抚恤
抚慰
抚摩
抚摸
抚育
抚顺
抛光
抛弃
抛掷
抛物线
抛锚
抢修
抢先
抢劫
抢占
抢墒
抢夺
抢掠
抢收
抢救
抢种
抢购
抢险
护兵
护卫
护卫舰
护国军
护国运动
护士
护林
护林防火
护法
护照
护理
护航
护送
报仇
报信
报刊
报到
报名
报告
报喜
报国
报复
报废
报界
报社
报章
报答
报纸
报考
报表
报警
报请
报道
报酬
报销
报馆
抨击
披露
抬头
抬高
抱怨
抱朴
抱歉
抱着
抱负
抵债
抵偿
抵制
抵御
抵抗
抵押
抵挡
抵消
抵罪
抵补
抵触
抵赖
抵达
抵销
抹杀
抹煞
押运
押送
押韵
抽动
抽头
抽屉
抽打
抽提
抽搐
抽查
抽样
抽水
抽水机
抽汽
抽泣
抽税
抽穗
抽穗期
抽空
抽签
抽象
抽象劳动
抽象思维
抽象概念
担任
担保
担子
担当
担心
担忧
担架
担负
拆卸
拆开
拆散
拆毁
拆洗
拆除
拇指
拈度
拉丁字母
拉丁文
拉丁美洲
拉丝
拉伸
拉倒
拉关系
拉制
拉力
拉各斯
拉多
拉夫
拉奥孔
拉屎
拉巴
拉巴斯
拉巴特
拉幅
拉平
拉开
拉德
拉手
拉扯
拉拢
拉杆
拉瓦锡
拉管
拉萨
拉萨尔
拉车
拉长
拌种
拍卖
拍号
拍子
拍手
拍手称快
拍打
拍摄
拍照
拍频
拐子
拐弯
拐杖
拐棍
拒绝
拓扑
拓跋
拓跋氏
拓跋焘
拓跋贵
拔染
拔节
拖带
拖延
拖拉
拖拉机
拖拉机手
拖拉机站
拖欠
拖泥带水
拖累
拖网
拖船
拖车
拖鞋
拘役
拘束
拘泥
拘留
拘禁
拘谨
拙劣
拙著
招募
招呼
招展
招待
招待会
招待所
招徕
招手
招抚
招摇撞骗
招收
招架
招牌
招生
招考
招致
招降
招集
拜上帝会
拜会
拜年
拜托
拜见
拜访
拟定
拟订
拟议
拥兵
拥军优属
拥戴
拥护
拥抱
拥挤
拥政爱民
拥有
拦住
拦截
拦河坝
拦网
拦腰
拦阻
拨乱反正
拨付
拨子
拨款
择伐
择捉
括号
括弧
拯救
拱卫
拱形
拱手
拱桥
拳击
拳头
拷打
拼凑
拼命
拼音
拼音文字
拾掇
拾遗
拿大
拿手
持久
持久战
持家
持平
持枪
持球
持续
挂号
挂名
挂图
挂帅
挂彩
挂念
挂车
挂钩
挂面
指令
指使
指出
指南
指南针
指名
指向
指头
指定
指导
指导员
指导思想
指引
指战员
指挥
指挥员
指挥部
指控
指摘
指教
指数
指数函数
指斥
指日
指明
指望
指标
指标体系
指正
指法
指派
指点
指物
指甲
指示
指示剂
指示器
指示灯
指纹
指责
指针
按兵不动
按劳分配
按压
按捺
按摩
按时
按期
按次
按比例发展
按照
按理
按规定
按计划
按语
按说
按钮
按需分配
挎包
挑剔
挑动
挑子
挑战
挑拨
挑拨离间
挑衅
挑起
挑选
挖出
挖土机
挖掘
挖掘机
挖泥船
挖空心思
挖苦
挖补
挟持
挠度
挠曲
挡板
挡车
挡风
挣扎
挣脱
挣钱
挤兑
挤压
挤满
挥动
挥发
挥发油
挥发物
挥戈
挥手
挥舞
挥霍
挪动
挪威
挪用
挫伤
挫折
挫败
振作
振兴
振兴实业
振动
振动筛
振奋
振幅
振德
振武学社
振荡
振荡器
挺拔
挺秀
挺立
挺身
挺身而出
挺进
挽回
挽手
挽救
挽留
捆绑
捉住
捉弄
捉拿
捉摸
捍卫
捎带
捏造
捐助
捐款
捐献
捐税
捕捉
捕捞
捕获
捕食
捕鲸
捕鲸船
捞取
损人利己
损伤
损坏
损失
损害
损害赔偿
损益
损耗
换人
换取
换句话说
换向
换向器
换工
换文
换气
换热器
换班
换算
换羽
换茬
换言之
捣乱
捣毁
捣碎
捣蛋
捣鬼
捧场
据传
据悉
据此
据点
据说
捱到
捱打
捱着
捱近
捱饿
捷克
捷克斯洛伐克
捷径
捷报
捻军
捻度
掀动
掀开
掀起
授予
授奖
授意
授权
授粉
授精
授课
掉头
掉换
掉转
掉队
掌声
掌心
掌握
掌故
掌权
掌柜
掌管
掏槽
排列
排印
排卵
排场
排外
排山倒海
排戏
排挤
排斥
排架
排气
排水
排水沟
排水管
排水系统
排水量
排泄
排泄物
排涝
排演
排灌
排球
排练
排解
排长
排队
排除
排除万难
排骨
掖县
掘进
掠取
掠夺
掠过
探亲
探伤
探听
探头
探明
探明储量
探望
探求
探测
探照灯
探矿
探究
探索
探视
探讨
探访
探问
探险
接二连三
接任
接力
接力棒
接受
接合
接合面
接地
接壤
接头
接应
接待
接手
接收
接替
接洽
接济
接班
接班人
接生
接着
接种
接穗
接管
接纳
接线
接续
接羔
接见
接触
接触器
接触应力
接触法
接踵
接近
接连
接通
控制
控制台
控制室
控制棒
控告
控诉
推举
推事
推倒
推动
推卸
推土机
推导
推崇
推广
推广先进经验
推想
推戴
推托
推挽
推敲
推斥
推断
推杆
推求
推测
推理
推磨
推移
推究
推算
推翻
推脱
推荐
推行
推论
推辞
推进
推进器
推迟
推选
推重
推铅球
推销
推陈出新
掩体
掩埋
掩护
掩映
掩盖
掩蔽
掩饰
措手不及
措施
措置
掳掠
掷标枪
掷铁饼
揉捻
揉搓
描写
描画
描绘
描述
提交
提价
提供
提倡
提出
提制
提前
提包
提升
提单
提取
提名
提审
提心吊胆
提成
提拔
提携
提早
提案
提法
提炼
提琴
提督
提示
提纯
提纯复壮
提纲
提花
提要
提议
提调
提货
提醒
提问
提高
提高警惕
插入
插口
插嘴
插嚅
插图
插头
插座
插手
插曲
插条
插秧
插秧机
插话
插足
插销
插队
插页
握住
握手
握紧
揣摩
揭发
揭幕
揭开
揭批
揭晓
揭破
揭示
揭穿
揭竿而起
揭露
援军
援助
援引
援救
援用
搀扶
搁浅
搁置
搅乱
搅动
搅拌器
搅拌机
搏斗
搜刮
搜寻
搜括
搜捕
搜查
搜求
搜索
搜罗
搜集
搞好
搪瓷
搬家
搬用
搬运
搭成
搭拉
搭救
搭讪
搭配
携带
携手
摄制
摄取
摄影
摄影艺术
摄政王
摄食
摆动
摆布
摆弄
摆渡
摆线
摆脱
摆设
摇动
摇头
摇手
摇把
摇摆
摇摇
摇摇欲坠
摇晃
摇曳
摇杆
摇篮
摇臂
摇荡
摇身一变
摇车
摊子
摊派
摔倒
摔跤
摘引
摘录
摘心
摘要
摘译
摘除
摧残
摧毁
摩加迪沙
摩尔
摩托
摩托车
摩擦
摩擦力
摩擦系数
摩擦阻力
摩洛哥
摸底
摸索
摹仿
摹拟
撇嘴
撇开
撑竿跳
撑腰
撑臂
撒娇
撒开
撒手
撒拉族
撒播
撒施
撒腿
撒谎
撕毁
撕破
撕裂
撞击
撤兵
撤回
撤换
撤消
撤离
撤职
撤走
撤退
撤销
撤除
播幅
播种
播种期
播种机
播种面积
播送
播音
撰文
擅自
擅长
操作
操作台
操作系统
操作规程
操劳
操场
操心
操纵
操纵台
操纵性
操练
擦亮
擦伤
擦破
攀援
攀登
攀缘
攫取
支书
支付
支农
支出
支工
支左
支座
支护
支持
支撑
支支吾吾
支数
支杆
支架
支柱
支气管
支流
支渠
支点
支票
支离
支离破碎
支线
支部
支配
支队
收买
收件人
收入
收养
收割
收割机
收发
收发室
收取
收口
收听
收回
收场
收复
收容
收尘
收工
收录
收成
收拢
收拾
收支
收效
收敛
收方
收率
收益
收看
收税
收紧
收编
收缩
收缴
收罗
收获
收藏
收蚁
收货人
收购
收费
收针
收集
收音
收音机
改任
改元
改写
改制
改动
改变
改口
改善
改土
改天
改天换地
改头换面
改嫁
改建
改性
改悔
改换
改朝换代
改正
改组
改编
改良
改良主义
改良品种
改装
改观
改订
改过
改进
改选
改造
改道
改革
攻下
攻克
攻关
攻击
攻占
攻取
攻守
攻打
攻破
攻读
攻陷
放下
放任
放债
放假
放养
放养密度
放出
放哨
放在眼里
放声
放大
放大器
放大率
放大系数
放大镜
放学
放宽
放射
放射性
放射性元素
放射性同位素
放射病
放射线
放屁
放弃
放心
放慢
放手
放散
放映
放松
放款
放毒
放水
放火
放炮
放热
放热反应
放牧
放生
放电
放空
放纵
放置
放肆
放荡
放过
放逐
放风
政事
政事堂
政令
政体
政党
政务
政务院
政协
政变
政和
政委
政客
政局
政府
政敌
政权
政权机关
政治
政治协商会议
政治委员
政治家
政治权利
政治民主
政治犯
政治经济学
政治课
政治避难
政治部
政法
政界
政策
政纲
政见
政论家
政闻社
故乡
故书
故事
故人
故吏
故国
故土
故地
故实
故宫
故居
故常
故意
故我
故旧
故此
故知
故而
故障
效力
效劳
效应
效应器
效忠
效果
效法
效率
效用
效益
效能
敌人
敌伪
敌军
敌国
敌对
敌情
敌意
敌我矛盾
敌手
敌特
敌百虫
敌视
敏感
敏感性
敏捷
敏锐
救亡
救助
救命
救国
救护
救护车
救援
救星
救治
救活
救济
救火
救灾
教主
教义
教习
教书
教会
教具
教养
教务
教化
教员
教唆
教堂
教士
教学
教学大纲
教学法
教学计划
教官
教室
教导
教导员
教师
教徒
教授
教本
教材
教条
教条主义
教案
教民
教皇
教研室
教研组
教科书
教程
教练
教练机
教职员
教育
教育制度
教育学
教育方针
教育经济学
教育行政
教训
敞口
敞开
敢做
敢情
敢想
敢死队
散乱
散会
散发
散场
散失
散射
散居
散布
散开
散心
散播
散文
散步
散漫
散热器
散落
散装
敦促
敦煌
敬之
敬仰
敬佩
敬意
敬爱
敬畏
敬礼
敬酒
敬重
数九
数位
数值
数列
数字
数字通信
数学
数学分析
数学模型
数据
数控
数来宝
数目
数目字
数码
数落
数论
数轴
数量
数量级
数额
敲击
敲打
敲诈勒索
整个
整体
整修
整党
整地
整天
整套
整式
整形
整数
整整
整整齐齐
整枝
整治
整洁
整流
整流器
整流子
整流管
整理
整编
整队
整除
整顿
整风
整齐
敷衍
敷设
文义
文书
文人
文件
文体
文具
文凭
文则
文化
文化大革命
文化宫
文化水平
文化程度
文句
文告
文娱
文字
文学
文学史
文学家
文官
文弱
文摘
文教
文昌
文明
文本
文武
文殊
文法
文火
文物
文献
文王
文理
文盲
文章
文笔
文艺
文艺复兴
文言
文豪
文选
文雅
文集
文静
文革
文风
斑斑
斑点
斑白
斑纹
斗争
斗争形式
斗争性
斗争意志
斗争方式
斗倒
斗子
斗志
斗志昂扬
斗批改
斗私批修
斗笠
斗门
料到
料器
料子
料想
料斗
料理
料车
料酒
料量
斜井
斜坡
斜射
斜度
斜桥
斜率
斜眼
斜纹
斜线
斜视
斜角
斜轧
斜边
斜阳
斜面
斟酌
斡旋
斤两
斤斤
斥之为
斥力
斥责
斧头
斧子
斩钉截铁
斩首
断口
断头
断头率
断奶
断定
断层
断开
断後
断断
断断续续
断案
断气
断然
断狱
断电
断章取义
断线
断绝
断裂
断裂强度
断言
断路
断送
断面
斯坦
斯坦福
斯大林
斯宾塞
斯宾诺莎
斯德哥尔摩
斯托
斯文
斯特恩
斯特朗
斯通
斯里兰卡
斯隆
新东
新中国
新丰
新乡
新书
新产品
新人
新人新事
新会
新光
新兴
新兴力量运动会
新兵
新军
新加坡
新化
新华社
新发
新古典主义
新名词
新四军
新地
新型
新城
新天
新奇
新妇
新娘
新婚
新学
新安
新安江
新宾
新居
新市
新年
新建
新开
新异
新式
新德里
新房
新手
新技术
新政
新教
新文化运动
新文字
新文学
新时期的总任务
新春
新月
新村
新殖民主义
新民
新民主主义
新民主主义革命
新沙
新津
新生
新生事物
新生儿
新生力量
新疆
新石器时代
新纪元
新经
新罗
新胜利
新装
新西兰
新词
新诗
新贵
新近
新进
新道
新郎
新都
新闻
新闻公报
新闻纸
新闻记者
新陈代谢
新青
新颖
新鲜
方中
方书
方人
方伯
方位
方位角
方便
方向
方向盘
方圆
方士
方子
方家
方差
方式
方形
方才
方根
方格
方框
方框图
方案
方桌
方正
方法
方法论
方略
方相
方程
方程式
方程组
方腊
方解石
方言
方针
方铅矿
方面
施公案
施加
施加压力
施密特
施展
施工
施放
施政
施琅
施用
施肥
施舍
施行
旁人
旁听
旁心
旁白
旁观
旁证
旁路
旁边
旁通
旅大
旅客
旅客列车
旅居
旅店
旅游
旅游业
旅社
旅行
旅行袋
旅费
旅途
旅长
旅顺
旅馆
旋宫
旋律
旋涡
旋转
旋转起重机
旋转轴
旋钮
旋风
旌旗
族人
族权
族类
旗人
旗号
旗子
旗帜
旗手
旗杆
旗袍
无上
无不
无中生有
无为
无产阶级
无产阶级专政
无产阶级民主
无产阶级革命
无人
无人驾驶飞机
无从
无他
无任
无休止
无何
无余
无偿
无关
无几
无前
无力
无功功率
无动于衷
无原则
无双
无可
无可争辩
无可奈何
无名
无名指
无味
无国籍
无声
无奈
无如
无妨
无定形碳
无害
无家可归
无对
无常
无干
无度
无庸
无异
无形
无影无踪
无待
无心
无性
无性杂交
无怪
无恶不作
无情
无意
无意识
无愧
无成
无我
无所谓
无政府状态
无故
无效
无敌
无数
无日
无时无刻
无明
无暇
无望
无期徒刑
无机
无机盐
无机肥料
无权
无条件
无条件反射
无条件投降
无极
无梁楼盖
无止境
无毒
无比
无水
无法
无济于事
无烟煤
无物
无理
无理方程
无用
无由
无畏
无疑
无益
无知
无私
无稽
无穷
无穷无尽
无端
无线电
无线电台
无线电定位
无线电广播
无线电报
无线电接收机
无线电波
无线电电子学
无线电话
无线电通信
无终
无缘无故
无缝钢管
无缺
无罪
无耻
无聊
无能
无能为力
无色
无行
无补
无规
无视
无记名投票
无论
无论如何
无误
无谓
无赖
无轨电车
无辜
无边
无边无际
无量
无间
无阻
无际
无限
无限制
无限大
无需
无霜期
无非
无须
既定
既得利益
既成事实
既是
既然
既然如此
既而
日下
日中
日久
日产量
日俄战争
日元
日光
日光灯
日全食
日内
日内瓦
日内瓦协议
日出
日刊
日前
日华
日南
日历
日后
日夜
日头
日子
日工
日常
日新
日新月异
日日夜夜
日晒牢度
日月
日期
日本
日本人
日本海
日来
日渐
日照
日用
日用品
日益
日益加剧
日益增长
日知会
日程
日落
日表
日记
日趋
日间
日食
旦夕
旧中国
旧书
旧事
旧制
旧历
旧唯物主义
旧国
旧地
旧址
旧学
旧居
旧教
旧日
旧时
旧时代
旧民主主义革命
旧物
旧生
旧观
旧诗
旧金山
旧闻
旨意
早上
早先
早已
早年
早操
早日
早春
早晚
早晨
早期
早点
早熟
早秋
早稻
早衰
早起
早霜
早餐
早饭
旬刊
旬日
旱地
旱季
旱情
旱涝保收
旱灾
旱烟
旱田
时下
时不时
时中
时事
时人
时代
时会
时候
时值
时光
时兴
时分
时刻
时务
时势
时尚
时局
时常
时报
时政
时效
时方
时日
时时
时时刻刻
时期
时机
时气
时水
时点
时而
时节
时行
时装
时见
时辰
时运
时针
时钟
时间
时间常数
时间性
时间继电器
时限
时食
时髦
旷野
旺季
旺盛
昂扬
昂贵
昂首
昆仑
昆明
昆曲
昆虫
昆虫学
昆阳
昌平
昌言
昌都
明了
明亮
明人
明令
明儿
明净
明天
明太祖
明夷待访录
明媚
明年
明律
明德
明快
明政
明文
明日
明早
明时
明明
明星
明显
明晃晃
明晰
明智
明暗
明朗
明末农民起义
明沟
明治维新
明灯
明珠
明目张胆
明知
明矾
明确
明细帐
明胶
明证
明说
明道
明镜
昏庸
昏暗
昏沉
昏迷
昏黄
易与
易位
易懂
易燃物
易经
昔日
昔阳
昙花
星体
星光
星夜
星座
星斗
星星
星星之火
星期
星期日
星火
星球
星罗棋布
映射
映照
映象
春上
春光
春兰
春分
春化阶段
春天
春季
春小麦
春意
春播
春汛
春秋
春笋
春耕
春联
春节
春花
春雷
春风
春麦
昨儿
昨夜
昨天
昨晚
昭雪
是否
是的
是非
昼夜
显学
显影
显影剂
显得
显微镜
显性
显明
显然
显现
显眼
显示
显而易见
显著
显见
显象管
显贵
显赫
显露
晃动
晃晃
晃荡
晋书
晋升
晋武帝
晋阳
晌午
晒垡
晒干
晒烟
晒种
晓得
晕倒
晚上
晚会
晚年
晚报
晚期
晚点
晚熟
晚秋
晚稻
晚近
晚间
晚霜
晚霞
晚饭
晦暗
晨光
晨报
晨曦
晨风
普列汉诺夫
普及
普尔
普希金
普朗克
普查
普照
普特
普罗列塔利亚
普罗提诺
普选
普通
普通小麦
普通法
普通话
普遍
普遍真理
普遍裁军
普遍规律
景况
景山
景德镇
景深
景物
景致
景色
景观
景象
晴天
晴朗
晴空
晶体
晶体三极管
晶体二极管
晶体振荡器
晶体管
晶体结构
晶内偏析
晶形
晶核
晶格
晶粒
晶莹
晶轴
智利
智力
智取
智慧
智者
智育
智能
晾干
暂且
暂停
暂时
暂缓
暂行
暑假
暑期
暖和
暖气
暖洋洋
暖流
暖种
暗中
暗号
暗地里
暗室
暗害
暗暗
暗杀
暗流
暗淡
暗电流
暗礁
暗示
暗笑
暗管
暗线
暗自
暗藏
暧昧
暮色
暴乱
暴利
暴力
暴力革命
暴动
暴发
暴发户
暴君
暴徒
暴政
暴涨
暴烈
暴虐
暴行
暴躁
暴雨
暴露
暴风
暴风雨
曙光
曝光
曝晒
曲子
曲式
曲折
曲柄
曲水
曲牌
曲率
曲笛
曲线
曲线图
曲线运动
曲艺
曲菌
曲解
曲调
曲谱
曲轴
曲阜
曲阳
曲霉
曲面
更上一层楼
更其
更其
更加
更动
更名
更夫
更始
更张
更换
更改
更新
更新改造资金
更替
更正
更生
曹丕
曹参
曹操
曹汝霖
曹爽
曹福田
曹锟
曹雪芹
曹魏
曼延
曼梏
曾国藩
曾孙
曾经
替人
替代
替换
最为
最低
最低气温
最佳
最先
最初
最后
最大
最大平飞速度
最大限度
最好
最最
最终
最终传动
最近
最高
最高人民法院
最高国务会议
最高峰
最高气温
最高级
月中
月亮
月份
月光
月出
月分
月刊
月初
月台
月夜
月季花
月工
月底
月报
月末
月牙
月球
月琴
月终
月色
月食
月龄
有一套
有丝分裂
有为
有事
有些
有产者
有产阶级
有价证券
有余
有光
有关
有利
有利可图
有力
有功
有功功率
有劲
有劳
有司
有名
有名无实
有喜
有声有色
有失
有如
有客
有害
有家
有年
有底
有形
有待
有得
有德
有心
有心人
有志气
有性
有性生殖
有恃无恐
有情
有意
有意思
有意识
有成
有所
有效
有效值
有效功率
有效性
有效数字
有效期
有效氯
有效面积
有数
有方
有旧
有时
有朝一日
有期徒刑
有机
有机体
有机化合物
有机化学
有机合成
有机玻璃
有机肥料
有机质
有条不紊
有没有
有源
有点
有理
有理方程
有生力量
有用
有用功
有的
有的放矢
有的是
有益
有着
有碍
有种
有线
有线广播
有色
有色人种
有色金属
有计划
有识
有请
有谓
有赖
有趣
有身
有道
有钱
有错
有间
有限
有限公司
有零
有鬼
朋友
服从
服从于
服侍
服务
服务业
服务于
服务员
服务态度
服务站
服务行业
服务质量
服役
服毒
服气
服用
服装
服饰
朗朗
朗格
朗诵
朗读
望望
望远
望远镜
朝代
朝向
朝夕
朝宗
朝廷
朝拜
朝政
朝气
朝气蓬勃
朝着
朝见
朝贡
朝野
朝阳
朝霞
朝鲜
朝鲜族
期刊
期待
期日
期望
期满
期票
期间
期限
朦胧
木人
木偶
木兰
木刻
木匠
木器
木头
木屋
木工
木排
木料
木本
木本植物
木材
木材干馏
木林
木柴
木棍
木樨
木炭
木炭画
木版
木石
木笼
木筏
木结构
木耳
木船
木薯
木质素
木质部
木马
木麻黄
未便
未免
未决
未可
未始
未婚
未婚妻
未定
未尝
未成年
未曾
未来
未然
未知
未知数
未经
未能
未遂
末世
末了
末叶
末尾
末年
末日
末期
本世纪
本业
本主
本事
本人
本位
本位主义
本体
本儿
本分
本利
本原
本国
本土
本地
本垒
本子
本家
本届
本州
本年
本年度
本心
本性
本意
本文
本月
本期发生额
本末
本本
本机振荡
本机振荡器
本来
本来的
本来面目
本源
本溪
本生
本相
本着
本票
本科
本纪
本职
本能
本色
本草
本草纲目
本行
本论
本质
本质属性
本身
本部
本钱
本队
本领
本题
札记
术数
术语
朱丽叶
朱元璋
朱先
朱子
朱尔典
朱明
朱温
朱熹
朱瑞
朱砂
朱红
朴实
朴素
朴素唯物主义
机井
机件
机会
机会主义
机体
机修厂
机关
机关刊物
机关报
机关枪
机具
机制
机务段
机动
机动性
机器
机器人
机场
机型
机子
机密
机工
机床
机座
机敏
机智
机构
机枪
机械
机械化
机械唯物主义
机械工程
机械性能
机械效率
机械油
机械能
机械论
机械运动
机油
机灵
机电
机组
机绣
机翼
机耕
机能
机舱
机要
机警
机身
机车
杀人
杀人犯
杀伤
杀头
杀害
杀死
杀气腾腾
杀菌
杀菌作用
杀菌剂
杀虫剂
杀陆
杀青
杂乱
杂乱无章
杂交
杂交亲本
杂交种
杂交育种
杂剧
杂品
杂居
杂志
杂感
杂技
杂技团
杂文
杂物
杂种
杂种优势
杂种后代
杂粮
杂肥
杂色
杂草
杂记
杂说
杂货
杂质
杂费
杂音
杂食性
权利
权利能力
权力
权势
权威
权数
权时
权术
权益
权能
权臣
权衡
权要
权贵
权限
杆子
杆状
杆秤
杆菌
李世民
李卜克内西
李嘉图
李大钊
李子
李家
李密
李富春
李岩
李德
李悝
李文学
李文成
李斯
李时珍
李村
李渊
李煜
李玉
李白
李秀成
李纲
李耳
李自成
李贽
李闯王
李顺
李香君
李鸿章
杏仁
杏花村
材料
材种
材积
材积表
村子
村庄
村落
村镇
村长
杜勒斯
杜家
杜绝
杜鲁门
杜鹃
束手无策
束缚
杠子
杠杆
杠铃
条件
条件刺激
条件反射
条例
条子
条干
条形
条播
条支
条文
条案
条款
条理
条目
条纹
条钢
条陈
来不及
来世
来临
来之不易
来书
来人
来体
来信
来函
来到
来势
来历
来回
来复
来安
来客
来宾
来年
来归
来往
来得
来得及
来意
来日
来照
来犯
来生
来由
来电
来者
来自
来访
来路
来过
来龙去脉
杨嗣昌
杨坚
杨子
杨幺
杨广
杨文
杨朱
杨柳
杨树
杨梅
杨氏
杨秀清
杨虎城
杭州
杯子
杰作
杰出
松动
松劲
松土
松开
松弛
松快
松懈
松手
松散
松木
松林
松树
松毛虫
松江
松涛
松科
松紧
松节油
松花江
松赞干布
松软
松香
板凳
板子
板式
板材
板极
板栗
板牙
板结
板胡
极为
极其
极力
极化
极右
极地
极大
极小
极左
极度
极性
极性键
极板
极点
极盛
极目
极移
极端
极间电容
极限
构件
构图
构型
构思
构成
构筑
构筑物
构造
枇枇
枉法
析出
析木
枕头
枕木
枕资
枕骨
林下
林业
林业部
林冠
林分
林分改造
林区
林卡
林县
林地
林场
林子
林学
林带
林木
林木分化
林海
林爽文
林相
林祥谦
林立
林虑山
林钟
林龄
果仁
果品
果园
果子
果实
果敢
果断
果木
果枝
果柄
果树
果汁
果然
果皮
果真
果穗
果糖
果肉
果胶
果蝇
果酒
果酱
枝叶
枝头
枝子
枝干
枝条
枝节
枝角类
枢密使
枢密院
枢纽
枢轴
枣庄
枣树
枣红
枪决
枪口
枪声
枪弹
枪托
枪支
枪杀
枪杆
枪杆子
枪械
枪毙
枪炮
枪炮声
枫香
枯干
枯木
枯水
枯水期
枯燥
枯竭
枯草杆菌
枯萎
枯黄
架势
架子
架式
架空
架设
枷锁
柏拉图
柏木
柏林
柏树
柏油
某些
某人
某某
某甲
柑橘
染整
染料
染病
染缸
染色
染色体
染色牢度
染色质
柔和
柔嫩
柔软
柔韧
柔顺
柜上
柜台
柜子
柠柠
柠檬
查办
查勘
查对
查封
查明
查清
查田运动
查看
查禁
查究
查考
查获
查证
查问
查阅
柬埔寨
柱头
柱子
柱状晶
柱石
柳宗元
柳州
柳敬亭
柳杉
柳条
柳枝
柳树
柳琴
柴油
柴油机
柴火
柴米
柴草
柿子
栅极
栅栏
标兵
标准
标准化
标准大气压
标准工资
标准差
标准时
标准木
标准溶液
标准状况
标准状态
标准规
标号
标定
标尺
标志
标明
标本
标杆
标枪
标榜
标灯
标点
标的
标签
标统
标语
标量
标题
标高
栋梁
栏杆
树丛
树冠
树园
树干
树木
树林
树枝
树梢
树液
树皮
树种
树立
树胶
树脂
树苗
栓塞
栖息
栗子
校友
校园
校外
校对
校正
校舍
校长
校风
栩栩如生
株距
株连
株选
样品
样子
样式
样本
样机
样样
核仁
核准
核力
核动力
核反应
核反应堆
核外电子
核子
核定
核实
核对
核心
核战争
核桃
核武器
核潜艇
核燃料
核爆炸
核算
核糖
核糖核酸
核膜
核苷酸
核蛋白
核裂变
核试验
核酸
核黄素
根儿
根冠
根号
根基
根子
根尖
根底
根式
根拔
根指数
根据
根据地
根本
根本性
根本法
根本矛盾
根毛
根治
根深蒂固
根瘤
根瘤菌
根竹
根系
根绝
根苗
根茎
根除
根音
格外
格子
格式
格律
格杀勿论
格林
格格
格格不入
格物
格言
格里
栽培
栽植
栽种
桁架
桂冠
桂林
桂皮
桂花
桃仁
桃子
桃李
桃树
桃江
桃源
桃红
桃花
桅杆
框图
框子
框架
框框
案件
案卷
案子
案情
桉树
桌子
桌面
桎桎
桐油
桑叶
桑园
桑树
桑田
桑给巴尔
桑蚕
桑蚕丝
桓温
桓玄
桔红
档案
桥台
桥墩
桥头
桥式起重机
桥梁
桦林
梁书
梁启超
梁山
梁山伯
梁武帝
梅子
梅村
梅林
梅毒
梅花
梅雨
梆子
梏地
梗概
梗死
梢头
梦境
梦寐以求
梦幻
梦想
梦溪笔谈
梦见
梧州
梧桐
梨园
梨树
梭子
梭鱼
梯也尔
梯子
梯度
梯形
梯田
梯级
梳头
梳妆
梳子
梳棉机
梳理
检举
检修
检定
检察
检录
检查
检波
检波器
检点
检疫
检视
检讨
检阅
检验
棉卷
棉布
棉条
棉毛衫
棉田
棉籽
棉絮
棉纤维
棉纱
棉纺
棉纺厂
棉线
棉织品
棉花
棉蚜
棉衣
棉袄
棉被
棉裤
棉铃
棉铃虫
棋子
棋盘
棍子
棍棒
棒子
棒球
棕壤
棕榈
棕色
棘手
棘爪
棘轮
棚子
森严
森林
森林土壤
森林工业
森林抚育采伐
森林更新
森林经理
森林资源
森林资源清查
棱台
棱柱
棱角
棱锥
棱镜
棺木
棺材
椅子
植保
植株
植物
植物体
植物保护
植物区系
植物学
植物油
植物群落
植苗
植被
椎骨
椭球
椰子
楔子
楚辞
楞住
楞次定律
楠木
楷模
楼下
楼台
楼房
楼板
楼梯
楼盖
楼船
楼阁
楼面
楼顶
概况
概念
概念化
概括
概率
概略
概算
概要
概论
概说
概述
榆树
榔头
榨取
榨油
榨菜
榴弹
槐树下
槟榔
槽子
槽钢
樊崇
樟树
樟脑
模仿
模具
模压
模块
模型
模式
模拟器
模拟计算机
模数
模样
模模糊糊
模特儿
模糊
模范
模锻
横切
横切面
横加
横坐标
横山
横幅
横征暴敛
横扫
横断面
横暴
横梁
横波
横流
横渡
横生
横直
横竖
横线
横蛮
横行
横行霸道
横财
横贯
横跨
横轴
樱桃
樱花
橄榄
橄榄石
橘子
橙黄
橡皮
橡胶
橡胶树
橱窗
檀香山
檄文
檩条
欠款
欠缺
欠身
次之
次于
次品
次子
次序
次数
次日
次比
次氯酸
次生
次生林
次第
次等
次级线圈
次要
次长
欢乐
欢呼
欢喜
欢声
欢声雷动
欢度
欢心
欢快
欢欣
欢欣鼓舞
欢畅
欢笑
欢聚
欢腾
欢迎
欢迎
欢送
欣喜
欣慰
欣欣向荣
欣然
欣赏
欧几里得
欧化
欧姆
欧姆定律
欧文
欧洲
欧洲共同体
欧洲经济共同体
欧阳
欲得
欲念
欲望
欺世盗名
欺侮
欺凌
欺压
欺诈
欺负
欺骗
款子
款待
款项
歇息
歉收
歌剧
歌咏
歌唱
歌喉
歌声
歌女
歌德
歌手
歌曲
歌舞
歌词
歌谣
歌颂
止住
止境
止步
正三角形
正中
正义
正义战争
正事
正交
正像
正光
正切
正割
正午
正南
正厅
正反
正号
正名
正在
正多边形
正多面体
正大
正好
正如
正始
正字
正定
正巧
正常
正式
正弦
正弦定理
正弦曲线
正弦波
正弦规
正当
正待
正德
正投影
正数
正文
正方
正方体
正方形
正时
正是
正月
正极
正比
正比例
正气
正治
正法
正派
正火
正点
正片
正电
正电子
正电荷
正盐
正直
正确
正确性
正离子
正经
正统
正色
正规
正规军
正视
正负
正路
正轨
正门
正面
正面人物
此事
此刻
此君
此地
此处
此外
此後
此时
此起彼伏
此间
步伐
步兵
步军统领
步子
步履
步枪
步步
步法
步行
步调
步足
步道
步骤
武人
武关
武则天
武力
武功
武卫
武器
武士
武备
武备学堂
武官
武德
武斗
武断
武昌
武昌起义
武术
武松
武汉
武汉市
武艺
武装
武装侵略
武装力量
武装斗争
武装部队
武进
武陵
歧视
歪斜
歪曲
歪风
歪风邪气
歹徒
死不
死亡
死亡率
死伤
死党
死刑
死力
死命
死地
死守
死尸
死心
死战
死敌
死板
死死
死活
死点
死罪
死胡同
死角
死路
死难
歼击机
歼灭
歼灭战
殉节
殉难
殊不知
殊死
残存
残害
残局
残废
残忍
残暴
残杀
残炭
残留
残破
残缺
残部
残酷
残骸
殖民
殖民主义
殖民地
殡葬
殴打
段祺瑞
段落
殷切
殷勤
殷墟
殿下
毁坏
毁损
毁灭
毁誉
毅力
毅然
毋庸
母亲
母体
母后
母子
母本
母树
母树林
母株
母液
母爱
母猪
母系
母线
母羊
母蜂
母音
每个
每人
每回
每天
每年
每当
每次
每每
每逢
毒化
毒品
毒害
毒性
毒手
毒打
毒杀
毒死
毒气
毒物
毒瘤
毒素
毒草
毒药
毒菌
毒蛇
毒计
毒辣
毒饵
比不上
比价
比例
比例中项
比例失调
比例尺
比例规
比值
比分
比利
比利时
比喻
比如
比容
比对
比尔
比干
比年
比拟
比方
比来
比比
比比皆是
比热
比照
比率
比目鱼
比绍
比色计
比表面
比试
比赛
比较
比较仪
比重
比附
比高
毕业
毕业生
毕升
毕生
毕竟
毕达哥拉斯
毗连
毗邻
毛主席
毛刺
毛发
毛坯
毛子
毛巾
毛条
毛毛
毛毡
毛毯
毛泽东
毛泽东思想
毛病
毛皮
毛竹
毛笔
毛纺
毛线
毛细管
毛织品
毛茶
毛虫
毛衣
毛装
毛诗
毛里塔尼亚
毛霉
毛驴
毡帽
毫不
毫伏
毫克
毫升
毫安
毫巴
毫微米
毫无
毫无疑义
毫无疑问
毫秒
毫米
毫米波
毯子
氏族
民不聊生
民主
民主党派
民主国
民主改革
民主政治
民主集中制
民主革命
民事
民众
民兵
民力
民办
民变
民和
民团
民国
民国日报
民夫
民工
民心
民情
民意
民愤
民房
民报
民政
民族
民族主义
民族利益
民族化
民族区域自治
民族压迫
民族团结
民族学院
民族平等
民族文化
民族民主革命
民族矛盾
民族统一战线
民族自治
民族英雄
民族解放运动
民族资产阶级
民族资本
民族问题
民族革命
民智
民权
民权主义
民校
民歌
民气
民法
民生
民生主义
民用
民用建筑
民田
民穷财尽
民脂民膏
民航
民警
民谣
民选
民间
民间文学
民间艺术
气体
气体燃料
气候
气冲冲
气冷
气力
气力输送
气动
气动力
气势
气势汹汹
气化
气压
气口
气味
气呼呼
气喘
气囊
气垫船
气孔
气孔率
气密
气态
气性
气息
气恼
气愤
气机
气概
气氛
气泡
气泡病
气派
气流
气温
气焰
气球
气田
气筒
气缸
气色
气节
气象
气象卫星
气象台
气象学
气象火箭
气象要素
气质
气量
气门
气阀
气馁
气魄
氘核
氟化氢
氟化物
氟化钙
氢化
氢化物
氢弹
氢气
氢氟酸
氢氧化物
氢氧化钙
氢氧化钠
氢氧化钾
氢氧化铝
氢氰酸
氢键
氧化
氧化亚铜
氧化剂
氧化氮
氧化汞
氧化物
氧化酶
氧化钙
氧化钡
氧化铁
氧化铅
氧化铜
氧化铝
氧化铬
氧化锌
氧化镁
氧气
氧气瓶
氨化
氨基
氨基塑料
氨基酸
氨水
氮化
氮气
氮源
氮肥
氯丁橡胶
氯乙烯
氯仿
氯化
氯化亚锡
氯化氢
氯化氰
氯化物
氯化苦
氯化钙
氯化钠
氯化钾
氯化铁
氯化铝
氯化铵
氯化锌
氯化镁
氯气
氯纶
氯苯
氯酸
氯酸钾
氰化
氰化法
氰化钾
氰酸
水乡
水井
水产
水仙
水位
水体
水兵
水军
水冷
水准
水准仪
水准器
水准测量
水分
水利
水利化
水利工程
水力
水力发电
水化
水压
水压机
水压试验
水口
水合
水合物
水土
水土保持
水土流失
水坑
水坝
水垢
水域
水塔
水塘
水壶
水处理
水头
水密
水封
水尺
水工
水师
水平
水平仪
水平线
水平面
水库
水库养鱼
水底
水彩
水彩画
水性
水患
水情
水战
水手
水扬
水文
水文地质条件
水族
水旱轮作
水星
水晶
水曲柳
水月
水杉
水果
水桶
水母
水池
水汽
水沟
水泄不通
水泡
水泥
水泥厂
水洗
水流
水浇地
水浮莲
水浴
水深火热
水淹
水渠
水溶液
水滴
水火
水火不相容
水灰比
水灾
水烟
水煤气
水牛
水玻璃
水生动物
水生植物
水田
水电
水电站
水碱
水磨
水磨石
水稻
水管
水箱
水系
水线
水经
水肥
水肿
水能
水色
水花
水草
水落
水蒸气
水螅
水表
水解
水质
水路
水车
水轮发电机
水轮机
水轮泵
水运
水选
水道
水部
水闸
水雷
水青冈
水面舰艇
永世
永久
永久中立国
永久性
永乐
永兴
永别
永动机
永和
永嘉
永垂不朽
永宁
永安
永定
永定河
永平
永年
永恒
永新
永昌
永清
永生
永磁
永胜
永远的
汀州
汁液
求人
求全
求助于
求和
求婚
求学
求实
求情
求成
求援
求救
求教
求根
求生
求知
求证
汇合
汇总
汇款
汇水
汇流
汇率
汇票
汇编
汇编语言
汇集
汉中
汉书
汉人
汉口
汉城
汉堡
汉奸
汉子
汉字
汉学
汉川
汉弗莱
汉律
汉族
汉武帝
汉民
汉江
汉献帝
汉语
汉阳
汗水
汛期
汝南
江东
江北
江华
江南
江夏
江宁
江山
江岸
江州
江心
江汉
江湖
江米
江苏
江西
江都
江阴
江陵
池塘
池子
池沼
池盐
池鱼
污吏
污垢
污染
污水
污泥
污浊
污秽
污蔑
污辱
汤化龙
汤团
汤圆
汤寿潜
汤锅
汪士铎
汪汪
汪洋
汪洋大海
汪精卫
汲取
汴京
汹汹
汹涌
汽包
汽化
汽化器
汽水
汽油
汽油机
汽笛
汽缸
汽船
汽车
汽轮发电机
汽轮机
汽锅
汽锤
汾酒
汾阳
沃顿
沈括
沈约
沈阳
沉吟
沉寂
沉思
沉沉
沉没
沉沦
沉浸
沉淀
沉淀法
沉甸甸
沉痛
沉着
沉睡
沉积
沉积物
沉醉
沉重
沉闷
沉降
沉降缝
沉降速度
沉静
沉默
沐浴
沙丘
沙俄
沙包
沙发
沙哑
沙土
沙场
沙坑
沙子
沙尔
沙巴
沙市
沙拉
沙文主义
沙沙
沙河
沙洲
沙滩
沙漠
沙特阿拉伯
沙田
沙皇
沙石
沙粒
沙荒
沙袋
沙锅
沙门
沟壑
沟施
沟渠
沟通
没事儿
没什么
没入
没关系
没出息
没收
没有
没有过
没法子
没落
沥青
沦为
沦陷
沧州
沧海
沮丧
河东
河内
河北
河北省
河南
河口
河堤
河外星系
河套
河山
河岸
河川
河工
河床
河梏
河沟
河沿
河泥
河流
河渠
河滩
河畔
河网
河网化
河蟹
河西
河道
河里
河间
沸水
沸点
沸石
沸腾
沸腾床
沸腾钢
油井
油光
油印
油压
油坊
油墨
油层
油布
油性
油料
油料作物
油条
油松
油桐
油桶
油棕
油槽
油毡
油气
油水
油污
油泥
油泵
油滑
油漆
油灯
油灰
油田
油画
油矿
油管
油箱
油纸
油绿
油罐
油脂
油腻
油船
油茶
油菜
油藏
油轮
油酸
油锯
油门
油饼
治国
治学
治安
治家
治山
治平
治愈
治所
治水
治理
治疗
治病
治病救人
治罪
沼气
沼泽
沼泽地
沾染
沿岸
沿江
沿河
沿海
沿用
沿着
沿线
沿袭
沿路
沿途
沿革
泄殖腔
泄气
泄漏
泄露
泉州
泉水
泉源
泉眼
泊位
法人
法令
法儿
法兰
法兰克
法兰克福
法兰盘
法兰西共和国
法典
法则
法利
法制
法办
法医
法医学
法国
法子
法学
法官
法定
法宝
法家
法币
法师
法度
法庭
法律
法律行为
法律顾问
法拉
法拉第
法政
法权
法案
法治
法理
法纪
法线
法统
法西斯
法西斯主义
法规
法警
法郎
泛指
泛池
泛泛
泛滥
泛滥成灾
泛起
泛酸
泛非主义
泛音
泡桐
泡沫
泡沫塑料
泡菜
波兰
波动
波及
波哥大
波士顿
波多黎各
波导
波导管
波尔多液
波峰
波形
波恩
波折
波斯
波斯湾
波束
波段
波浪
波涛
波源
波澜
波澜壮阔
波特
波纹
波罗的海
波美
波谷
波长
波音
泥土
泥坑
泥塑
泥岩
泥工
泥巴
泥水
泥泞
泥浆
泥潭
泥炭
泥盆纪
泥鳅
注入
注册
注塑
注定
注射
注意
注水
注油
注消
注目
注脚
注视
注解
注释
注重
注音
注音字母
泪水
泪珠
泪痕
泪眼
泪花
泰勒
泰和
泰国
泰山
泰戈尔
泰晤士报
泰西
泰陵
泸州
泼冷水
泼辣
洁净
洁白
洄游
洋为中用
洋人
洋务
洋务派
洋务运动
洋奴哲学
洋布
洋房
洋槐
洋河
洋油
洋法生产
洋洋
洋流
洋溢
洋灰
洋芋
洋葱
洋行
洋货
洋车
洋钱
洋面
洋鬼子
洗刷
洗劫
洗手
洗涤
洗涤剂
洗澡
洗煤
洗礼
洗衣
洗衣机
洗衣粉
洗选
洛伊
洛克
洛克菲勒
洛兰
洛夫
洛杉矶
洛林
洛美
洛阳
洞口
洞子
洞察
洞房
洞穴
津巴布韦
津津有味
津贴
洪亮
洪仁柑
洪大
洪峰
洪承畴
洪武
洪水
洪泽湖
洪流
洪湖
洪秀全
洪都拉斯
洪门
活佛
活力
活动
活动于
活动家
活劳动
活化
活化剂
活化能
活命
活埋
活塞
活塞杆
活塞环
活字
活字印刷
活性
活性中心
活性染料
活性炭
活捉
活水
活泼
活活
活现
活生生
活结
活络
活荷载
活计
活该
活象
活路
活门
洼地
派出所
派别
派头
派性
派生
派系
派遣
流亡
流产
流人
流传
流体
流利
流动
流动资本
流化床
流域
流域面积
流失
流寇
流尽
流弊
流放
流散
流星
流毒
流民
流氓
流水
流水作业
流水线
流沙
流派
流浪
流畅
流离
流离失所
流程
流线
流线型
流网
流落
流血
流血牺牲
流行
流行于
流言
流言蜚语
流转
流通
流通手段
流通费用
流通领域
流速
流量
流露
浅浅
浅海
浅耕
浅色
浅薄
浆料
浆果
浆液
浆粕
浆糊
浆纱
浆膜
浇口
浇水
浇灌
浇筑
浇铸
测力计
测压管
测定
测树学
测站
测绘
测试
测距
测量
测验
济南
济宁
济贫
浏阳
浑厚
浑浊
浑然一体
浑身
浓厚
浓密
浓度
浓浓
浓淡
浓烈
浓眉
浓绿
浓缩
浓艳
浓郁
浓重
浙东
浙江
浙江省
浙西
浠水
浦口
浩劫
浩大
浩浩
浩浩荡荡
浩瀚
浩荡
浪头
浪涛
浪漫
浪漫主义
浪潮
浪花
浪费
浮云
浮力
浮动
浮夸
浮子
浮标
浮桥
浮沉
浮游
浮游动物
浮游植物
浮游生物
浮现
浮肿
浮萍
浮选
浮选机
浮雕
浴室
浴池
浴缸
浴血
浴血奋战
海上
海上花列传
海上运输
海事仲裁
海产
海关
海内
海军
海军基地
海军陆战队
海北
海区
海南
海南岛
海参
海口
海员
海味
海地
海域
海外
海岛
海岸
海岸线
海峡
海带
海平面
海底
海德
海战
海损
海棠
海水
海河
海波
海洋权
海流
海浪
海涅
海港
海湾
海滨
海滩
海潮
海燕
海牙
海王星
海疆
海盐
海盗
海盗行为
海相
海禁
海绵
海船
海藻
海蜇
海轮
海边
海运
海道
海里
海防
海阳
海面
海风
海马
海鸥
海龙
海龟
浸入
浸染
浸水
浸泡
浸润
浸渍
浸种
浸蚀
浸透
涂抹
涂改
涂料
消亡
消化
消化不良
消化系统
消失
消息
消散
消极
消毒
消沉
消灭
消瘦
消石灰
消磨
消耗
消耗热
消费
消费品
消费资料
消费量
消退
消逝
消遣
消长
消闲
消防
消除
涉及
涉外
涉讼
涌现
涝灾
涡流
涡轮喷气发动机
涡轮轴发动机
涣散
涤纶
润湿
润滑
润滑油
润滑脂
润色
涨价
涨落
涪陵
液体
液体燃料
液力
液力传动
液化
液压
液压机
液压油
液态
液态空气
液晶
液泡
涵义
涵养
涵洞
淀粉
淀粉酶
淋巴
淋巴细胞
淋巴结
淋洗
淋淋
淋漓
淋漓尽致
淘气
淘汰
淡化
淡季
淡水
淡水鱼
淡淡
淡淡的
淡然
淡薄
淡青
淫威
淬火
淮北
淮南
淮安
淮海
深井泵
深仇大恨
深信
深入
深入人心
深切
深刻
深化
深厚
深呼吸
深圳
深处
深夜
深奥
深山
深度
深思
深思熟虑
深恐
深情
深意
深水
深沉
深浅
深海
深深
深渊
深秋
深红
深绿
深翻
深耕
深造
深邃
深重
深长
淳化
淳朴
混为一谈
混乱
混交林
混作
混入
混养
混凝剂
混凝土
混合
混合器
混合物
混合结构
混同
混和
混响
混成
混战
混杂
混棉
混沌
混浊
混淆
混炼
混纺
混蛋
混进
混铁炉
混频器
淹没
添加剂
添置
清一色
清亮
清人
清偿
清净
清凉
清华
清华大学
清单
清史稿
清和
清塘
清官
清律
清心
清扫
清新
清早
清时
清明
清晨
清晰
清晰度
清查
清棉机
清楚
清水
清水墙
清江
清汤
清河
清油
清泉
清洁
清洗
清流
清淡
清清楚楚
清澈
清点
清爽
清理
清瘦
清白
清真寺
清秀
清算
清脆
清蒸
清谈
清道
清醒
清除
清静
清音
清风
清香
清高
渊博
渊源
渐变
渐次
渐渐
渐进
渔业
渔具
渔利
渔区
渔场
渔夫
渔捞
渔期
渔歌
渔民
渔汛
渔猎
渔网
渔船
渔获量
渔轮
渔霸
渗入
渗出
渗出物
渗水
渗流
渗漏
渗碳
渗透
渗透压
渗透性
渠水
渠道
渡口
渡船
渡过
渣子
渣油
渣滓
渤海
渤海湾
渥太华
温中
温习
温和
温存
温室
温州
温差
温带
温床
温度
温度场
温度梯度
温度计
温情
温暖
温柔
温标
温水
温泉
温良
温饱
港务局
港务监督
港口
港湾
港澳
渲染
渴望
游乐
游人
游击
游击战
游动
游历
游园
游客
游戏
游手好闲
游标卡尺
游民
游泳
游牧
游玩
游离
游艺
游荡
游行
游览
游记
游资
渺小
渺茫
湄公河
湍急
湍流
湖北
湖北省
湖南
湖南省
湖口
湖州
湖广
湖泊
湖滨
湘潭
湛江
湿地松
湿度
湿度计
湿气
湿润
湿漉漉
湿热
湿球温度
湿空气
湿透
溃散
溃疡
溃败
溃退
源泉
源流
源源
源远流长
溜井
溜子
溜走
溢出
溢洪道
溢流
溧阳
溪水
溪流
溴化物
溴化钾
溴化银
溴水
溴甲烷
溴酸
溶剂
溶化
溶合
溶洞
溶液
溶液聚合
溶胶
溶血
溶解
溶质
溺死
滋事
滋养
滋味
滋润
滋生
滋长
滑冰
滑动
滑动摩擦
滑动轴承
滑县
滑坡
滑板
滑润
滑环
滑石
滑移
滑稽
滑翔
滑行
滑车
滑轮
滑轮组
滑道
滑阀
滑雪
滑音
滔天
滔滔
滔滔不绝
滚动
滚动摩擦
滚动轴承
滚子
滚开
滚柱轴承
滚滚
滚烫
滚珠
滚珠轴承
滚筒
滚翻
滚蛋
滚轮
滚边
滚雪球
滞留
滞销
满不在乎
满口
满城
满天
满心
满怀
满怀信心
满意
满族
满江红
满洲
满洲国
满满
满满的
满目
满眼
满腔
满足
满身
满载
满面
滤器
滤池
滤波
滤波器
滤液
滤清
滤纸
滤色镜
滤过
滥伐
滥用
滥调
滦州
滨海
滴定
滴定管
滴水
滴滴涕
滴管
漂亮
漂流
漂浮
漂白粉
漂移
漆包线
漆器
漆黑
漏下
漏出
漏勺
漏斗
漏气
漏洞
漏电
漏税
漏网
漏风
演义
演习
演出
演剧
演化
演变
演唱
演奏
演戏
演示
演算
演讲
演说
演进
漕运
漠不关心
漠然
漠视
漩涡
漫不经心
漫天
漫步
漫漫
漫画
漫长
漫骂
漳河
潜伏
潜伏期
潜入
潜力
潜在
潜意识
潜水
潜水员
潜水艇
潜热
潜移默化
潜艇
潜逃
潭州
潮州
潮气
潮水
潮汐
潮流
潮湿
潮解
潺潺
潼关
澄江
澄清
澎湖列岛
澜沧江
澡堂
澧县
澳大利亚
澳洲
澳门
激光
激光器
激动
激励
激化
激发
激发态
激变
激增
激怒
激情
激愤
激战
激昂
激波
激活
激流
激烈
激磁
激素
激荡
激起
激越
激进
濒临
濒于
瀑布
灌区
灌县
灌木
灌水
灌注
灌浆
灌溉
灌溉工程
灌溉系统
灌溉面积
灌输
火上加油
火井
火候
火力
火力发电
火力发电厂
火势
火器
火墙
火头
火山
火把
火攻
火星
火柴
火气
火油
火海
火灾
火灾保险
火炉
火炕
火炬
火炬松
火炮
火烧
火热
火焰
火电站
火种
火箭
火箭发动机
火箭筒
火红
火线
火网
火腿
火舌
火花
火花塞
火花放电
火苗
火药
火车
火车头
火车站
火速
火龙
灭亡
灭火
灭火器
灭绝
灭菌
灯丝
灯光
灯塔
灯影
灯标
灯油
灯泡
灯火
灯笼
灯罩
灯黑
灰分
灰口铁
灰土
灰尘
灰心
灰心丧气
灰暗
灰浆
灰溜溜
灰烬
灰白
灰色
灰铸铁
灰雾
灵宝
灵山
灵巧
灵感
灵敏
灵敏度
灵机一动
灵武
灵活
灵渠
灵芝
灵通
灵验
灵魂
灶火
灶王爷
灼伤
灼热
灾区
灾害
灾情
灾民
灾祸
灾荒
灾难
灿烂
炉子
炉料
炉渣
炉温
炉火
炉灰
炉灶
炉管
炉膛
炉衬
炉门
炉顶
炊事
炊事员
炊烟
炎热
炎症
炒勺
炒青
炒面
炕头
炕桌
炕沿
炫耀
炭刷
炭化
炭火
炭疽病
炭窑
炮位
炮兵
炮击
炮制
炮口
炮台
炮声
炮弹
炮手
炮火
炮灰
炮眼
炮轰
炯炯
炸弹
炸药
点出
点发
点名
点头
点子
点定
点将
点心
点播
点数
点法
点滴
点火
点灯
点点
点燃
点电荷
点缀
点菜
点阵
点面结合
炼丹
炼乳
炼制
炼油
炼焦
炼钢
炼铁
炼铁炉
炽烈
炽热
烂泥
烈士
烈士陵园
烈女
烈属
烈性
烈日
烈火
烘干
烘干机
烘托
烘烤
烘焙
烘箱
烘青
烙印
烙铁
烛光
烟台
烟叶
烟囱
烟土
烟头
烟尘
烟幕
烟斗
烟火
烟灰
烟煤
烟碱
烟筒
烟花
烟草
烟袋
烟雾
烤火
烤烟
烦恼
烦扰
烦琐
烦躁
烦闷
烧伤
烧成
烧杯
烧毁
烧毛
烧火
烧瓶
烧碱
烧结
烧结焙烧
烧酒
烧锅
烧饼
烧香
烫伤
热中
热交换
热传导
热值
热切
热力
热力学
热力循环
热力过程
热功当量
热加工
热压
热和
热固性
热塑性
热处理
热天
热定型
热容量
热导率
热带
热带植物
热带雨林
热平衡
热度
热心
热忱
热情
热成层
热效应
热效率
热敏电阻
热望
热机
热核反应
热气
热气腾腾
热水
热水瓶
热泪
热流
热源
热潮
热火
热火朝天
热烈
热爱
热电
热电偶
热电厂
热病
热能
热膨胀
热血
热诚
热轧
热载体
热辐射
热辣辣
热运动
热那亚
热量
热闹
热障
热风
热风炉
烯烃
烷基
烷烃
烹调
烹饪
烽火
焊工
焊接
焊条
焊缝
焊锡
焕发
焕然一新
焙烧
焚书
焚毁
焚烧
焦作
焦化
焦急
焦比
焦油
焦灼
焦炉煤气
焦炭
焦点
焦煤
焦耳
焦虑
焦裕禄
焦距
焦达峰
焦黄
焰心
焰火
然则
然后
然而
煅烧
煎熬
煎饼
煞有介事
煤层
煤气
煤油
煤渣
煤火
煤炉
煤炭
煤炭工业
煤焦油
煤球
煤田
煤矿
煤窑
煤系
煤耗
照会
照例
照准
照办
照发
照射
照常
照应
照度
照抄
照搬
照料
照旧
照明
照样
照片
照相
照相机
照着
照管
照耀
照顾
煮沸
煮练
煮茧
煽动
煽惑
熄火
熄灭
熊克武
熊希龄
熊成基
熊掌
熊熊
熏蒸
熏陶
熔剂
熔化
熔池
熔炉
熔点
熔炼
熔焊
熔融
熔解
熟习
熟人
熟化
熟悉
熟料
熟知
熟练
熟读
熟铁
熨斗
燃料
燃料工业
燃料油
燃气轮机
燃气轮机车
燃点
燃烧
燃烧室
燃素说
燃起
燎原
燕京
燕子
燕山
燕燕
燕窝
燕麦
燧石
爆发
爆炸
爆炸声
爆破
爆竹
爆裂
爪子
爪牙
爬升
爬犁
爬行
爬行动物
爱上
爱人
爱因斯坦
爱国
爱国主义
爱国人士
爱国卫生运动
爱好
爱好者
爱尔兰
爱情
爱惜
爱慕
爱憎
爱戴
爱抚
爱护
爱民
爱迪生
爵位
爵士
父亲
父兄
父本
父权制
父母
父系
父老
爷们
爷儿
爷爷
爹爹
爽口
爽快
爽朗
片刻
片地
片子
片断
片时
片段
片面
片面性
版图
版本
版权
版画
版面
牌价
牌位
牌号
牌坊
牌子
牌楼
牙关
牙刷
牙粉
牙膏
牙齿
牛乳
牛奶
牛棚
牛毛
牛油
牛犊
牛皮
牛皮菜
牛粪
牛肉
牛舍
牛角
牛车
牛顿
牛马
牛鬼蛇神
牟取
牡丹
牡丹江
牢不可破
牢固
牢房
牢牢
牢狱
牢笼
牢记
牢靠
牢骚
牧业
牧人
牧区
牧场
牧工
牧师
牧民
牧畜
牧草
物主
物事
物产
物件
物价
物价指数
物体
物力
物化
物化劳动
物品
物态
物理
物理化学
物理变化
物理性质
物种
物色
物论
物证
物象
物质
物质力量
物质奖励
物质波
物质生产部门
物质财富
物资
物镜
牲口
牲畜
牵伸
牵制
牵动
牵引
牵引力
牵引发电机
牵引电动机
牵挂
牵涉
牵牛花
牵连
特为
特产
特使
特例
特写
特别是
特别法
特制
特务
特地
特大
特定
特工
特异
特征
特性
特意
特斯拉
特有
特权
特此
特殊
特殊化
特殊性
特派
特点
特种
特等
特约
特级
特色
特许
特质
特赦
特里
特长
牺牲
牺牲品
犀利
犀牛
犁地
犁田
犁铧
犊牛
犯上作乱
犯人
犯法
犯罪
犯规
状元
状况
状子
状态
状态参数
犹太人
犹太复国主义
犹如
犹疑
犹豫
犹豫不决
狂人
狂人日记
狂呼
狂喜
狂妄
狂暴
狂欢
狂热
狂笑
狂风
狂风暴雨
狍子
狐狸
狗咬
狗熊
狗腿子
狞笑
狠心
狠抓
狠毒
狠狠
狡猾
狡诈
狡辩
狩猎
独一无二
独创
独到
独占
独唱
独奏
独子
独幕剧
独揽
独断
独木桥
独木舟
独特
独独
独生子
独白
独立
独立国
独立性
独立核算
独立王国
独立自主
独自
独裁
独裁者
独身
独霸
狭义
狭小
狭窄
狭长
狭隘
狮子
狰狞
狱吏
狼狈
狼狈不堪
狼狈为奸
猎人
猎取
猎狗
猎获
猖狂
猖狂进攻
猖獗
猛兽
猛冲
猛增
猛子
猛扑
猛火
猛烈
猛然
猛虎
猜忌
猜想
猜测
猜疑
猩猩
猪倌
猪圈
猪场
猪头
猪油
猪皮
猪肉
猪蹄
献媚
献礼
献策
献给
献花
献计
献身
猴头
猴子
玄学
玄鸟
率部
率领
玉兰
玉兰片
玉器
玉女
玉林
玉树
玉溪
玉环
玉皇
玉石
玉米
玉米螟
玉米面
玉蜀黍
玉门
玉雕
王世充
王亚南
王人
王位
王侯
王充
王八
王公
王制
王匡
王台
王后
王国
王国维
王士珍
王夫之
王子
王安石
王官
王室
王宫
王导
王小波
王庄
王府
王思任
王恺
王成
王敦
王明
王昭君
王朝
王权
王杰
王水
王炳南
王爷
王猛
王畿
王维
王聪儿
王若飞
王莽
王道
王阳明
王韬
王麻子
玛丽
玩儿
玩具
玩弄
玩忽
玩意
玩物
玩笑
玩耍
玩艺
玫瑰
环中
环城
环境
环境保护
环境污染
环带
环形
环抱
环氧乙烷
环氧树脂
环流
环流器
环烷
环烷烃
环球
环绕
环节
环行
环视
环顾
现世
现今
现代
现代人
现代修正主义
现代农业
现代化
现代工业
现代戏
现代资本主义
现任
现在
现场
现存
现实
现实主义
现实性
现形
现役
现成
现时
现有
现款
现浇
现状
现蕾期
现行
现行犯
现象
现象学
现金
现金管理
现钱
现阶段
玲珑
玻利维亚
玻尔
玻璃
玻璃丝
玻璃体
玻璃杯
玻璃板
玻璃纤维
玻璃纸
玻璃钢
珊湖
珊瑚
珍品
珍奇
珍宝
珍惜
珍珠
珍藏
珍贵
珍重
珠儿
珠光体
珠子
珠宝
珠江
珠江三角洲
珠海
珠蚌
班主任
班吉
班固
班子
班机
班次
班珠尔
班禅
班禅额尔德尼
班级
班组
班车
班长
球体
球半径
球台
球场
球墨铸铁
球形
球心
球拍
球果
球状
球类运动
球网
球菌
球蛋白
球赛
球门
球队
球面
球面三角形
球面几何
球鞋
理事
理事会
理会
理化
理发
理学
理应
理当
理性
理性认识
理想
理所当然
理智
理由
理直气壮
理睬
理解
理解力
理论
理财
琉璃
琉璃厂
琐事
琐碎
琢磨
琦善
琴键
琴马
琼华
琼脂
瑞典
瑞利
瑞士
瑞澄
瑞金
瑰丽
瑶族
璞鼎查
瓜分
瓜子
瓜片
瓣膜
瓦尔
瓦岗军
瓦工
瓦房
瓦斯
瓦特
瓦盆
瓦砾
瓦罐
瓦罗
瓦解
瓶子
瓶装
瓷器
瓷土
甄别
甘地
甘宁
甘当
甘心
甘心情愿
甘愿
甘油
甘油酯
甘泉
甘结
甘肃
甘肃省
甘苦
甘草
甘蓝
甘蔗
甘薯
甘露
甘露醇
甚么
甚或
甚而
甚至
甚至于
甜味
甜头
甜瓜
甜美
甜菜
甜蜜
生丝
生事
生于
生产
生产关系
生产力
生产合作社
生产基金
生产大队
生产工具
生产操
生产斗争
生产方式
生产流程
生产率
生产线
生产能力
生产资料
生产资本
生产过剩
生产量
生人
生分
生前
生力军
生动
生动活泼
生化
生发
生变
生员
生命
生命力
生命现象
生命线
生土
生坯
生姜
生存
生存竞争
生就
生平
生态
生态学
生怕
生性
生息
生意
生成
生成物
生搬硬套
生效
生日
生机
生来
生根
生死
生死存亡
生殖
生殖器
生殖洄游
生殖细胞
生殖腺
生母
生民
生气
生气勃勃
生水
生油
生活
生活上
生活区
生活史
生活实践
生活方式
生活水平
生活空间
生活费
生活资料
生涯
生漆
生火
生灵
生物
生物化学
生物学
生物界
生物防治
生猪
生理
生理学
生理盐水
生疏
生疑
生病
生石灰
生硬
生色
生菜
生计
生财
生路
生铁
生锈
生长
生长期
生长点
生长率
生长素
生龙活虎
用不了
用不着
用事
用人
用以
用光
用兵
用具
用力
用功
用劲
用命
用品
用场
用处
用尽
用度
用得着
用心
用意
用户
用旧
用材林
用武
用法
用计
用语
用费
用途
用钱
田七
田主
田亩
田园
田地
田埂
田庄
田径
田径运动
田畴
田赋
田赛
田里
田野
田间
田间管理
由中
由余
由头
由来
由来已久
由此
由此可见
由衷
甲乙
甲兵
甲午战争
甲基
甲士
甲壳
甲子
甲板
甲烷
甲状腺
甲状腺肿
甲种维生素
甲第
甲胄鱼类
甲苯
甲酚
甲酸
甲醇
甲醛
甲骨文
甲鱼
申不害
申令
申报
申斥
申明
申诉
申请
申辩
电介质
电传机
电位
电位器
电位差
电信
电信号
电光
电冰箱
电刷
电力
电力工业
电力线
电力网
电功率
电动
电动势
电化学
电压互感器
电台
电告
电唱机
电器
电场
电子
电子云
电子伏特
电子元件
电子学
电子工业
电子显微镜
电子束
电子枪
电子流
电子电路
电子管
电子计算机
电学
电容
电容器
电导
电工
电平
电弧
电影
电影剧本
电影院
电感
电扇
电抗
电文
电晕
电机
电极
电枢
电桥
电梯
电气
电气化
电池
电池组
电波
电泳
电流
电流强度
电流继电器
电流表
电流计
电渗析
电渣炉
电火花
电灯
电灯泡
电炉
电烙铁
电热
电焊
电瓶
电石
电石气
电码
电磁
电磁场
电磁学
电磁感应
电磁振荡
电磁波
电磁辐射
电磁铁
电离
电离层
电离能
电站
电筒
电线
电缆
电网
电能
电荷
电表
电视
电视台
电视广播
电视接收机
电视机
电视直播卫星
电视频道
电解
电解槽
电解电容器
电解质
电讯
电话
电话会议
电话号码
电负性
电贺
电路
电路图
电车
电量
电钻
电铃
电铲
电键
电镀
电阻
电除尘器
电风扇
男人
男儿
男女
男女平等
男子
男子汉
男孩
男性
男方
男朋友
男生
男男女女
画一
画像
画儿
画册
画卷
画图
画外音
画室
画家
画展
画布
画幅
画廊
画报
画架
画法
画片
画皮
画稿
画笔
画面
畅快
畅所欲言
畅游
畅谈
畅通
畅销
界碑
界线
界说
界限
界面
界首
畏惧
畏缩
畏难
留任
留传
留声机
留存
留学
留学生
留守
留心
留念
留恋
留情
留意
留有余地
留点
留用
留神
留空
留给
留置
留置权
留连
畜产
畜力
畜牧
畜牧业
畜生
略低于
略加
略去
略图
略大于
略带
略微
略略
略阳
略高于
番禺
番茄
番薯
畸形
疆土
疆域
疆界
疏伐
疏密度
疏忽
疏散
疏松
疏水
疏浚
疏远
疏通
疑义
疑心
疑惑
疑惧
疑虑
疑问
疑难
疗养
疗养院
疗效
疗法
疙瘩
疟疾
疫区
疫病
疫苗
疯子
疯狂
疲乏
疲倦
疲劳
疲劳强度
疲劳极限
疲惫
疲惫不堪
疼爱
疼痛
疾病
疾苦
疾风
疾驰
病人
病例
病倒
病假
病势
病危
病历
病原
病原体
病原菌
病变
病号
病员
病因
病害
病床
病态
病情
病愈
病房
病株
病根
病毒
病灶
病状
病理
病理变化
病理学
病理解剖学
病症
病程
病粒
病菌
病虫害
病院
病魔
症候
症状
症结
痉挛
痊愈
痒痒
痕迹
痛切
痛哭
痛心
痛快
痛恨
痛打
痛斥
痛楚
痛痛快快
痛苦
痛骂
痢疾
瘀泥
瘀积
瘀血
瘟疫
瘠薄
瘤胃
瘦子
瘦小
瘦弱
瘦肉
瘦长
瘫痪
瘸子
癌症
登台
登场
登山
登岸
登峰造极
登报
登时
登极
登记
登载
登门
登陆
登高
白云石
白人
白俄罗斯
白兰
白兰地
白兰花
白军
白净
白化
白匪
白区
白发
白发苍
白发苍苍
白口
白口铁
白地
白垩
白塔
白天
白头
白宫
白居易
白布
白帝
白帝城
白底
白打
白族
白旗
白日
白昼
白朗
白杨
白杨树
白桦
白毛女
白水
白沙
白沙瓦
白河
白浊
白灰
白点
白炽灯
白热
白玉
白痢
白痴
白白
白白的
白相
白眼
白磷
白种
白米
白粉
白糖
白纸
白细胞
白肉
白色
白色恐怖
白花
白花花
白茫茫
白莲教
白菜
白薯
白虎
白蚁
白蛋白
白蜡
白蜡树
白蜡虫
白血球
白话
白话文
白质
白费
白酒
白醣
白金
白铁
白铁皮
白铜
白银
白陶
白露
白面
白骨
百一
百万
百万富翁
百两
百二
百会
百倍
百出
百分之百
百分数
百分比
百分率
百分表
百十
百姓
百官
百家
百家争鸣
百年
百年后
百战百胜
百户
百折不挠
百日
百济
百科全书
百般
百花齐放
百货
百货公司
百货商店
百里
皂化
皂洗
皂片
的确
的确良
的话
皇上
皇后
皇天
皇太后
皇室
皇宫
皇家
皇帝
皇庄
皇族
皇族内阁
皇朝
皇权
皇甫嵩
皮下
皮包
皮子
皮层
皮带
皮带传动
皮带轮
皮棉
皮毛
皮炎
皮球
皮皮
皮箱
皮肉
皮肤
皮袄
皮质
皮辊
皮面
皮革
皮鞋
皮鞭
皱痕
皱眉
皱眉头
皱纹
皱褶
盆地
盆子
盆景
盈亏
盈余
盈利
盈盈
益发
益处
益州
益虫
益都
盐业
盐井
盐卤
盐商
盐土
盐场
盐城
盐山
盐巴
盐析
盐水
盐池
盐法
盐湖
盐碱化
盐碱土
盐碱地
盐税
盐类
盐酸
监察
监工
监护
监牢
监狱
监督
监禁
监管
监视
盒子
盔甲
盖子
盖层
盖章
盗匪
盗用
盗窃
盗贼
盘剥
盘子
盘山
盘庚
盘旋
盘点
盘算
盘绕
盘踞
盘问
盛世
盛产
盛京
盛会
盛况
盛名
盛夏
盛大
盛宣怀
盛开
盛情
盛极一时
盛行
盛装
盛誉
盛赞
盟主
盟友
盟国
盟约
盥洗
目下
目不转睛
目光
目击
目前
目力
目录
目标
目的
目的地
目睹
目瞪口呆
目送
目镜
盯住
盲从
盲动主义
盲目
盲目性
盲肠
直到
直升机
直升飞机
直奔
直尺
直属
直径
直截了当
直捣
直接
直接染料
直接经验
直接证明
直接选举
直播
直流
直流发电机
直流电
直流电动机
直流电机
直率
直线
直肠
直至
直观
直观图
直视
直觉
直角
直角三角形
直角坐标
直辖市
直达
直道
直隶
相与
相中
相乘
相互
相互作用
相交
相亲
相仿
相传
相似
相似形
相位
相位差
相依
相信
相公
相关
相减
相切
相加
相反
相变
相合
相同
相国
相声
相处
相好
相宜
相对
相对性
相对性状
相对数
相对湿度
相对论
相对误差
相对运动
相对速度
相差
相帮
相干
相平衡
相应
相当
相形
相成
相抵
相持
相接
相提并论
相机
相比
相沿
相爱
相片
相率
相电流
相称
相符
相等
相约
相继
相识
相象
相貌
相距
相辅相成
相近
相连
相适应
相通
相逢
相遇
相间
相除
相隔
相面
盼望
盾皮鱼类
省下
省中
省事
省份
省会
省军区
省去
省吃俭用
省城
省委
省得
省文
省煤器
省略
省长
眉头
眉开眼笑
眉梢
眉毛
眉目
眉眼
眉飞色舞
看上
看不惯
看不起
看中
看作
看做
看出
看到
看台
看守
看守所
看家
看待
看得起
看成
看护
看望
看来
看样子
看法
看病
看相
看看
看破
看穿
看管
看见
看起来
看过
看透
看重
看门
看齐
真个
真主
真人
真值表
真切
真可
真如
真实
真实性
真心
真心实意
真情
真挚
真是
真正
真理
真理报
真的
真相
真真
真知
真确
真空
真空泵
真空管
真菌
真诚
真迹
眨巴
眨眼
眯缝
眷属
眺望
眼下
眼光
眼前
眼力
眼圈
眼巴巴
眼底
眼时
眼泪
眼珠子
眼球
眼界
眼皮
眼看
眼眶
眼睑
眼睛
眼神
眼科
眼窝
眼红
眼色
眼花
眼虫
眼角
眼里
眼镜
着力
着哩
着急
着手
着火
着火点
着眼
着色
着重
着重指出
着陆
睡梦
睡眠
睡觉
督促
督促检查
督军
督办
督战
督抚
睦邻
睫毛
睾丸
瞄准
瞅着
瞅见
瞌睡
瞎子
瞎扯
瞎指挥
瞎说
瞥见
瞧不起
瞧见
瞪眼
瞬息
瞬时值
瞬间
瞻仰
矗立
矛头
矛盾
矛盾的普遍性
矛盾的特殊性
矛盾论
矜持
矢量
知事
知县
知名
知己
知府
知心
知情
知方
知法
知觉
知识
知识分子
知识化
知识青年
知足
知道
知青
知音
矩形
矩阵
矫健
矫正
矫直
矫直机
短传
短促
短兵相接
短命
短处
短大衣
短小
短小精悍
短少
短工
短文
短暂
短期
短波
短短
短短的
短篇小说
短粗
短纤维
短缺
短见
短训班
短评
短跑
短路
短长
短音
矮小
矮秆作物
石人
石刻
石勒
石匠
石印
石台
石器
石块
石墨
石头
石子
石室
石家庄
石山
石崇
石料
石板
石柱
石桥
石棉
石棉布
石榴
石河子
石油
石油化学
石油气
石油输出国组织
石灰
石灰乳
石灰岩
石灰水
石灰石
石灰窑
石灰质
石炭
石炭纪
石碑
石经
石膏
石膏像
石英
石蕊
石蕊试纸
石虎
石蜡
石门
石雷
矸石
矽酸
矿业
矿井
矿产
矿体
矿体厚度
矿区
矿坑
矿层
矿山
矿山压力
矿工
矿床
矿房
矿柱
矿泉
矿泥
矿浆
矿渣
矿物
矿物学
矿物油
矿物质饲料
矿石
矿砂
矿脉
矿藏
矿质
矿车
码头
砂土
砂型
砂姜
砂岩
砂布
砂浆
砂眼
砂糖
砂纸
砂轮
砍伐
砒霜
研制
研磨
研究
研究员
研究室
研究所
研究生
研讨
砖头
砖茶
砝码
砧木
破产
破口
破口大骂
破土
破坏
破天荒
破损
破旧
破晓
破格
破案
破灭
破烂
破碎
破绽
破获
破落
破裂
破除
破除迷信
砸碎
硅橡胶
硅油
硅石
硅砖
硅藻
硅酸
硅酸盐
硅酸钠
硅钢片
硕士
硝化
硝基
硝基苯
硝烟
硝石
硝酸
硝酸盐
硝酸钙
硝酸钠
硝酸钾
硝酸铵
硫化
硫化染料
硫化氢
硫化物
硫化碱
硫化钠
硫化铅
硫化锌
硫化黑
硫磺
硫胺素
硫酸
硫酸亚铁
硫酸盐
硫酸钙
硫酸钠
硫酸钡
硫酸钾
硫酸铜
硫酸铝
硫酸铵
硫酸锌
硫酸镁
硫铁矿
硬件
硬化
硬壳
硬币
硬度
硬性
硬是
硬木
硬水
硬着头皮
硬纸板
硬脂
硬说
硬质合金
硬面
硬骨头
硬骨鱼类
确信
确凿
确切
确定
确实
确当
确立
确认
硼酸
碎块
碎片
碎石
碎裂
碑文
碘化钾
碘化银
碘酒
碟子
碧波
碧玉
碧绿
碧螺春
碰壁
碰头
碰巧
碰撞
碰见
碱化
碱土金属
碱地
碱度
碱性
碱性平炉
碱性氧化物
碱熔
碱纤维素
碱金属
碳化物
碳化硅
碳氢化合物
碳水化合物
碳源
碳素钢
碳酸
碳酸氢钠
碳酸氢铵
碳酸盐
碳酸钙
碳酸钠
碳酸钾
碳酸镁
磁体
磁力
磁力线
磁化
磁场
磁场强度
磁头
磁带
磁心
磁性
磁性天线
磁性材料
磁性瓷
磁感应强度
磁放大器
磁效应
磁极
磁榘
磁流体
磁盘
磁矩
磁能
磁选
磁通量
磁针
磁铁
磁铁矿
磋商
磕头
磨光
磨削
磨合
磨床
磨损
磨擦
磨料
磨灭
磨石
磨矿
磨耗
磨难
磷光
磷矿粉
磷肥
磷脂
磷酸
磷酸盐
磷酸钙
磷酸钠
磺化
磺胺
磺胺噻唑
磺酸
礁石
示众
示例
示威
示弱
示意
示意图
示波器
示波管
示范
礼仪
礼品
礼堂
礼宾司
礼拜
礼拜六派
礼教
礼服
礼法
礼物
礼节
礼让
礼记
礼貌
礼部
社会
社会主义
社会主义公有制
社会主义建设
社会主义所有制
社会主义改造
社会主义积累
社会主义竞赛
社会主义经济
社会主义者
社会主义革命
社会保险
社会公德
社会关系
社会分工
社会制度
社会变革
社会基础
社会存在
社会学
社会实践
社会帝国主义
社会形态
社会必要劳动
社会意识
社会意识形态
社会民主主义
社会民主党人
社会沙文主义
社会活动
社会生产价格
社会生活
社会科学
社会经济形态
社会经济结构
社会资本
社团
社日
社稷
社论
祁连山
祁门
祈求
祈祷
祖传
祖先
祖国
祖坟
祖宗
祖师
祖母
祖父
祖祖辈辈
祖逖
祝寿
祝愿
祝福
祝词
祝贺
祝酒
神仙
神像
神化
神君
神圣
神奇
神女
神学
神州
神异
神往
神志
神态
神怪
神情
神户
神明
神权
神枪手
神气
神汉
神灭论
神灵
神甫
神秘
神秘主义
神童
神经
神经中枢
神经原
神经病
神经类型
神经系统
神经纤维
神经细胞
神经节
神经衰弱
神经质
神经过敏
神色
神话
神道
神采
祠堂
票价
票子
祭天
祭祀
祭酒
祷告
祸乱
祸国殃民
祸害
祸根
祸首
禀报
禁不住
禁令
禁军
禁区
禁卫
禁欲主义
禁止
禁烟
禁绝
禁运
禁锢
禁闭
禅宗
禅师
福公司
福冈
福利
福安
福尔马林
福州
福建
福建省
福气
福特
福王
福音
离别
离合器
离奇
离婚
离子
离子交换
离家
离开
离弦
离心
离心力
离心机
离散
离析
离职
离解
离间
禽兽
禽舍
禾本科
禾苗
秀丽
秀才
私下
私事
私产
私人
私商
私塾
私学
私家
私心
私有
私有制
私法
私自
私营
私藏
私通
秉承
秋分
秋千
秋后
秋天
秋季
秋播
秋收
秋收起义
秋水
秋汛
秋田
秋耕
秋风
种上
种别
种地
种子
种子园
种子地
种子田
种差
种族
种族主义
种族歧视
种植
种植业
种植园
种概念
种猪
种玉
种田
种畜
种种
种类
种群
种肥
种花
种蛋
种马
种麻
科举
科伦坡
科克
科威特
科学
科学化
科学家
科学技术
科学界
科学研究
科学社会主义
科学管理
科学院
科尔
科尔尼洛夫
科技
科摩罗
科普
科班
科目
科研
科研成果
科长
秒表
秘书
秘书长
秘史
秘密
秘鲁
租佃
租借
租借地
租子
租庸调
租用
租界
租税
租米
租约
租船
租金
秤钩
秤锤
秦岭
秦律
秦皇岛
秧歌
秧田
秧苗
秧龄
秩序
积习
积云
积冰
积分
积分电路
积压
积善
积存
积弊
积木
积极
积极分子
积极因素
积极性
积案
积水
积温
积累
积累基金
积聚
积肥
积蓄
积雨云
积雪
称之为
称号
称呼
称得起
称心
称王称霸
称病
称谓
称赞
称述
称道
称霸
称霸世界
称颂
移交
移动
移居
移情
移时
移栽
移植
移民
移苗
移行
移项
稀奇
稀少
稀有
稀有金属
稀疏
稀盐酸
稀罕
稀薄
稀释
稀饭
程咬金
程序
程序控制
程序设计
程度
程式
稍为
稍微
稍稍
稍许
稍高于
税则
税制
税务
税务司
税收
税款
税率
税金
税额
稗子
稚气
稠密
稠度
稳产高产
稳住
稳健
稳固
稳妥
稳定
稳定剂
稳定性
稳当
稳步
稳重
稷下
稻地
稻子
稻田
稻瘟病
稻种
稻穗
稻米
稻草
稻谷
稽查
稿件
稿子
稿纸
稿费
穆尔
穆斯林
穆罕默德
穗子
穗肥
穴位
穴居
穴播
穴道
究竟
穷人
穷光蛋
穷凶极恶
穷困
穷奢极欲
穷尽
穷棒子
穷苦
穷追
穷队
空中
空位
空军
空军基地
空前
空地
空头
空子
空心
空心砖
空想
空想社会主义
空手
空旷
空格
空气
空气冷却器
空气压缩机
空气喷气发动机
空气密度
空气滤清器
空气调节
空气阻力
空泡
空洞
空白
空穴
空空
空翻
空虚
空袭
空话
空谈
空转
空载
空运
空速
空闲
空间
空间和时间
空间电荷
空间结构
空降
空隙
穿刺
穿孔
穿孔机
穿戴
穿插
穿梭
穿着
穿越
穿透电流
穿鼻
突兀
突出
突击
突厥
突变
突围
突如其来
突尼斯
突然
突然袭击
突破
突突
突袭
突触
突起
突进
突飞猛进
窃取
窃国
窃据
窍门
窑洞
窒息
窗口
窗台
窗子
窗帘
窗户
窗框
窗洞
窗玻璃
窘境
窝头
窝工
窝棚
窝藏
窟窿
窥视
窦娥冤
窦建德
窿缘桉
立于不败之地
立井
立体
立体几何
立体图
立体声
立冬
立刻
立功
立即
立嗣
立国
立地
立地条件
立场
立夏
立定
立宪
立宪民主党
立宪派
立宪运动
立式
立志
立意
立新
立方
立方体
立方根
立时
立春
立木
立枯病
立柱
立案
立正
立法
立法机关
立法权
立秋
立言
立论
立足
立足点
立轴
立面图
竖井
竖立
竖起
站住
站台
站定
站岗
站稳
站长
竞争
竞技
竞赛
竞选
竟会
竟敢
竟是
竟然
竟至
竟陵
章句
章和
章回体
章回小说
章法
章程
章节
章邯
竣工
童养媳
童子
童工
童年
童心
童话
竭力
竭尽
端坐
端庄
端方
端正
端电压
端相
端线
端详
端面
竹叶
竹器
竹子
竹板
竹林
竹楼
竹竿
竹筒
竹签
竹简
竹管
竹节
竿子
笆斗
笑嘻嘻
笑容
笑林
笑眯眯
笑脸
笑话
笑语
笑貌
笔下
笔力
笔名
笔墨
笔头
笔套
笔尖
笔录
笔杆
笔法
笔画
笔直
笔者
笔舌
笔触
笔记
笔调
笔资
笔迹
笔锋
笛卡儿
笛子
笛膜
符号
符合
笨拙
笨重
第一
第一信号系统
第一卷
第一名
第一审
第一性
第一手
第一次世界大战
第一流
第一线
第三世界
第三等级
第三纪
第三者
第二世界
第二信号系统
第二名
第二国际
第二宇宙速度
第二审
第二性
第二次世界大战
第四纪
笼子
笼络
笼统
笼罩
等于零
等人
等价
等价物
等份
等位基因
等候
等值线
等分
等到
等势面
等号
等同
等外
等子
等差
等差数列
等式
等待
等效
等效电路
等日
等比数列
等温
等温线
等离子体
等积形
等等
等级
等腰
等腰三角形
等角
等距
等距离
等边
等边三角形
等闲
等高线
筋斗
筋肉
筋骨
筐子
筒子
筒管
答卷
答复
答应
答案
答理
答话
答谢
答辩
策划
策动
策应
策源地
策略
筛分
筛号
筛子
筛板
筛选
筷子
筹划
筹办
筹商
筹备
筹安会
筹建
筹措
筹集
签发
签名
签字
签署
签订
签证
简介
简便
简写
简化
简单
简单再生产
简单劳动
简单化
简单协作
简单商品生产
简单机械
简单生产
简史
简图
简报
简捷
简明
简易
简朴
简洁
简略
简直
简短
简称
简章
简练
简要
简讯
简记
简谱
简陋
箅子
箕斗
算不了什么
算了
算命
算学
算帐
算式
算得
算得什么
算数
算术
算法
算法语言
算盘
算计
管乐器
管事
管仲
管保
管制
管子
管家
管带
管弦
管弦乐
管弦乐队
管接头
管教
管材
管束
管理
管理体制
管理所
管理费用
管用
管纱
管线
管胞
管路
管辖
管道
管领
箩筐
箭头
箱子
箱底
篇幅
篇章
篝火
篡位
篡夺
篡改
篮子
篮球
篱笆
篼接
篼钉
簇拥
簸箕
簿记
籍贯
米兰
米勒
米吐尔
米尔
米粉
米粒
米糠
米脂
米色
米饭
类似
类型
类推
类星体
类次
类比
类经
籽棉
粉丝
粉刷
粉剂
粉尘
粉末
粉末冶金
粉条
粉煤
粉状
粉碎
粉碎机
粉笔
粉红
粉身碎骨
粉饰
粒子
粒度
粒径
粒状
粒选
粗制品
粗制滥造
粗加工
粗壮
粗大
粗布
粗心
粗心大意
粗放
粗暴
粗枝大叶
粗毛
粗毛羊
粗浅
粗犷
粗略
粗笨
粗粗
粗粮
粗糙
粗纤维
粗纱
粗纺
粗细
粗脂肪
粗蛋白质
粗选
粗重
粗野
粗饲料
粗鲁
粘住
粘贴
粘连
粤汉铁路
粪便
粪堆
粪肥
粮仓
粮店
粮草
粮食
粮食作物
粮饷
粳稻
粽子
精光
精制
精力
精华
精囊
精壮
精妙
精子
精密
精密仪器
精密度
精巢
精巧
精干
精度
精彩
精微
精心
精打细算
精明
精梳
精液
精湛
精灵
精炼
精益求精
精盐
精矿
精确
精确度
精神
精神世界
精神抖擞
精神病
精简
精纺
精细
精细管
精美
精耕细作
精致
精良
精辟
精选
精通
精采
精锐
精饲料
精馏
精馏塔
精髓
糊口
糊涂
糊精
糊里糊涂
糌粑
糕点
糙米
糜烂
糟粕
糟糕
糟蹋
糠虾
糠醛
糯米
系列
系列化
系数
系统
系统发育
系统工程
紊乱
紊流
素养
素描
素数
素材
素来
素菜
素质
索取
索尔兹伯里
索引
索性
索氏体
索赔
索道
索非亚
索马里
紧凑
紧密
紧张
紧急
紧急制动阀
紧握
紧着
紧箍咒
紧紧
紧紧的
紧缩
紧要
紧迫
紫云英
紫外线
紫穗槐
紫红
紫罗兰
紫菜
紫金
紫金山
紫铜
累加
累加器
累死
累犯
累积
累累
累计
累赘
絮凝
絮絮
繁华
繁复
繁多
繁忙
繁杂
繁殖
繁殖力
繁殖系数
繁盛
繁育
繁茂
繁荣
繁荣昌盛
繁重
繁难
纠合
纠察
纠正
纠纷
纠缠
纠集
纡子
红丹
红人
红光
红军
红十字会
红卫
红卫兵
红叶
红四军
红壤
红外线
红外线灯
红小兵
红岩
红心
红旗
红旗手
红星
红曲
红木
红松
红果
红柳
红树
红树林
红楼
红楼梦
红河
红海
红润
红火
红烧
红热
红磷
红糖
红红的
红线
红细胞
红肿
红脸
红色
红色中华
红色政权
红花
红苕
红茶
红薯
红血球
红豆
红铜
红领巾
红颜
红麻
纤毛
纤毛虫
纤维
纤维板
纤维素
纤维长度
约会
约克
约分
约同
约定
约摸
约数
约旦
约旦河
约束
约法
约法三章
约瑟夫
约略
约翰
约翰逊
约莫
约计
级别
级差地租
级数
级进杂交
纪元
纪年
纪录
纪律
纪律处分
纪律性
纪念
纪念品
纪念堂
纪念日
纪念碑
纪念章
纪念馆
纪要
纬密
纬度
纬纱
纬线
纯净
纯利
纯小数
纯度
纯律
纯收入
纯朴
纯林
纯正
纯洁
纯熟
纯真
纯碱
纯种
纯粹
纱厂
纱巾
纱布
纱线
纱罗
纱锭
纲常
纲目
纲要
纲领
纳入
纳税
纳米比亚
纳粹
纳苗
纳贡
纳赛尔
纳闷
纵使
纵剖面
纵坐标
纵容
纵断面
纵横
纵横交错
纵横跤错
纵波
纵深
纵火
纵然
纵贯
纵身
纵队
纷乱
纷争
纷纭
纷纷
纸头
纸币
纸带
纸张
纸浆
纸烟
纸片
纸老虎
纸面
纹板
纹样
纹理
纹路
纺丝
纺纱
纺纱机
纺织
纺织厂
纺织品
纺织工业
纺车
纺锤
纽带
纽扣
纽约
线圈
线型
线头
线形
线性
线性元件
线性变换
线性方程组
线材
线条
线段
线粒体
线索
线绳
线胀系数
线膨胀
线虫
线虫病
线路
线速度
线间
练习
练习曲
练兵
练武
组件
组合
组成
组成部分
组织
组织上
组织学
组织形式
组织性
组织液
组织生活
组织胺
组织路线
组织部
组织领导
组胺
组长
绅士
细则
细嫩
细密
细小
细布
细弱
细微
细心
细毛
细毛羊
细民
细碎
细纱
细线
细细
细细的
细胞体
细胞分裂
细胞器
细胞壁
细胞学
细胞核
细胞液
细胞膜
细胞质
细腻
细致
细节
细菌
细软
细部
细长
细雨
织女星
织工
织布
织成
织机
织物
织物组织
织轴
织造
终了
终南山
终审
终局
终年
终归
终日
终极
终止
终点
终生
终究
终端
终端设备
终结
终身
绉纱
绊脚石
绍兴
绍酒
经不起
经久
经义
经书
经互会
经典
经典作家
经典著作
经历
经受
经商
经学
经密
经常
经度
经心
经手
经济
经济一体化
经济业务
经济主义
经济作物
经济侵略
经济制度
经济危机
经济基础
经济学
经济恐慌
经济成分
经济技术指标
经济杠杆
经济林
经济核算
经济活动分析
经济管理
经济范畴
经理
经由
经略
经管
经籍
经纬
经纱
经线
经络
经营
经解
经费
经轴
经过
经销
经验
经验主义
绑架
绑腿
绒布
绒毛
绒线
绒衣
结业
结义
结交
结伴
结余
结合
结合实际
结合律
结合水
结合能
结块
结婚
结子
结存
结实
结尾
结局
结扎
结晶
结晶体
结晶器
结晶水
结束
结束语
结构
结构式
结构钢
结果
结果枝
结核
结核病
结案
结焦
结盟
结石
结社
结算
结结巴巴
结缔组织
结节
结论
结识
结语
结队
结集
绕组
绕道
绘制
绘图
绘声绘色
绘画
给予
给人以
给以
绚丽
绚烂
络合
络合物
络线
络绎不绝
绝伦
绝口
绝句
绝地
绝境
绝壁
绝大多数
绝大部分
绝妙
绝对
绝对值
绝对化
绝对数
绝对温度
绝对温标
绝对湿度
绝对观念
绝对误差
绝对零度
绝望
绝热
绝热过程
绝种
绝缘体
绝缘材料
绝路
绝迹
绝顶
绝食
绞刀
绞刑
绞杀
绞盘
绞肉机
绞车
统一
统一体
统一党
统一性
统一战线
统一计划
统制
统帅
统带
统战
统治
统治者
统治阶级
统率
统称
统筹
统筹兼顾
统统
统计
统计图
统计学
统计表
统购
统购统销
统辖
统销
统领
绣球
绣花
绥远
绦虫
继任
继往开来
继承
继承人
继承权
继武
继母
继电器
继续
继续革命
继而
绪言
绪论
续编
续航力
绯红
绰号
绳子
绳索
维也纳
维修
维吾尔族
维多利亚
维护
维持
维新
维生素缺乏症
维系
维纶
维辛斯基
维那
绵亘
绵延
绵绵
绵羊
绵长
绵阳
绷带
绸子
绸缎
综上所述
综合
综合利用
综合平衡
综合防治
综观
综述
绿化
绿叶
绿地
绿林
绿水
绿油油
绿洲
绿灯
绿竹
绿绿的
绿肥
绿肥作物
绿色
绿色植物
绿茶
绿荫
绿营
绿藻
绿豆
缄默
缅怀
缅甸
缆绳
缉拿
缉捕
缎子
缎纹
缓冲
缓冲器
缓冲溶液
缓刑
缓和
缓急
缓慢
缓期
缓解
缔约
缔约国
缔结
缔造
缕缕
编修
编入
编写
编制
编剧
编印
编号
编户
编排
编码
编篡
编纂
编织
编者
编者按
编著
编订
编译
编辑
编辑部
编选
编造
编队
缘故
缝合
缝纫
缝纫机
缝线
缝补
缝隙
缠绕
缠足
缢死
缤纷
缩写
缩减
缩合
缩孔
缩小
缩尺
缩影
缩水
缩短
缩聚
缩聚反应
缫丝
缭绕
缰绳
缴付
缴械
缴纳
缴获
缺乏
缺勤
缺口
缺少
缺席
缺点
缺苗
缺陷
罐头
罐头食品
罐子
罐笼
罐车
网点
网状结构
网球
网眼
网箱
网络
网罗
网膜
罕见
罗丹
罗伯特
罗列
罗嗦
罗布林卡
罗得西亚
罗拉
罗斯
罗斯托夫
罗星塔
罗汉
罗瑞卿
罗盘
罗素
罗纹
罗织
罗经
罗网
罗罗
罗蒙诺索夫
罗钦顺
罗非鱼
罗马
罗马尼亚
罗马帝国
罗马数字
罗马法
罚款
罚球
罚金
罢了
罢休
罢免
罢官
罢工
罢市
罢教
罢课
罢黜
罩子
罪人
罪名
罪大恶极
罪恶
罪恶行径
罪犯
罪状
罪行
罪证
罪责
罪过
罪魁
罪魁祸首
置之不理
置信
置换
置疑
置身
署名
羁押
羊毛
羊皮
羊绒
羊羔
羊群
羊肉
羊角
羌族
美丽
美人
美利坚合众国
美化
美名
美味
美国
美女
美好
美妙
美学
美德
美感
美景
美术
美梦
美洲
美满
美育
美观
美谈
美酒
美金
羔羊
羞怯
羞愧
羞涩
羞耻
羞辱
羟基
羡慕
群众
群众性
群众组织
群众观点
群众路线
群众运动
群体
群婚
群小
群居
群岛
群峰
群情
群治学社
群策群力
群落
群起
羧基
羧酸
羽化
羽毛
羽毛球
翁同和
翅膀
翌日
翟让
翠绿
翡翠
翩翩
翰林
翰林学士
翻一番
翻修
翻动
翻印
翻地
翻天
翻天覆地
翻山越岭
翻开
翻成
翻新
翻来复去
翻案
翻滚
翻版
翻翻
翻腾
翻译
翻越
翻身
翻车
翻阅
翼展
耀眼
老一套
老一辈
老乡
老人
老人家
老伯
老伴
老伴儿
老兄
老先生
老公
老兵
老农
老前辈
老化
老区
老友
老叔
老命
老大
老大娘
老大爷
老大难
老天爷
老太太
老太婆
老太爷
老夫
老头
老头儿
老头子
老奶奶
老妈子
老娘
老婆
老婆婆
老婆子
老子
老实
老家
老将
老小
老少
老师
老师傅
老干部
老年
老幺
老底
老式
老弟
老弱
老总
老成
老手
老挝
老早
老是
老朽
老板
老林
老毛病
老气
老汉
老爷
老爷子
老爷爷
老爹
老牌
老王
老生常谈
老百姓
老祖宗
老练
老翁
老老
老老实实
老者
老花眼
老营
老虎
老规矩
老话
老财
老路
老辈
老远
老道
老酒
老长
老高
老黄牛
老鼠
考勤
考取
考古
考古学
考夫卡
考察
考据
考查
考核
考生
考种
考究
考茨基
考虑
考证
考试
考验
而且
而今
而况
而又
而后
而外
而已
而是
而立
耍态度
耐久
耐久性
耐人寻味
耐力
耐劳
耐寒
耐寒性
耐心
耐性
耐火
耐火度
耐火材料
耐火砖
耐火黏土
耐烦
耐热
耐热合金
耐热钢
耐用
耐碱
耐磨
耐磨性能
耐穿
耐酸
耕作
耕作制度
耕作层
耕地
耕地面积
耕牛
耕田
耕畜
耕种
耕翻
耕耘
耗子
耗尽
耗损
耗散
耗油率
耗电量
耗费
耦合
耳光
耳朵
耳机
耳环
耳目
耳石
耳语
耳闻
耶和华
耶稣
耶路撒冷
耷拉
耸立
耻辱
耽搁
耽误
耿精忠
聆听
聊天
聋子
职业
职位
职务
职员
职守
职官
职工
职权
职称
职能
职能资本
职责
联共
联军
联合
联合会
联合公报
联合制
联合国
联合国大会
联合国宪章
联合声明
联合收割机
联合政府
联合机
联名
联大
联席会议
联想
联接
联欢
联盟
联系
联系国
联系实际
联系群众
联组
联结
联络
联苯
联营
联言判断
联贯
联赛
联轴器
联轴节
联运
联锁
联防
聚丙烯
聚乙烯
聚乙烯醇
聚会
聚变
聚变反应
聚合
聚合反应
聚合物
聚四氟乙烯
聚宝盆
聚居
聚敛
聚星
聚氯乙烯
聚氯乙烯塑料
聚焦
聚砜
聚积
聚精会神
聚苯乙烯
聚酯
聚酯树脂
聚酯纤维
聚酰亚胺
聚酰胺
聚集
聚餐
聪明
聪明才智
肃反
肃清
肃然
肃穆
肄业
肆意
肆无忌惮
肇事
肇庆
肉丁
肉体
肉刑
肉末
肉片
肉皮
肉眼
肉类
肉食
肉食性
肉麻
肋骨
肌体
肌肉
肖像
肖邦
肘子
肚子
肚皮
肛门
肝胆
肝脏
肠子
肠炎
肠管
股东
股份
股份有限公司
股子
股息
股本
股票
股金
肢体
肢解
肤浅
肤色
肥东
肥分
肥力
肥厚
肥城
肥壮
肥大
肥效
肥料
肥水
肥沃
肥源
肥田
肥田粉
肥皂
肥缺
肥美
肥育
肥胖
肩头
肩带
肩胛
肩膀
肩负
肮脏
肯定
肯尼亚
肯尼迪
育成杂交
育林
育种
育秧
育肥
育苗
育雏
育龄
肺循环
肺泡
肺炎
肺病
肺脏
肺腑
肾上腺
肾上腺素
肾脏
肿瘤
肿胀
胁从
胁迫
胃口
胃液
胃炎
胃病
胃肠
胃酸
胃镜
胆囊
胆固醇
胆大
胆子
胆小
胆小鬼
胆怯
胆战心惊
胆敢
胆汁
胆略
胆管
胆识
胆量
背书
背信弃义
背光
背包
背叛
背后
背地里
背弃
背影
背後
背心
背斜
背景
背离
背脊
背诵
背负
背道而驰
背部
背面
背风
背鳍
胎儿
胎生
胎盘
胖子
胖胖的
胚乳
胚层
胚根
胚珠
胚胎
胚芽
胚轴
胜于
胜仗
胜任
胜似
胜利
胜利果实
胜利者
胜地
胜负
胜败
胡乱
胡作非为
胡同
胡子
胡志明
胡思乱想
胡来
胡桃
胡椒
胡汉民
胡海
胡涂
胡琴
胡萝卜
胡萝卜素
胡言
胡诌
胡话
胡说
胡说八道
胡闹
胡须
胡麻
胭脂
胱氨酸
胳膊
胳臂
胶东
胶乳
胶体
胶体溶液
胶卷
胶合
胶合板
胶州湾
胶布
胶带
胶木
胶水
胶泥
胶片
胶皮
胶着
胶粒
胶结
胶鞋
胸像
胸口
胸围
胸怀
胸脯
胸腔
胸腺
胸膛
胸襟
胸部
胸骨
胸鳍
能上能下
能为
能事
能人
能力
能动
能动性
能否
能够
能带
能干
能手
能文能武
能知
能级
能者
能耐
能量
脂粉
脂肪
脂肪酸
脂蛋白
脆弱
脆性
脉冲
脉冲雷达
脉动
脉动电流
脉搏
脉石
脊柱
脊梁
脊椎
脊椎动物
脊索
脊背
脊髓
脍炙人口
脏器
脑儿
脑力
脑力劳动
脑壳
脑子
脑室
脑汁
脑海
脑神经
脑筋
脑膜
脑袋
脑颅
脑髓
脓疮
脓病
脖子
脚下
脚印
脚尖
脚手架
脚掌
脚本
脚板
脚步
脚趾
脚跟
脚踏实地
脚踏车
脱产
脱出
脱手
脱模
脱毛
脱氢
脱氧
脱氧核糖
脱水
脱泡
脱盐
脱硫
脱碳
脱离
脱空
脱粒
脱粒机
脱胎
脱胶
脱脂
脱色
脱节
脱身
脱逃
脱销
脱险
脸子
脸庞
脸皮
脸盆
脸红
脸色
脸谱
脸面
脸颊
脾气
脾脏
腈纶
腊子口
腊斯克
腊月
腊梅
腋下
腋芽
腐化
腐朽
腐植质
腐烂
腐熟
腐生
腐蚀
腔调
腕力
腥黑穗病
腰包
腰围
腰带
腰斩
腰部
腰鼓
腹壁
腹板
腹泻
腹背受敌
腹腔
腹部
腹面
腺癌
腻子
腾空
腾腾
腾越
腿子
腿脚
膀子
膀胱
膏药
膘情
膝关节
膝盖
膨大
膨胀
膨胀系数
膳食
臀鳍
臂膀
臂膊
臃肿
臆想
臆断
臆造
臣妾
臣子
臣服
臣民
自上而下
自下而上
自个儿
自为
自主
自交系
自从
自传
自信
自信心
自修
自决
自制
自力
自力更生
自动
自动化
自动增益控制
自动控制
自动生产线
自动线
自动驾驶仪
自卫
自发
自变量
自叙
自古
自古以来
自告奋勇
自命
自在
自大
自如
自始至终
自学
自家
自封
自尊
自尊心
自尽
自居
自己
自己人
自序
自得
自恃
自我
自我批评
自我牺牲
自救
自新
自是
自杀
自来
自来水
自欺欺人
自治
自治区
自治县
自治州
自流
自流井
自流灌溉
自满
自然
自然主义
自然人
自然力
自然数
自然村
自然法学派
自然灾害
自然科学
自然经济
自然美
自然而然
自然观
自然选择
自然通风
自燃
自爱
自理
自用
自由
自由主义
自由体操
自由基
自由市场
自由心证
自由民
自由王国
自由电子
自由竞争
自由组合规律
自由自在
自由落体运动
自由锻
自由面
自留地
自白
自相
自相矛盾
自私
自私自利
自称
自称为
自立
自经
自给
自给自足
自耕农
自若
自行
自行其是
自行车
自觉
自觉自愿
自言自语
自诉
自豪
自负
自负盈亏
自身
自转
自述
自选
自重
自问
自食其力
自首
自高自大
臭名昭著
臭气
臭氧
臭虫
至上
至人
至今
至元
至多
至大
至少
至日
至正
至此
至迟
至道
至高无上
致使
致冷
致函
致力
致命
致密
致富
致意
致敬
致死
致死量
致用
致电
致病
致词
致谢
臼齿
舅妈
舅父
舅舅
舆论
舌头
舌根
舌骨
舍不得
舍弃
舍弟
舍得
舍身
舒坦
舒展
舒张
舒服
舒畅
舒适
舞会
舞伴
舞剧
舞动
舞厅
舞台
舞女
舞姿
舞弊
舞曲
舞池
舞蹈
舟山
舢板
航向
航天
航标
航海
航程
航空
航空母舰
航空运输
航线
航船
航行
航路
航运
航速
航道
舰艇
舰队
舱室
舵手
船位
船体
船只
船台
船员
船坞
船壳
船夫
船工
船舱
船舶
船舷
船长
船闸
船队
船首
良久
良人
良友
良好
良心
良民
良田
良知
良种
艰巨
艰苦
艰苦奋斗
艰辛
艰险
艰难
艰难曲折
色光
色差
色度
色当
色彩
色情
色散
色料
色泽
色相
色素
色调
艳丽
艺人
艺文志
艺术
艺术品
艺术家
艺术性
艺术美
艾子
艾森豪威尔
艾艾
节余
节制
节制资本
节圆
节奏
节奏性
节子
节度使
节录
节律
节拍
节日
节本
节概
节气
节流阀
节点
节烈
节片
节理
节用
节目
节省
节约
节肢动物
节育
节节
节间
芋头
芒果
芒硝
芒种
芙蓉
芜湖
芝加哥
芝麻
芝麻油
芥菜
芦席
芦沟桥
芦笙
芦花
芦苇
芬兰
芬奇
芬芳
芭蕾舞
芯子
花丝
花儿
花冠
花刺子模
花卉
花厂
花呢
花圈
花坛
花娘
花子
花岗岩
花市
花布
花序
花招
花旗
花月痕
花期
花木
花朵
花束
花柱
花样
花样滑冰
花椒
花炮
花瓣
花瓶
花生
花生油
花生米
花生饼
花甲
花白
花盆
花筒
花粉
花粉管
花红
花纹
花脸
花色
花花绿绿
花芽
花芽分化
花茶
花草
花药
花萼
花蕾
花蜜
花衣
花被
花费
花轴
花轿
花边
花键
花键轴
花青
花青素
花鸟
芳烃
芳香
芳香工业
芳香族
芳香植物
芳香烃
芹菜
苋菜
苍天
苍白
苍翠
苍老
苍苍
苍茫
苍蝇
苎麻
苏丹
苏伊士
苏伊士运河
苏俄
苏区
苏峻
苏州
苏打
苏方
苏木
苏格兰
苏维埃
苏联
苏醒
苏铁
苏黎世
苔原
苗圃
苗头
苗子
苗床
苗族
苗期
苗木
苗条
苗种
苗肥
苛刻
苛性碱
苛性钠
苛性钾
苛捐杂税
苛求
苜苜
苞米
苟且
苟安
苟延残喘
若为
若何
若夫
若干
若无其事
若是
若有所思
若虫
若非
苦于
苦人
苦力
苦功
苦卤
苦味
苦味酸
苦命
苦处
苦头
苦干
苦役
苦心
苦恼
苦战
苦树
苦楚
苦水
苦海
苦涩
苦痛
苦笑
苦练
苦苦
苦衷
苦闷
苦难
苯乙烯
苯基
苯环
苯甲酸
苯胺
苯酚
英两
英亩
英俊
英制
英吉利海峡
英名
英国
英姿
英寸
英尺
英德
英才
英文
英明
英格兰
英武
英石
英联邦
英语
英里
英镑
英雄
苹果
茁壮
茂密
茂盛
范例
范围
范德林特
范文
范本
范畴
范阳
茄子
茅台酒
茅屋
茅山
茅草
茉茉
茜素
茧丝
茧层
茨坪
茫然
茫茫
茬口
茴香
茶会
茶农
茶几
茶叶
茶园
茶场
茶壶
茶房
茶杯
茶树
茶楼
茶水
茶汤
茶油
茶碗
茶话会
茶馆
茸毛
荀况
荀子
荆州
荆条
草丛
草创
草包
草叶
草图
草地
草场
草坪
草堂
草履虫
草席
草帽
草房
草拟
草料
草木灰
草本
草案
草棚
草率
草甸
草皮
草稿
草约
草纸
草绳
草绿
草草
草药
草莓
草莽
草虫
草酸
草鞋
草鱼
荐举
荒凉
荒原
荒唐
荒地
荒山
荒年
荒废
荒淫
荒淫无耻
荒漠
荒芜
荒诞
荒谬
荒谬绝伦
荒野
荔枝
荚果
荚膜
荞麦
荡妇
荡平
荡漾
荡荡
荣县
荣幸
荣禄
荣耀
荣获
荣誉
荥阳
荧光
荧光屏
荧光粉
荫棚
荫蔽
药剂
药厂
药品
药害
药房
药方
药材
药水
药物
药物学
药粉
药酒
药铺
荷兰
荷包
荷叶
荷花
荷荷
荷载
荷重
荸荸
莎士比亚
莎车
莫不
莫不是
莫名其妙
莫大
莫奈
莫如
莫尔
莫折大提
莫斯科
莫桑比克
莫过于
莫非
莫须有
莱特
莱茵河
莱辛
莱阳
莲子
莲花
莴莴
获取
获得
获悉
获胜
莽莽
菊花
菌丝
菌丝体
菌株
菌核
菌苗
菌落
菖蒲
菜刀
菜园
菜地
菜场
菜子
菜油
菜籽
菜肴
菜花
菜苔
菜蔬
菜豆
菠菜
菠萝
菩萨
菱形
菱角
菲亚特公司
菲律宾
萃取
萆麻
萌动
萌发
萌生
萌芽林
萍乡
萎缩
萎蔫
萎雕
萝卜
萤石
营业
营业额
营养元素
营养器官
营养状况
营养生长
营养盐
营养繁殖
营利
营口
营地
营垒
营建
营房
营生
营私
营造
营长
萧伯纳
萧太後
萧条
萧红
萧萧
萨利
萨姆
萨尔
萨尔瓦多
萨拉
萨那
萨镇冰
落伍
落体
落叶
落叶松
落后
落地
落实
落差
落得
落成
落户
落日
落水
落水狗
落泪
落点
落着
落矿
落空
落笔
落第
落脚
落花
落花流水
落落
落锤
落雨
著作
著名
著录
著称
著者
著述
葛罗米柯
葡糖
葡萄
葡萄园
葡萄牙
葡萄球菌
葡萄糖
葡萄酒
董事会
董仲舒
董卓
董存瑞
董必武
葫芦
葬礼
葬送
葱头
葱白
葱花
蒋介石
蒙受
蒙古
蒙古人
蒙古族
蒙城
蒙山
蒙族
蒙特
蒙皮
蒙蒙
蒙蔽
蒜泥
蒜苗
蒲殿俊
蒲鲁东
蒴果
蒸发
蒸发器
蒸发皿
蒸发量
蒸呢
蒸汽
蒸汽机
蒸汽机车
蒸笼
蒸腾
蒸腾作用
蒸蒸日上
蒸馏
蒸馏水
蓄意
蓄水
蓄热器
蓄电池
蓄积
蓝图
蓝天
蓝布
蓝本
蓝色
蓝藻
蓝靛
蓬乱
蓬勃
蓬松
蓬蓬
蓬蓬勃勃
蔑视
蔓延
蔗糖
蔗醣
蔚然成风
蔚蓝
蔡元培
蔡文姬
蔬菜
蔷薇
蕴藏
蕾铃
薄利
薄壁
薄弱
薄弱环节
薄板
薄片
薄膜
薄荷
薄薄
薄薄的
薄雾
薛福成
薪水
薪金
藏书
藏医
藏匿
藏历
藏文
藏族
藐视
藩镇
藻类
蘑菇
虎丘
虎口
虎子
虎狼
虎穴
虎虎
虎门
虐待
虔诚
虚伪
虚假
虚名
虚妄
虚实
虚幻
虚弱
虚心
虚报
虚数
虚无
虚无主义
虚构
虚线
虚荣
虫卵
虫子
虫害
虫情
虫胶
虱子
虹口
虹吸
虹吸管
虹鳟
虽则
虽然
虽说
虾子
虾米
蚁蚕
蚂蚁
蚂蚱
蚊子
蚊虫
蚌壳
蚕丝
蚕卵
蚕室
蚕座
蚕桑
蚕种
蚕茧
蚕蛹
蚕蛾
蚕豆
蚕食
蚜虫
蛋壳
蛋清
蛋白胨
蛋白质
蛋白酶
蛋糕
蛋黄
蛔虫
蛟龙
蛤蟆
蛮干
蛮族
蛮横
蜀汉
蜂巢
蜂房
蜂拥
蜂王
蜂窝
蜂窝煤
蜂箱
蜂群
蜂蜜
蜂蜡
蜂起
蜕化
蜕化变质
蜕变
蜕皮
蜘蜘
蜚廉
蜜源
蜜蜂
蜡烛
蜿蜒
蝈蝈
蝗虫
蝴蝶
蝼蛄
蝾蝾
螃蟹
融化
融合
融洽
融解
螺丝
螺丝帽
螺丝钉
螺帽
螺旋
螺旋桨
螺旋线
螺栓
螺母
螺纹
螺线
螺线管
螺距
螺钉
蟹黄
蠕动
血书
血亲
血债
血压
血吸虫
血小板
血循环
血性
血战
血栓
血案
血水
血汗
血泪
血洗
血浆
血海
血液
血清
血球
血管
血红
血红蛋白
血统
血缘
血肉
血脉
血腥
血色
血迹
行不通
行业
行东
行为
行为主义
行为能力
行之有效
行事
行人
行会
行使
行军
行凶
行刑
行列
行列式
行动
行医
行在
行宫
行家
行将
行市
行径
行情
行政
行政区
行政区域
行政处分
行政权
行政法
行政管理
行文
行时
行星
行李
行检
行状
行省
行礼
行程
行程开关
行者
行船
行行
行装
行贿
行走
行走机构
行距
行踪
行车
行进
行道
行部
行销
行间
行驶
衍射
衍生物
衔接
衔铁
街坊
街头
街头巷尾
街市
街心
街道
街门
衙门
衡山
衡量
衡阳
衣冠
衣分
衣料
衣服
衣物
衣着
衣衫
衣裳
衣襟
衣钵
衣食
补习
补偿
补充
补助
补助金
补救
补正
补种
补缺
补色
补角
补课
补贴
补足
补选
表决
表决权
表同情
表土
表土层
表妹
表层
表彰
表态
表情
表报
表明
表格
表演
表演艺术
表演赛
表率
表现
表现型
表现对象
表现形
表白
表皮
表盘
表示
表章
表笔
表表
表观
表象
表达
表述
表里
表针
表露
表面
表面光洁度
表面化
表面张力
表面活性剂
表面积
表面质量
衬垫
衬布
衬托
衬砌
衬衣
衬衫
衬里
衰亡
衰减
衰变
衰弱
衰微
衰竭
衰老
衰落
衰败
衰退
衷心
袁世凯
袁绍
袋子
袍子
袒护
袖口
袖子
袖手旁观
袖珍
袜子
被乘数
被俘
被保险人
被减数
被刺
被剥削
被剥削阶级
被加数
被动
被单
被压迫
被压迫民族
被压迫阶级
被告
被告人
被复
被子
被子植物
被害人
被开方数
被捕
被统治者
被统治阶级
被褥
被覆
被迫
被选举权
被逼
被除数
被面
袭击
袭用
裁军
裁决
裁减
裁判
裁判员
裁剪
裁定
裁成
裁撤
裁缝
裂化
裂变
裂口
裂开
裂片
裂纹
裂缝
裂解
裂解气
裂隙
装修
装卸
装卸桥
装备
装岩机
装扮
装料
装束
装点
装甲
装甲车
装箱
装置
装订
装载
装运
装配
装饰
装饰品
装饰音
裙子
裤子
裤脚
裤腰
裤腿
裸体
裸子植物
裸露
褂子
褐煤
褒贬
褥子
褶皱
襄樊
襄阳
襟翼
西亚
西京
西伯利亚
西北
西北风
西医
西南
西南非洲
西印度群岛
西历
西双版纳
西周
西垂
西城
西域
西夏
西天
西学
西宁
西安
西式
西德
西戎
西撒哈拉
西方
西施
西晋
西服
西欧
西江
西沙群岛
西沟
西法
西洋
西海
西班牙
西皮
西红柿
西药
西蒙
西藏
西藏自治区
西装
西西
西边
西郊
西部
西里
西里西亚
西门
西非
西面
西风
西魏
要不
要不得
要不是
要不然
要么
要义
要事
要人
要件
要公
要冲
要命
要地
要塞
要好
要害
要就
要强
要得
要挟
要是
要求
要点
要犯
要略
要目
要素
要紧
要职
要道
要领
要饭
覆灭
覆盖
见不得
见习
见于
见地
见外
见天
见得
见怪
见效
见方
见笑
见解
见证
见证人
见长
见闻
见面
见鬼
观众
观光
观察
观察员
观察家
观察所
观念
观念形态
观感
观摩
观望
观测
观点
观看
观象台
观赏
观音
规划
规则
规定
规定性
规律
规律性
规格
规格化
规模
规矩
规程
规章
规章制度
规约
规范
规范化
规规矩矩
规避
视力
视听
视唱
视图
视在功率
视察
视死如归
视界
视线
视网膜
视而不见
视觉
视角
视野
视频
觉察
觉得
觉悟
觉醒
角加速度
角尺
角度
角果
角球
角落
角质
角质层
角速度
角钢
角频率
解人
解体
解决
解决问题
解冻
解剖
解剖学
解吸
解围
解差
解开
解放
解放军
解放军报
解放前
解放区
解放思想
解放战争
解放日报
解救
解析几何
解毒
解答
解职
解脱
解说
解调
解释
解除
解雇
触动
触及
触发
触发器
触媒
触手
触犯
触电
触目惊心
触礁
触觉
触角
言和
言者
言行
言行一致
言论
言词
言谈
言辞
詹大悲
誓师
誓师大会
誓死
誓言
誓词
警卫
警句
警告
警备
警备区
警察
警惕
警戒
警报
警觉
警钟
譬喻
譬如
计件
计件工资
计划
计划性
计划生育
计划经济
计数
计数器
计时工资
计算
计算中心
计算尺
计算所
计算机
计议
计谋
计较
计酬
计量
订正
订立
订货
订购
订阅
认为
认作
认出
认可
认字
认定
认得
认清
认真
认罪
认证
认识
认识论
认购
认错
认领
讥笑
讥讽
讨伐
讨厌
讨好
讨论
讨论会
讨饭
让与
让位
让位于
让开
让步
让给
训令
训导
训政时期
训斥
训练
训练班
训诂
训话
议事
议价
议会
议会制
议会斗争
议决
议和
议定
议定书
议席
议案
议程
议论
议长
议院
议题
讯问
记事
记住
记分
记取
记号
记名
记工
记帐
记录
记得
记忆
记忆力
记念
记性
记者
记谱
记载
记述
讲义
讲习
讲价
讲台
讲史
讲和
讲坛
讲堂
讲学
讲师
讲席
讲座
讲授
讲武
讲求
讲法
讲演
讲理
讲究
讲解
讲话
讲课
讲述
讴歌
许乃济
许久
许可
许可证
许多
许昌
许诺
讹诈
论争
论价
论列
论坛
论坛报
论处
论战
论据
论文
论断
论点
论理
论著
论衡
论证
论语
论说
论调
论述
讽刺
设使
设备
设备利用率
设宴
设想
设施
设法
设立
设置
设计
设计阶段
设防
访问
证书
证人
证件
证券
证实
证据
证明
证明书
证物
证词
诃子
评介
评价
评分
评判
评剧
评定
评工
评比
评议
评论
评论员
评论家
评话
评语
评选
诅咒
识别
识字
识字班
识破
识记
诈骗
诉状
诉苦
诉讼
诉讼法
诉说
诊断
诊治
诊疗
诋毁
词人
词儿
词典
词句
词曲
词汇
词章
诏书
诏令
译文
译本
译电
译码
译码器
译者
译音
试件
试制
试剂
试办
试卷
试图
试想
试探
试样
试点
试用
试看
试种
试管
试纸
试航
试行
试试看
试车
试问
试题
试飞
试验
试验田
诗书
诗人
诗句
诗史
诗学
诗意
诗歌
诗篇
诗经
诗话
诗集
诙谐
诚实
诚心
诚恳
诚意
诚挚
诚然
话剧
话头
话本
话筒
话语
话说
话音
话题
诞生
诞辰
诡称
诡计
诡诈
诡辩
询问
该帐
该当
该死
详图
详尽
详悉
详情
详细
诧异
诨号
诬告
诬蔑
诬陷
语体文
语句
语录
语文
语气
语汇
语法
语言
语言学
语调
语音
误会
误工
误差
误解
诱发
诱导
诱惑
诱杀
诱降
诱饵
诱骗
说不上
说不定
说不清
说书
说和
说唱
说好
说定
说情
说教
说明
说明书
说服
说法
说理
说破
说穿
说笑
说话
说谎
说道
说部
诵读
请假
请坐
请安
请愿
请愿书
请教
请求
请示
请老
请问
诸位
诸侯
诸公
诸君
诸城
诸夏
诸如
诸如此类
诸子
诸子百家
诸生
诸葛
诸葛亮
诺思
诺言
读书
读书人
读图
读报
读数
读物
读经
读者
诽谤
课余
课堂
课外
课文
课时
课本
课田制
课程
课税
课题
谁个
调任
调停
调制
调剂
调动
调匀
调号
调味
调和
调回
调处
调子
调幅
调度
调式
调性
调拨
调换
调整
调整器
调料
调查
调查研究
调用
调皮
调相
调羹
调色
调节
调节器
调解
调试
调谐
调质
调车
调运
调速器
调遣
调配
调集
调音
调频
谅解
谆谆
谈不到
谈判
谈到
谈吐
谈天
谈心
谈论
谈话
谋反
谋取
谋害
谋杀
谋求
谋生
谋略
谎报
谎言
谎话
谐和
谐振
谐振动
谐波
谒见
谕旨
谘文
谘议局
谘询
谚语
谛听
谢家
谢意
谢玄
谢绝
谢谢
谣言
谦虚
谦虚谨慎
谦让
谦逊
谨严
谨慎
谩骂
谬论
谬误
谭人凤
谭嗣同
谱写
谱号
谱子
谱表
谴责
谷仓
谷城
谷子
谷氨酸
谷类作物
谷草
谷象
谷雨
豁免
豆子
豆沙
豆油
豆浆
豆渣
豆科
豆粒
豆腐
豆腐乳
豆腐皮
豆苗
豆象
豆饼
豇豆
豌豆
豚鼠
象人
象山
象形
象征
象样
象棋
象牙
象牙海岸
象生
象管
象限
豢养
豪华
豪右
豪富
豪强
豪情
豪放
豪杰
豪猪
豪绅
豪迈
豪门
豫州
豹子
豺狼
貂皮
貌似
贝克
贝克勒耳
贝勒
贝壳
贝多芬
贝尔
贝尔格莱德
贝拉
贝类
贝西
贝鲁特
贞观
负伤
负债
负反馈
负号
负担
负数
负极
负片
负电
负电荷
负离子
负荷
负责
负载
负重
负隅顽抗
贡品
贡献
财主
财产
财产关系
财产权
财产清查
财产税
财力
财务
财团
财宝
财富
财政
财政危机
财政年度
财政资金
财政部
财权
财源
财物
财用
财神
财经
财货
财贸
财阀
责令
责任
责任事故
责任内阁
责任制
责任心
责任感
责备
责怪
责成
责问
责难
责骂
贤人
贤能
败亡
败仗
败坏
败类
败诉
败退
账篷
货主
货品
货币
货币流通
货币资本
货币资金
货栈
货款
货源
货物
货物运输保险
货箱
货船
货色
货车
货轮
货运
质体
质变
质和量
质因数
质地
质子
质感
质成
质数
质料
质朴
质点
质的
质要
质量
质量指标
质量数
质量检验
质量比
质量管理
质问
贩卖
贩子
贩运
贪图
贪婪
贪得无厌
贪欲
贪污
贪污受贿
贪赃
贫下中农
贫乏
贫农
贫化
贫困
贫困化
贫寒
贫弱
贫民
贫民窟
贫油
贫瘠
贫矿
贫穷
贫苦
贫贱
贬低
贬值
购买
购买力
购得
购置
购销
购销差价
贮备
贮存
贮木场
贮藏
贯串
贯彻
贯彻执行
贯注
贯穿
贯通
贱人
贴心
贴现
贴补
贴近
贵人
贵国
贵妃
贵宾
贵州
贵州省
贵族
贵族政治
贵贱
贵重
贵金属
贵阳
贷方
贷款
贸易
贸然
费事
费力
费劲
费尔
费尔巴哈
费尽
费工
费心
费时
贺信
贺兰
贺喜
贺电
贻误
贾后
贾宝玉
贾思勰
贾谊
贿赂
赃物
资产
资产负债表
资产阶级
资产阶级专政
资产阶级权利
资产阶级民主
资产阶级法权
资产阶级革命
资力
资助
资历
资政
资政院
资料
资本
资本主义
资本主义制度
资本主义国家
资本主义地租
资本主义社会
资本周转
资本家
资本帝国主义
资本循环
资本有机构成
资本的周转
资本积累
资本论
资本输出
资本集中
资格
资金
资金占用
资金平衡表
资金来源
资金运用
赈济
赋役
赋税
赌博
赌咒
赌气
赎买
赏罚
赏识
赏赐
赐予
赔偿
赔款
赔礼
赖氨酸
赖汉英
赘述
赛力散
赛跑
赛过
赛马
赞助
赞叹
赞同
赞成
赞歌
赞美
赞誉
赞许
赞赏
赞颂
赠与
赠送
赡养
赢利
赢得
赣州
赤卫军
赤卫队
赤壁
赤手空拳
赤杨
赤松
赤眉
赤脚
赤脚医生
赤裸裸
赤诚
赤贫
赤道
赤道几内亚
赤铁矿
赤霉素
赦免
赫兹
赫尔
赫尔辛基
赫斯
赫然
赫赫
赫鲁晓夫
走动
走卒
走后门
走向
走廊
走开
走投无路
走散
走时
走样
走步
走狗
走私
走访
走资派
走路
走边
走运
走道
走马
赴任
赵匡胤
赵声
赵家
赵庄
赵树理
赶上
赶不上
赶任务
赶回
赶场
赶忙
赶快
赶紧
赶走
赶超
赶跑
赶路
赶车
赶集
起义
起事
起伏
起先
起初
起动
起动机
起动转矩
起劲
起吊
起因
起复
起头
起始
起子
起家
起居
起床
起开
起早贪黑
起来
起步
起毛
起泡
起火
起点
起爆
起用
起码
起程
起稿
起立
起笔
起网
起色
起草
起落
起见
起誓
起诉
起诉书
起跑
起跑器
起跳
起身
起运
起重机
起重船
起飞
趁势
趁早
趁机
超产
超人
超再生
超出
超前
超声波
超外差
超外差式收音机
超导
超支
超然
超短波
超级
超级大国
超脱
超自然
超计划利润
超载
超过
超重
超阶级
超音速
超音速飞行
超额
超额利润
超高压
超高频
越位
越冬
越剧
越南人
越发
越权
越狱
越过
越野
趋势
趋向
趣味
足下
足以
足够
足球
足见
足足
足迹
足额
跃迁
跃进
跋山涉水
跋涉
跌价
跌倒
跌落
跑垒
跑开
跑步
跑腿
跑车
跑遍
跑道
跑马
距离
跟上
跟前
跟头
跟班
跟着
跟踪
跟进
跟随
跨国公司
跨度
跨栏
跨越
跨过
跪下
跪倒
路上
路人
路北
路口
路基
路子
路局
路径
路德
路数
路易
路易斯
路段
路灯
路矿
路程
路端电压
路签
路线
路线斗争
路费
路过
路透社
路途
路面
跳伞
跳伞运动
跳动
跳台
跳板
跳水
跳汰机
跳箱
跳绳
跳舞
跳远
跳马
跳高
践踏
跺脚
踉跄
踊跃
踌躇
踏勘
踏实
踏板
踏步
踏踏
踏踏实实
踪影
踪迹
踯躅
蹄子
蹲点
身上
身世
身价
身份
身体
身体力行
身分
身受
身后
身子
身家
身影
身心
身材
身段
身躯
身边
身量
身长
躯体
躯干
躲开
躲藏
躲避
躲闪
躺椅
车体
车刀
车前
车夫
车头
车子
车尔尼雪夫斯基
车工
车床
车把
车流
车灯
车皮
车票
车站
车箱
车船
车身
车轮
车轴
车辆
车速
车道
车里
车钩
车门
车间
车间成本
车间经费
车队
车驾
轧件
轧光
轧制
轧机
轧辊
轧钢
轧钢机
轨距
轨迹
轨道
转业
转为
转交
转入
转动
转动惯量
转化
转发
转变
转台
转向
转向器
转向架
转向离合器
转告
转嫁
转子
转差率
转帐
转弯
转录
转念
转战
转折
转折点
转换
转换开关
转播
转机
转正
转炉
转盘
转眼
转瞬
转移
转而
转脸
转角
转让
转调
转身
转轴
转载
转达
转运
转送
转速
轮作
轮回
轮子
轮对
轮带
轮廓
轮式拖拉机
轮换
轮机
轮毂
轮流
轮班
轮番
轮盘
轮胎
轮船
轮虫
轮训
轮转
轮轴
轮齿
软件
软体动物
软化
软弱
软弱性
软木
软木塞
软水
软硬兼施
软管
软脂酸
软腭
软膏
软骨
软骨病
软骨鱼类
轰击
轰动
轰炸
轰炸机
轰轰烈烈
轰隆
轰鸣
轱辘
轴功率
轴套
轴孔
轴对称
轴心
轴承
轴承合金
轴流泵
轴瓦
轴箱
轴线
轴衬
轴距
轻伤
轻便
轻信
轻型
轻声
轻工业
轻巧
轻微
轻快
轻描淡写
轻放
轻易
轻松
轻柔
轻浮
轻率
轻盈
轻罪
轻而易举
轻蔑
轻薄
轻视
轻轻
轻轻的
轻重
轻重缓急
轻金属
轻骑
载体
载客
载沣
载波
载波通信
载流子
载热剂
载荷
载记
载货
载运
载重
载重汽车
载频
轿夫
轿子
轿车
较为
较量
辅佐
辅助
辅助材料
辅助生产
辅导
辅导员
辈出
辈分
辈子
辉映
辉煌
辊子
辎重
辐射
辐射热
辐射能
辑录
输入
输入阻抗
输出
输出变压器
输出阻抗
输卵管
输尿管
输油泵
输油管
输电
输精管
输血
输送
辖区
辗转
辘轳
辛丑
辛亥革命
辛劳
辛勤
辛烷值
辛苦
辛辛苦苦
辛辣
辛迪加
辛酉
辛酸
辜负
辞典
辞职
辞行
辞退
辣椒
辨别
辨认
辨证法
辩护
辩护人
辩护士
辩护权
辩解
辩论
辩证
辩证唯物主义
辩驳
辫子
辰光
辰砂
辱骂
边儿
边区
边地
边境
边寨
边带
边材
边框
边民
边沿
边界
边界层
边界问题
边疆
边线
边缘
边角料
边远
边远地区
边锋
边防
边际
边陲
辽东
辽东半岛
辽宁
辽河
辽西
辽阔
辽阳
达人
达到
达卡
达喀尔
达因
达官
达尔文
达意
达成
达旦
达生
达赖
达赖喇嘛
达达
迁入
迁就
迁居
迁徙
迁移
迁西
迁都
迂回
迄今
迅猛
迅速
过不去
过于
过人
过共析钢
过关
过冬
过冷
过分
过剩
过剩人口
过半
过半数
过去
过去了
过后
过场
过境
过夜
过天
过失
过头
过少
过年
过度
过当
过往
过得去
过心
过急
过意不去
过所
过手
过敏
过数
过日子
过时
过期
过来
过桥
过氧化氢
过氧化物
过活
过渡
过渡形式
过渡时期
过渡时期总路线
过滤
过滤机
过激
过火
过热器
过甚
过电压
过目
过硬
过磷酸钙
过秤
过程
过筛
过细
过继
过节
过话
过路
过载
过道
过重
过量
过错
过门
过问
过饱和
迈步
迈进
迎击
迎刃而解
迎合
迎头
迎头痛击
迎接
迎新
迎春
迎角
迎送
迎面
迎风
运会
运动
运动会
运动健将
运动员
运动场
运动竞赛
运单
运气
运河
运球
运用
运用于
运筹学
运算
运算器
运营
运行
运费
运转
运载
运载火箭
运输
运输成本
运输机
运输系统
运输线
运输能力
运输量
运送
运道
运销
近世
近东
近乎
近亲
近人
近代
近似
近似值
近似商
近似计算
近几年来
近前
近地点
近年来
近旁
近日
近来
近海
近视
近邻
近郊
返回
返工
返潮
返盐
返航
返青
还乡
还乡团
还债
还击
还原
还原剂
还原染料
还原熔炼
还好
还是
还有
还本
还清
还要
这个
这么
这么些
这么着
这些
这会儿
这儿
这就是说
这时候
这样
这点
这种
这般
这边
这里
进修
进入
进兵
进军
进出
进出口贸易
进击
进刀
进化
进化论
进占
进去
进发
进取
进口
进场
进士
进学
进尺
进展
进度
进德
进攻
进来
进步
进步事业
进步人士
进步力量
进水
进深
进犯
进程
进给量
进而
进行
进行曲
进贡
进货
进退
进逼
进食
进驻
远东
远古
远在
远地点
远大
远征
远房
远方
远景
远望
远洋
远洋运输
远程
远航
远见
远近
远远的
远道
远郊
远销
远隔
远非
违例
违反
违宪
违抗
违法
违法乱纪
违法行为
违犯
违章
违背
连乘
连云港
连任
连作
连写
连发
连同
连坐
连声
连夜
连天
连带
连年
连心
连忙
连打
连接
连日
连杆
连杆机构
连环
连环画
连用
连皮
连篇
连累
连续
连续光谱
连续函数
连续生产
连绵
连贯
连载
连连
连通
连通器
连锁
连锁反应
连长
连队
连音
迟到
迟延
迟早
迟滞
迟疑
迟缓
迟迟
迟钝
迥然不同
迫不及待
迫使
迫切
迫在眉睫
迫害
迫近
迭起
述异记
述评
述说
迷人
迷信
迷失
迷恋
迷惑
迷梦
迷漫
迷离
迷糊
迷途
迸发
迹地
迹象
追击
追加
追回
追寻
追忆
追悼
追捕
追查
追求
追溯
追究
追肥
追诉
追赃
追赶
追踪
追述
追逐
追问
追随
退伍军人
退休
退位
退兵
退出
退化
退却
退回
退守
退步
退浆
退火
退缩
退职
退让
退还
送交
送信
送入
送别
送客
送死
送礼
送经
送葬
送行
送货
送还
送风
适中
适于
适口
适合
适宜
适应
适应性
适度
适当
适时
适用
适量
适龄
逃亡
逃兵
逃命
逃窜
逃脱
逃荒
逃走
逃跑
逃逸
逃避
逃难
逆光
逆命
逆定理
逆差
逆流
逆转
逆运算
逆风
选举
选举制
选举制度
选举委员会
选举权
选举法
选举资格
选任
选修
选区
选取
选定
选录
选手
选拔
选拔赛
选择
选择性
选本
选民
选派
选煤
选矿
选票
选种
选育
选言判断
选言肢
选读
选购
选辑
选送
选配
选集
逊色
逍遥
透亮
透光伐
透射
透平
透彻
透支
透明
透明度
透气
透水
透水性
透视
透视图
透过
透镜
透露
透顶
透风
逐一
逐个
逐出
逐年
逐日
逐月
逐条
逐次
逐步
逐渐
递交
递减
递增
递送
途中
途径
途程
逗号
逗点
逗留
通书
通人
通令
通例
通俗
通俗读物
通信
通信卫星
通信员
通信线路
通典
通分
通则
通力合作
通化
通县
通史
通同
通告
通商
通国
通天
通婚
通宝
通宵
通州
通常
通式
通往
通志
通报
通明
通晓
通气
通用
通用电气公司
通电
通畅
通病
通盘
通知
通知书
通称
通红
通缉
通考
通航
通融
通行
通行证
通讯
通讯员
通讯社
通译
通话
通货
通货膨胀
通路
通车
通达
通过
通通
通道
通邮
通量
通风
通风机
逝世
逞能
速写
速度
速成
速效
速效性
速比
速溶茶
速率
造价
造作
造化
造反
造型
造型机
造型艺术
造就
造成
造林
造渣
造物
造物主
造田
造纸
造纸厂
造船
造船厂
造诣
造谣
逢年过节
逮捕
逸出功
逻各斯
逻辑
逻辑学
逻辑思维
逼人
逼供
逼死
逼真
逼近
逼迫
逾期
逾越
遇事
遇到
遇刺
遇害
遇见
遇难
遍地
遍布
遍野
遏制
道上
道义
道人
道光
道光帝
道具
道口
道员
道地
道士
道夫
道学
道家
道岔
道德
道德哲学
道德感
道德规范
道情
道教
道歉
道理
道谢
道路
道道
道钉
道门
遗书
遗产
遗传
遗传信息
遗传学
遗传工程
遗传性
遗传物质
遗体
遗像
遗嘱
遗址
遗失
遗容
遗弃
遗志
遗忘
遗恨
遗愿
遗憾
遗教
遗民
遗漏
遗物
遗留
遗老
遗著
遗迹
遗骸
遣散
遣返
遣送
遥控
遥测
遥远
遥遥
遭到
遭受
遭殃
遮住
遮光
遮挡
遮掩
遮断
遮盖
遮目鱼
遮荫
遮蔽
遵义
遵义会议
遵从
遵化
遵命
遵守
遵循
遵照
遵行
避乱
避免
避孕
避孕药
避实击虚
避开
避暑
避暑山庄
避难
避雷线
避雷针
避风
邀功
邀约
邀请
邀请赛
邀集
邓中夏
邓子恢
邓尼金
邓茂七
邢台
那个
那么
那些
那儿
那咱
那时
那时候
那样
那种
那般
那边
那里
邦交
邦本
邦联
邪恶
邪气
邪说
邪路
邮件
邮传部
邮寄
邮局
邮政
邮政编码
邮电
邮票
邮递
邯郸
邵武
邵阳
邹容
邻居
邻接
邻近
邻邦
邻里
郁郁
郁闭
郁闭度
郊区
郊外
郑克爽
郑和
郑国
郑孝胥
郑州
郑成功
郑经
郑观应
郑重
郑重其事
郝摇旗
郡县制
部下
部件
部位
部分
部发
部委
部属
部族
部类
部署
部落
部长
部长会议
部门
部队
部颁
郫县
郭沫若
郭象
郴州
都城
都察院
都尉
都市
都指挥使
都是
都江堰
都督
都统
鄂伦春
鄙人
鄙夷
鄙意
鄙视
鄱阳
酋长
酋长国
酌情
酌量
配件
配偶
配制
配制饲料
配合
配器
配备
配套
配子
配对
配料
配方
配电
配电盘
配种
配第
配置
配色
酒会
酒厂
酒器
酒家
酒席
酒杯
酒石酸
酒窝
酒精
酒糟
酒花
酒药
酒菜
酚酞
酚醛
酚醛塑料
酚醛树脂
酝酿
酣睡
酥油
酥脆
酪氨酸
酪酸
酬谢
酬金
酯化
酱油
酱菜
酵母
酵母菌
酵素
酵解
酷刑
酷暑
酷热
酸化
酸处理
酸度
酸式盐
酸性
酸根
酸洗
酸痛
酸败
酸辣汤
酸酐
酿造
酿酒
醇厚
醉心
醋酸
醒悟
醒目
醣化
醣厂
醣尿病
醣果
醣槭
醣水
醣浆
醣类
醣精
醣蜜
醣衣
醣醋
采买
采伐
采光
采制
采办
采区
采取
采掘
采摘
采暖
采样
采油
采珠
采用
采矿
采矿工业
采矿方法
采种
采空区
采纳
采访
采购
采购供应站
采邑
采集
釉陶
释放
释文
里人
里加
里头
里屋
里带
里应外合
里弦
里拉
里斯
里昂
里海
里程
里程碑
里约热内卢
里脊
里边
里里外外
里间
里面
重人
重任
重修
重兵
重力
重力加速度
重力势能
重力场
重印
重叠
重合
重商主义
重围
重地
重型
重复
重大
重婚
重工业
重庆
重建
重心
重担
重整旗鼓
重新
重晶石
重氮化
重水
重油
重洋
重活
重温
重演
重炮
重点
重版
重物
重现
重用
重申
重病
重臂
重要
重要性
重视
重负
重载
重返
重逢
重重
重量
重量单
重金属
重镇
重音
野人
野兔
野兽
野叟曝言
野外
野心
野心勃勃
野心家
野战
野火
野生
野花
野菜
野营
野蛮
野马
野鸡
野鸭
量具
量刑
量力而行
量变
量器
量子
量子力学
量度
量热器
量程
量筒
量纲
量规
量角器
金不换
金东
金仲华
金元
金光
金刚
金刚石
金华
金和
金声
金子
金字塔
金宝
金属
金属丝
金属主义
金属元素
金属光泽
金属型铸造
金属材料
金属模
金属矿床
金属腐蚀
金属货币
金属键
金山
金工
金币
金库
金文
金斗
金日成
金星
金水
金沙
金沙江
金沙萨
金珠
金田起义
金相
金石
金矿
金色
金融
金融寡头
金融市场
金融资本
金边
金钱
金陵
金额
金鱼
金鸡
金黄
金龙
金龟子
鉴定
鉴真
鉴赏
鉴频
鉴频器
錾子
针刺麻醉
针叶林
针叶树
针头
针对
针尖
针布
针梳机
针法
针灸
针线
针织品
针锋相对
钉子
钎子
钙化
钙镁磷肥
钛酸钡
钝角
钞票
钟关
钟声
钟头
钟山
钟摆
钟楼
钟点
钟相
钟表
钟鼓
钢丝
钢丝圈
钢丝绳
钢刀
钢号
钢坯
钢材
钢板
钢梁
钢水
钢珠
钢琴
钢种
钢笔
钢筋
钢筋混凝土
钢筘
钢箍
钢管
钢结构
钢轨
钢钎
钢铁
钢锭
钢领
钥匙
钦佩
钦州
钦差大臣
钩子
钱塘江
钱币
钱庄
钱粮
钱财
钳制
钳子
钳工
钻井
钻头
钻床
钻心虫
钻探
钻机
钻杆
钻石
钻研
钻营
钾盐
钾肥
铁丝
铁丝网
铁人
铁匠
铁厂
铁合金
铁塔
铁屑
铁工
铁心
铁打
铁板
铁树
铁桶
铁氧体
铁水
铁牛
铁甲
铁甲车
铁皮
铁盐
铁矿
铁砧
铁磁性
铁管
铁良
铁证
铁路
铁轨
铁道
铁道兵
铁链
铁锈
铁锨
铁锹
铁门
铁青
铁饼
铃铛
铅中毒
铅垂线
铅山
铅球
铅矿
铅笔
铅粉
铍青铜
铜丝
铜厂
铜器
铜板
铜钱
铝土矿
铝箔
铡刀
铣刀
铣床
铬钢
铭文
铭牌
铭记
铰刀
铰接
铰链
铲平
铲除
铵盐
银两
银器
银团
银子
银川
银币
银幕
银杏
银桦
银河系
银灰
银牌
银白
银矿
银粒
银耳
银行
银行信用
银行券
银行资本
银钱
铸件
铸型
铸工
铸币
铸成
铸造
铸钢
铸铁
铸锭
铺垫
铺子
铺平
铺张浪费
铺盖
铺轨
链传动
链子
链式反应
链条
链球
链球菌
链轮
铿锵
销售
销售量
销售额
销子
销毁
销路
销钉
锁链
锁骨
锄头
锅台
锅底
锅炉
锅盖
锈病
锉刀
锋利
锋芒
锋面
锌版
锐利
锐气
锐角
锐角三角形
错乱
错位
错开
错杂
错案
错综
错综复杂
错落
错觉
错误
错过
锚喷支护
锚固
锡林
锡矿
锣鼓
锤子
锤炼
锥体
锥子
锥度
锥形
锥面
锦州
锦旗
锦标赛
锦纶
锦衣卫
锭子
键槽
键盘
锯床
锯条
锯齿
锰钢
锰铁
锻件
锻压
锻工
锻模
锻炉
锻炼
锻造
锻锤
镀银
镀锌
镁合金
镁砂
镁砖
镇压
镇反
镇子
镇守
镇定
镇江
镇流器
镇海
镇长
镇静
镇静钢
镊子
镗孔
镗床
镜头
镜子
镜框
镜片
镢头
镣铐
镯子
镰刀
镶嵌
长上
长丝
长久
长乐
长于
长信
长势
长发
长叹
长圆
长城
长处
长夜
长大
长子
长存
长孙
长宁
长安
长安街
长官
长寿
长工
长年
长度
长征
长方
长方体
长方形
长春
长期
长期共存
长枪
长毛
长毛绒
长江
长江三峡
长江三角洲
长沙
长河
长治
长波
长海
长生
长白
长白山
长相
长短
长石
长篇小说
长编
长老
长者
长虫
长虹
长衫
长袍
长裤
长诗
长跑
长距离
长辈
长辛店
长进
长远
长远利益
长途
长途电话
长长的
长顺
长驱
长驱直入
门下
门人
门儿
门口
门市部
门帘
门径
门徒
门户
门房
门捷列夫
门斗
门板
门框
门楼
门槛
门牌
门生
门电路
门类
门缝
门罗
门诊
门路
门道
门阀
门限
门面
门齿
闪光
闪击
闪动
闪开
闪点
闪烁
闪电
闪耀
闪过
闪锌矿
闪闪
闭会
闭关
闭关政策
闭关自守
闭合
闭合电路
闭塞
闭幕
问世
问候
问号
问好
问答
问荆
问题
闯将
闯王
闲事
闲人
闲散
闲置
闲话
闲谈
间作
间或
间接
间断
间歇
间苗
间谍
间隔
间隙
闵妃
闵采尔
闷气
闷热
闷葫芦
闸北
闸板
闸瓦
闸门
闸阀
闹事
闹市
闹翻
闹钟
闹革命
闹鬼
闺女
闻名
闻见
闻讯
闻风
闽侯
闽江
阀门
阁下
阁楼
阅兵
阅历
阅览室
阅读
阉割
阎王
阎锡山
阐发
阐明
阐述
阔叶林
阔叶树
阔气
队伍
队列
队形
队部
队长
阡陌
阮大铖
防修
防军
防冻
防务
防区
防卫
防卫厅
防备
防守
防尘
防护
防护林
防旱
防染印花
防止
防毒
防毒面具
防水
防汛
防治
防治效果
防洪
防涝
防潮
防火
防疫
防空
防线
防腐
防腐剂
防范
防锈
防震
防风
阳光
阳台
阳性
阳朔
阳极
阳极泥
阴云
阴凉
阴历
阴囊
阴天
阴山
阴干
阴影
阴性
阴暗
阴极
阴森
阴沉
阴离子
阴茎
阴谋
阴谋家
阴谋诡计
阴道
阴郁
阴阳
阴险
阴雨
阵亡
阵势
阵地
阵容
阵线
阵营
阵雨
阵风
阶层
阶梯
阶段
阶级
阶级分化
阶级分析
阶级友爱
阶级性
阶级意识
阶级斗争
阶级斗争熄灭论
阶级本质
阶级矛盾
阶级社会
阶级立场
阶级观点
阶级觉悟
阶级路线
阻值
阻击
阻力
阻尼
阻抗
阻抗匹配
阻拦
阻挠
阻挡
阻挡层
阻止
阻滞
阻碍
阻隔
阿克苏
阿姨
阿宝
阿富汗
阿尔卑斯山脉
阿尔及利亚
阿尔及尔
阿尔巴尼亚
阿尔泰山
阿布扎比
阿扎尼亚
阿拉伯人
阿拉伯半岛
阿拉法特
阿斯特
阿明
阿曼
阿根廷
阿毛
阿爸
阿里
附上
附件
附会
附加
附加税
附和
附图
附属
附属国
附带
附庸
附录
附点
附着
附睾
附设
附近
陆丰
陆九渊
陆军
陆地
陆地棉
陆征祥
陆游
陆续
陆荣廷
陆贾
陆路
陆陆
陈作新
陈其美
陈列
陈圆圆
陈天华
陈奂
陈寿
陈州
陈平
陈旧
陈毅
陈炯明
陈炽
陈独秀
陈玉成
陈留
陈硕真
陈立
陈群
陈胜
陈腐
陈规
陈设
陈述
陈迹
陈醋
陌生
降下
降临
降价
降低
降压
降号
降服
降水
降水量
降温
降生
降落
降落伞
降解
降雨
降雨量
限令
限位
限制
限制性
限定
限度
限期
限止
限界
限量
限额
陕西
陕西省
陛下
陡坡
陡峭
陡然
院士
院子
院落
院长
除了
除伐
除名
除夕
除外
除尘
除开
除数
除此之外
除法
除草
除草剂
除莠剂
除非
险些
险峻
险恶
险情
险滩
险要
险阻
陪伴
陪同
陪审
陪审员
陪衬
陵园
陵墓
陵寝
陶冶
陶器
陶土
陶工
陶瓷
陶醉
陷入
陷害
陷落
陷阱
隆起
隆重
隆隆
隋书
隋炀帝
随从
随便
随即
随口
随同
随后
随员
随地
随声附和
随处
随心所欲
随意
随手
随时
随时随地
随机
随机应变
随着
随行人员
随身
随随便便
随风
隐伏
隐匿
隐士
隐居
隐性
隐患
隐瞒
隐约
隐蔽
隐藏
隐隐
隐隐约约
隔墙
隔壁
隔开
隔断
隔板
隔热
隔离
隔绝
隔膜
隔距
隔阂
隔音
障碍
障碍物
隧道
隶农
隶属
难为
难为情
难事
难于
难产
难以
难保
难免
难关
难受
难听
难堪
难处
难度
难得
难忘
难怪
难找
难民
难点
难看
难能可贵
难说
难过
难道
难闻
难题
雀儿山
雄伟
雄健
雄厚
雄壮
雄心
雄心壮志
雄性不育
雄花
雄蕊
雄蜂
雄赳赳
雄辩
雄鸡
雅人
雅克萨
雅典
雅加达
雅各宾派
雅安
雅尔塔
雅温得
雅致
雅集
雅鲁藏布江
集中
集中反映
集中营
集会
集体
集体主义
集体农庄
集体利益
集体化
集体所有制
集体福利
集体经济
集体领导
集合
集团
集团军
集大成
集子
集尘
集市
集成电路
集权
集材
集水
集注
集电极
集约
集结
集群
集聚
集训
集贤
集资
集镇
雇主
雇佣
雇农
雇员
雇工
雌性
雌花
雌蕊
雌雄
雌雄异株
雍正
雏形
雕刻
雕塑
雕琢
雨伞
雨天
雨季
雨水
雨点
雨衣
雨量
雨量器
雨雪
雨露
雪亮
雪原
雪山
雪崩
雪片
雪白
雪花
雪茄
雪里红
零乱
零件
零件图
零售
零售价格
零度
零散
零时
零星
零点
零用
零碎
零落
雷击
雷利
雷动
雷同
雷声
雷峰塔
雷州半岛
雷电
雷管
雷诺
雷诺数
雷达
雷锋
雷阵雨
雷雨
雷雨云
雷霆
雷鸣
雾化器
雾气
雾滴
需求
需要
震动
震惊
震撼
震荡
霉烂
霉菌
霍乱
霍尔
霍山
霍布斯
霍布森
霍查
霍桑
霜冻
霜期
霜降
霜霉病
霞光
露出
露天
露天开采
露天矿
露头
露水
露水河
露点
露珠
露白
露骨
霸主
霸占
霸权
霸权主义
霸王
霸道
霹雳
青天
青少年
青山
青岛
青州
青工
青年
青年人
青春
青春期
青松
青梅
青海
青灰
青瓷
青稞
青粗饲料
青紫
青绿
青翠
青花
青苗
青草
青菜
青蛙
青豆
青贮
青贮窖
青贮饲料
青铜
青铜器
青霉素
青饲料
青鱼
青黄不接
青龙
静候
静力学
静压
静寂
静平衡
静态
静悄悄
静摩擦力
静止
静电
静电力
静电感应
静穆
静脉
静脉血
静观
静配合
静静
静静的
静默
靛蓝
非人
非但
非党员
非凡
非婚生子女
非子
非对抗性
非常
非得
非我
非正式
非法
非法行为
非洲
非洲之角
非洲统一组织
非特
非独
非生产性
非电解质
非礼
非笑
非线性元件
非线性失真
非议
非金属
非金属元素
非难
靠不住
靠山
靠岸
靠得住
靠拢
靠背
靠边
靠近
面临
面交
面具
面前
面团
面墙
面子
面孔
面容
面对
面对面
面条
面目
面相
面积
面积分
面筋
面粉
面色
面谈
面貌
面部
面食
革命
革命军
革命军人
革命化
革命发展阶段论
革命委员会
革命家
革命干劲
革命性
革命意志
革命战争
革命报
革命文学
革命斗志
革命残废军人
革命烈士
革命烈火
革命现实主义
革命知识分子
革命积极性
革命英雄主义
革委会
革左五营
革新
革职
革除
靴子
鞋子
鞋底
鞍山
鞍钢宪法
鞍马
鞑鞑
鞘翅
鞠躬
鞣质
鞭子
鞭打
鞭挞
鞭毛
鞭炮
鞭策
鞴鞴
韧带
韧性
韧皮部
韩村
韭菜
韭黄
音位
音信
音准
音分
音区
音叉
音名
音和
音响
音型
音域
音律
音标
音波
音程
音符
音色
音节
音讯
音调
音质
音速
音量
音阶
音频
音高
韵律
韵母
韶关
韶山
页岩
顶事
顶住
顶叶
顶吹
顶多
顶天立地
顶头
顶尖
顶峰
顶撞
顶替
顶板
顶棚
顶点
顶球
顶用
顶端
顶芽
顶角
顶针
顶风
顷刻
项城
项目
项羽
项链
顺丁橡胶
顺从
顺便
顺利
顺势
顺口
顺天
顺序
顺应
顺德
顺手
顺次
顺水
顺治
顺畅
顺眼
顺着
顺路
顺风
须发
须根
须知
须要
顽固
顽强
顽抗
顽皮
顾不上
顾不得
顾全
顾全大局
顾及
顾名思义
顾客
顾忌
顾恺之
顾此失彼
顾炎武
顾虑
顾问
顿巴斯
顿挫
顿时
顿河
顿音
顿首
颁发
颁布
颁行
颂扬
颂歌
预付
预付资本
预兆
预先
预分
预制
预告
预处理
预备
预备立宪
预备立宪公会
预定
预审
预应力
预感
预报
预料
预期
预测
预热
预知
预示
预算
预约
预见
预言
预计
预谋
预购
预赛
预防
预防为主
颅骨
领主
领事
领事裁判权
领事馆
领会
领先
领取
领受
领口
领土
领地
领域
领头
领子
领导
领带
领悟
领教
领有
领水
领海
领略
领空
领航
领衔
领袖
领道
领队
颈项
颍川
颍州
颐和园
频传
频带
频率
频率响应
频繁
频谱
频道
频频
颓废
颗粒
颗粒饲料
题名
题字
题材
题目
题词
颚足
颜料
颜色
额外
额头
额定
额定值
额定功率
额角
颠倒
颠倒是非
颠倒黑白
颠复
颠扑不破
颠簸
颠覆
颤动
颤抖
颤音
风云
风传
风俗
风光
风力
风动
风化
风压
风口
风向
风吹雨打
风味
风土
风声
风头
风尘
风尚
风干
风平浪静
风度
风扇
风斗
风景
风暴
风月
风格
风气
风水
风沙
风波
风洞
风流
风浪
风湿
风潮
风琴
风箱
风行
风貌
风起云涌
风趣
风车
风选
风速
风道
风量
风钻
风门
风险
风雨
风雷
风霜
飓风
飘带
飘扬
飘散
飘流
飘浮
飘然
飘荡
飘落
飘飘然
飞天
飞奔
飞往
飞快
飞扬
飞机
飞机场
飞涨
飞溅
飞禽
飞翔
飞腾
飞舞
飞船
飞艇
飞花
飞行
飞行员
飞行器
飞走
飞跑
飞轮
飞进
飞速
飞驰
飞鸟
食利者
食品
食品工业
食堂
食客
食心虫
食性
食指
食欲
食油
食物
食物中毒
食用
食盐
食管
食管癌
食粮
食糖
食谱
食货
食货志
食道
食量
餐具
餐厅
饥寒
饥寒交迫
饥民
饥荒
饥饿
饭厅
饭庄
饭店
饭桌
饭盒
饭碗
饭菜
饭锅
饭馆
饮料
饮水
饮酒
饮食
饮食业
饮食疗法
饮马河
饱含
饱和
饱和度
饱和水汽压
饱和溶液
饱和点
饱和状态
饱和电流
饱满
饲养标准
饲料
饲料作物
饴糖
饶州
饶平
饶恕
饺子
饼子
饼干
饽饽
馄馄
馆子
馆长
馒头
首义
首位
首倡
首先
首创
首尾
首届
首席
首府
首次
首相
首脑
首要
首都
首长
首领
首饰
香军
香味
香山
香料
香案
香气
香水
香油
香港
香炉
香烟
香甜
香皂
香精
香精油
香花
香茅
香菇
香菜
香蕉
馥郁
马丁
马上
马儿
马克
马克思
马克思主义
马克思主义者
马克思列宁主义
马克斯
马兰
马关条约
马刀
马列主义
马力
马口铁
马可
马场
马士英
马太
马头
马子
马家
马尔
马尔萨斯
马尼拉
马尾松
马建忠
马德望
马德里
马拉
马拉博
马拉硫磷
马文
马斯
马普托
马来亚
马来西亚
马槽
马氏体
马灯
马群
马耳他
马脚
马良
马虎
马褂
马西埃
马赛
马赫
马路
马蹄
马蹄形
马车
马达
马达加斯加
马里
马铃薯
马队
马鞍
马鞭
马马虎虎
马鬃
马龙
驯养
驯化
驯服
驯顺
驰名
驰骋
驱使
驱动
驱散
驱车
驱逐
驱逐出境
驱逐舰
驱除
驳倒
驳回
驳斥
驳船
驸马
驻军
驻在国
驻地
驻守
驻扎
驻防
驼背
驾驭
驾驶
驾驶员
驿站
骄傲
骄傲自满
骄横
骆驼
骇人听闻
验收
验电器
验算
验证
骏马
骑兵
骑士
骑马
骗人
骗取
骗子
骗局
骗术
骚乱
骚动
骚扰
骡子
骡马
骤然
骨化
骨头
骨子里
骨干
骨折
骨料
骨架
骨灰
骨眼
骨肉
骨节
骨骼
骨骼肌
骨髓
高下
高不可攀
高个子
高中
高丽
高举
高于
高亢
高产
高价
高会
高位
高低
高低杠
高傲
高僧
高兴
高分子
高分子化合物
高利
高利贷者
高利贷资本
高加索
高升
高压
高压电
高压线
高呼
高唱
高喊
高地
高士
高声
高大
高夫
高官厚禄
高家
高密
高寒
高射炮
高小
高尔基
高尔察克
高尚
高就
高山
高山族
高岗
高岭土
高岭石
高峰
高峻
高州
高差
高平
高年
高度
高强
高强度
高手
高效
高斯
高昂
高明
高校
高档
高棉
高楼
高欢
高歌
高涨
高深
高渐离
高温
高潮
高潮时
高炉
高烧
高热
高燥
高球
高相
高矮
高碳钢
高祖
高秆作物
高程
高空
高等
高等动物
高等学校
高等教育
高等院校
高粱
高级
高级将领
高级社
高级神经活动
高级阶段
高纬度
高翔
高耸
高聚物
高能
高蛋白
高血压
高要
高见
高调
高贵
高超
高车
高迎祥
高速
高速钢
高锰酸钾
高阳
高频
高风
高高
高高兴兴
高高的
高龄
鬓发
鬓角
鬼子
鬼怪
鬼神
鬼脸
鬼话
鬼门关
鬼鬼祟祟
鬼魂
魄力
魅力
魏书
魏德迈
魏忠贤
魏文帝
魏源
魔力
魔术
魔鬼
鱼卵
鱼叉
鱼塘
鱼尾
鱼水
鱼池
鱼油
鱼片
鱼生
鱼种
鱼米之乡
鱼类
鱼类学
鱼粉
鱼网
鱼群
鱼翅
鱼肉
鱼肚
鱼花
鱼苗
鱼道
鱼雷
鱼雷艇
鱼鳞
鱿鱼
鲁班
鲁莽
鲁迅
鲈鱼
鲍威尔
鲍敬言
鲍照
鲍鱼
鲜亮
鲜卑
鲜嫩
鲜明
鲜果
鲜红
鲜美
鲜艳
鲜花
鲜血
鲢鱼
鲤鱼
鲨鱼
鲮鱼
鲶鱼
鲸油
鲸鱼
鳊鱼
鳌拜
鳗鱼
鳗鲡
鳜鱼
鳞片
鳞茎
鸟儿
鸟兽
鸟枪
鸟类
鸡子
鸡毛
鸡肉
鸡舍
鸡蛋
鸡西
鸣放
鸦片
鸦片战争
鸦片贸易
鸨母
鸭子
鸭绿江
鸭蛋
鸽子
鸿沟
鸿渐
鹁鸽
鹅毛
鹿港
麦克斯韦
麦加
麦子
麦收
麦穗
麦粒
麦芽
麦芽糖
麦苗
麦茬
麦麸
麸曲
麸皮
麻城
麻子
麻布
麻木
麻油
麻烦
麻痹
麻痹大意
麻纱
麻纺
麻线
麻绳
麻药
麻袋
麻醉
麻醉剂
麻雀
黄体
黄兴
黄冈
黄县
黄土
黄土高原
黄埔
黄堡
黄壤
黄山
黄州
黄巢
黄斑
黄昏
黄曲霉
黄杨
黄桥
黄梅
黄河
黄油
黄浦
黄海
黄牛
黄瓜
黄白
黄石
黄色
黄色工会
黄花
黄花鱼
黄蜂
黄蜡
黄衣
黄褐色
黄豆
黄连
黄道
黄道婆
黄酒
黄金
黄金时代
黄钟
黄铁矿
黄铜
黄铜矿
黄陵
黄霸
黄鱼
黄麻
黄鼠狼
黄龙
黎元洪
黎巴嫩
黎明
黏合剂
黏土
黏度
黏性
黏液
黏着
黏结
黏膜
黏附
黑下
黑人
黑体
黑光
黑压压
黑土
黑地
黑夜
黑山
黑市
黑帮
黑幕
黑幕小说
黑心
黑手
黑斑病
黑旗军
黑暗
黑松
黑板
黑板报
黑格
黑格尔
黑水
黑沉沉
黑洞洞
黑海
黑热病
黑瘦
黑白
黑白电视
黑穗病
黑色
黑色素
黑色金属
黑豆
黑货
黑陶
黑霉
黑麦
黑黑的
黑黝黝
黑龙江
默启
默然
默认
默许
默默
黝黑
鼎盛
鼎立
鼓乐
鼓动
鼓励
鼓吹
鼓噪
鼓掌
鼓楼
鼓膜
鼓舞
鼓足
鼓风
鼓风机
鼓风炉
鼠笼式
鼻子
鼻孔
鼻尖
鼻息
鼻梁
鼻涕
鼻烟
鼻腔
鼻音
鼾声
齐全
齐名
齐唱
齐备
齐头并进
齐心
齐心协力
齐整
齐明
齐齐哈尔
齿条
齿轮
齿音
龄期
龄级
龙井
龙井茶
龙凤
龙卷风
龙口
龙头
龙套
龙宫
龙山
龙山文化
龙岩
龙江
龙济光
龙溪
龙王
龙眼
龙虎
龙门
龙门架
龙须沟
龙驹
龙骨
龚自珍
龟山
龟缩
