package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Orange;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'orange' => 0x002e5d07, # 0,46,93,7
  'apricot' => 0x002d4f0a, # 0,45,79,10
  'aurore' => 0x00143e00, # 0,20,62,0
  'bi' => 0x00061505, # 0,6,21,5
  'bisque' => 0x000b1700, # 0,11,23,0
  'carrot' => 0x00385505, # 0,56,85,5
  'pumpkin' => 0x002d500d, # 0,45,80,13
  'reef' => 0x00496409, # 0,73,100,9
  'copper' => 0x002a641e, # 0,42,100,30
  'gamboge' => 0x00235e06, # 0,35,94,6
  'mandarine' => 0x00244800, # 0,36,72,0
  'melon' => 0x00205a0d, # 0,32,90,13
  'orange' => 0x00226402, # 0,34,100,2
  'burnt orange' => 0x003a6414, # 0,58,100,20
  'roux' => 0x00365f20, # 0,54,95,32
  'safran' => 0x000c5b05, # 0,12,91,5
  'salmon' => 0x002b4203, # 0,43,66,3
  'tangerine' => 0x00495900, # 0,73,89,0
  'tanne' => 0x00316323, # 0,49,99,35
  'vanilla' => 0x0008200c, # 0,8,32,12
  'belly doe' => 0x000e1809, # 0,14,24,9
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (orange)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Orange - CMYK colors from http://toutes-les-couleurs.com/ (orange)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Orange (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
