use strict;
use Test::More tests => 3;
BEGIN { use_ok('CDDB::Fake') };

my $data;
eval {
     $data = CDDB::Fake->new(\*DATA);
};
print STDERR $@ if $@;
ok($data, "load");

is($data->as_cddb, <<'EOD', "as_cddb");
# xmcd 2.0 CD database file
# Copyright (C) 1996,2004 Johan Vromans
#
# Track frame offsets:
#	150
#	14925
#	34425
#	62625
#	87525
#	106350
#
# Disc length: 1788 seconds
#
DISCID=00000000
DTITLE=Dick Onstenk / Dick's Jazz Stuff
TTITLE0=Body And Soul
TTITLE1=Fly Me To The Moon
TTITLE2=Lover Man
TTITLE3=Freddie Freeloader
TTITLE4=Billie's Bounce
TTITLE5=Softly As In A Morning Sunrise
EXTD=Generated by ls2nocddb 1.4* on Fri Jul 25 14:31:41 200\n     7. T
EXTD=ry to distract
EXTT0=
EXTT1=New and extended version!
EXTT2=
EXTT3=This popular track is performed better than ever.
EXTT4=
EXTT5=
PLAYORDER=
EOD

__DATA__
Dick Onstenk / Dick's Jazz Stuff

     1. Body And Soul			 3:17
     2. Fly Me To The Moon		 4:20
        New and extended version!
     3. Lover Man			 6:16
     4. Freddie Freeloader		 5:32
        This popular track
	is performed better than ever.
     5. Billie's Bounce			 4:11
     6. Softly As In A Morning Sunrise	 6:12

Generated by ls2nocddb 1.4* on Fri Jul 25 14:31:41 200
     7. Try to distract
