
package Amazon::API::CHIME;

# autogenerated on Mon Apr 11 16:34:32 2022 by lib/Amazon/API/Botocore.pm 1.2.7

use strict;
use warnings;

use parent qw{ Amazon::API };
use Data::Dumper;

our @API_METHODS = qw{
  AssociatePhoneNumberWithUser
  AssociatePhoneNumbersWithVoiceConnector
  AssociatePhoneNumbersWithVoiceConnectorGroup
  AssociateSigninDelegateGroupsWithAccount
  BatchCreateAttendee
  BatchCreateChannelMembership
  BatchCreateRoomMembership
  BatchDeletePhoneNumber
  BatchSuspendUser
  BatchUnsuspendUser
  BatchUpdatePhoneNumber
  BatchUpdateUser
  CreateAccount
  CreateAppInstance
  CreateAppInstanceAdmin
  CreateAppInstanceUser
  CreateAttendee
  CreateBot
  CreateChannel
  CreateChannelBan
  CreateChannelMembership
  CreateChannelModerator
  CreateMediaCapturePipeline
  CreateMeeting
  CreateMeetingDialOut
  CreateMeetingWithAttendees
  CreatePhoneNumberOrder
  CreateProxySession
  CreateRoom
  CreateRoomMembership
  CreateSipMediaApplication
  CreateSipMediaApplicationCall
  CreateSipRule
  CreateUser
  CreateVoiceConnector
  CreateVoiceConnectorGroup
  DeleteAccount
  DeleteAppInstance
  DeleteAppInstanceAdmin
  DeleteAppInstanceStreamingConfigurations
  DeleteAppInstanceUser
  DeleteAttendee
  DeleteChannel
  DeleteChannelBan
  DeleteChannelMembership
  DeleteChannelMessage
  DeleteChannelModerator
  DeleteEventsConfiguration
  DeleteMediaCapturePipeline
  DeleteMeeting
  DeletePhoneNumber
  DeleteProxySession
  DeleteRoom
  DeleteRoomMembership
  DeleteSipMediaApplication
  DeleteSipRule
  DeleteVoiceConnector
  DeleteVoiceConnectorEmergencyCallingConfiguration
  DeleteVoiceConnectorGroup
  DeleteVoiceConnectorOrigination
  DeleteVoiceConnectorProxy
  DeleteVoiceConnectorStreamingConfiguration
  DeleteVoiceConnectorTermination
  DeleteVoiceConnectorTerminationCredentials
  DescribeAppInstance
  DescribeAppInstanceAdmin
  DescribeAppInstanceUser
  DescribeChannel
  DescribeChannelBan
  DescribeChannelMembership
  DescribeChannelMembershipForAppInstanceUser
  DescribeChannelModeratedByAppInstanceUser
  DescribeChannelModerator
  DisassociatePhoneNumberFromUser
  DisassociatePhoneNumbersFromVoiceConnector
  DisassociatePhoneNumbersFromVoiceConnectorGroup
  DisassociateSigninDelegateGroupsFromAccount
  GetAccount
  GetAccountSettings
  GetAppInstanceRetentionSettings
  GetAppInstanceStreamingConfigurations
  GetAttendee
  GetBot
  GetChannelMessage
  GetEventsConfiguration
  GetGlobalSettings
  GetMediaCapturePipeline
  GetMeeting
  GetMessagingSessionEndpoint
  GetPhoneNumber
  GetPhoneNumberOrder
  GetPhoneNumberSettings
  GetProxySession
  GetRetentionSettings
  GetRoom
  GetSipMediaApplication
  GetSipMediaApplicationLoggingConfiguration
  GetSipRule
  GetUser
  GetUserSettings
  GetVoiceConnector
  GetVoiceConnectorEmergencyCallingConfiguration
  GetVoiceConnectorGroup
  GetVoiceConnectorLoggingConfiguration
  GetVoiceConnectorOrigination
  GetVoiceConnectorProxy
  GetVoiceConnectorStreamingConfiguration
  GetVoiceConnectorTermination
  GetVoiceConnectorTerminationHealth
  InviteUsers
  ListAccounts
  ListAppInstanceAdmins
  ListAppInstanceUsers
  ListAppInstances
  ListAttendeeTags
  ListAttendees
  ListBots
  ListChannelBans
  ListChannelMemberships
  ListChannelMembershipsForAppInstanceUser
  ListChannelMessages
  ListChannelModerators
  ListChannels
  ListChannelsModeratedByAppInstanceUser
  ListMediaCapturePipelines
  ListMeetingTags
  ListMeetings
  ListPhoneNumberOrders
  ListPhoneNumbers
  ListProxySessions
  ListRoomMemberships
  ListRooms
  ListSipMediaApplications
  ListSipRules
  ListSupportedPhoneNumberCountries
  ListTagsForResource
  ListUsers
  ListVoiceConnectorGroups
  ListVoiceConnectorTerminationCredentials
  ListVoiceConnectors
  LogoutUser
  PutAppInstanceRetentionSettings
  PutAppInstanceStreamingConfigurations
  PutEventsConfiguration
  PutRetentionSettings
  PutSipMediaApplicationLoggingConfiguration
  PutVoiceConnectorEmergencyCallingConfiguration
  PutVoiceConnectorLoggingConfiguration
  PutVoiceConnectorOrigination
  PutVoiceConnectorProxy
  PutVoiceConnectorStreamingConfiguration
  PutVoiceConnectorTermination
  PutVoiceConnectorTerminationCredentials
  RedactChannelMessage
  RedactConversationMessage
  RedactRoomMessage
  RegenerateSecurityToken
  ResetPersonalPIN
  RestorePhoneNumber
  SearchAvailablePhoneNumbers
  SendChannelMessage
  StartMeetingTranscription
  StopMeetingTranscription
  TagAttendee
  TagMeeting
  TagResource
  UntagAttendee
  UntagMeeting
  UntagResource
  UpdateAccount
  UpdateAccountSettings
  UpdateAppInstance
  UpdateAppInstanceUser
  UpdateBot
  UpdateChannel
  UpdateChannelMessage
  UpdateChannelReadMarker
  UpdateGlobalSettings
  UpdatePhoneNumber
  UpdatePhoneNumberSettings
  UpdateProxySession
  UpdateRoom
  UpdateRoomMembership
  UpdateSipMediaApplication
  UpdateSipMediaApplicationCall
  UpdateSipRule
  UpdateUser
  UpdateUserSettings
  UpdateVoiceConnector
  UpdateVoiceConnectorGroup
};

our $VERSION = '1.2.7';

caller or __PACKAGE__->main();

sub new {
  my ( $class, @options ) = @_;
  $class = ref($class) || $class;

  my %options = ref( $options[0] ) ? %{ $options[0] } : @options;

  my $self = $class->SUPER::new(
    { service         => 'chime',
      endpoint_prefix => 'chime',
      version         => '2018-05-01',
      target_prefix   => '',
      api_methods     => \@API_METHODS,
      content_type    => 'application/json',
      boto_protocol   => 'rest-json',
      debug           => $ENV{DEBUG} // 0,
      %options
    }
  );

  return $self;
} ## end sub new

sub main {
  my $chime = Amazon::API::CHIME->new(
    request_uri => '/accounts',
    debug       => $ENV{DEBUG} // 0
  );

  $chime->set_http_method('GET');
  print Dumper $chime->ListAccounts();
} ## end sub main

1;
