# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153920;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1481[25-9]\\d{5}',
                'geographic' => '1481[25-9]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              781|
              839
            )\\d|
            911[17]
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[0-3]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"44116", "Leicester",
"441864", "Abington\ \(Crawford\)",
"441262", "Bridlington",
"4414309", "Market\ Weighton",
"441348", "Fishguard",
"441646", "Milford\ Haven",
"442847", "Northern\ Ireland",
"441911", "Tyneside\/Durham\/Sunderland",
"441342", "East\ Grinstead",
"441268", "Basildon",
"441949", "Whatton",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441833", "Barnard\ Castle",
"441954", "Madingley",
"441993", "Witney",
"441535", "Keighley",
"4419756", "Strathdon",
"4414345", "Haltwhistle",
"442885", "Ballygawley",
"441674", "Montrose",
"4416860", "Newtown\/Llanidloes",
"44114707", "Sheffield",
"441384", "Dudley",
"441900", "Workington",
"44114708", "Sheffield",
"441359", "Pakenham",
"441344", "Bracknell",
"442845", "Northern\ Ireland",
"441609", "Northallerton",
"441862", "Tain",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441264", "Andover",
"441923", "Watford",
"441989", "Ross\-on\-Wye",
"441566", "Launceston",
"4415074", "Alford\ \(Lincs\)",
"442887", "Dungannon",
"441672", "Marlborough",
"441560", "Moscow",
"441382", "Dundee",
"44291", "Cardiff",
"441376", "Braintree",
"4418904", "Coldstream",
"441678", "Bala",
"44141", "Glasgow",
"441769", "South\ Molton",
"441481", "Guernsey",
"4414376", "Haverfordwest",
"441388", "Bishop\ Auckland",
"441952", "Telford",
"441233", "Ashford\ \(Kent\)",
"441591", "Llanwrtyd\ Wells",
"441880", "Tarbert",
"441750", "Selkirk",
"441570", "Lampeter",
"4418906", "Ayton",
"4414303", "North\ Cave",
"4417683", "Appleby",
"441366", "Downham\ Market",
"441424", "Hastings",
"441779", "Peterhead",
"441559", "Llandysul",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441544", "Kington",
"441668", "Bamburgh",
"4414237", "Harrogate",
"441809", "Tomdoun",
"441246", "Chesterfield",
"441725", "Rockbourne",
"4416973", "Wigton",
"441588", "Bishops\ Castle",
"441337", "Ladybank",
"441878", "Lochboisdale",
"441708", "Romford",
"441582", "Luton",
"441274", "Bradford",
"441872", "Truro",
"442838", "Portadown",
"441360", "Killearn",
"441492", "Colwyn\ Bay",
"441407", "Holyhead",
"4415076", "Louth",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441797", "Rye",
"441756", "Skipton",
"441576", "Lockerbie",
"441702", "Southend\-on\-Sea",
"441209", "Redruth",
"4419754", "Alford\ \(Aberdeen\)",
"441542", "Keith",
"441422", "Halifax",
"441727", "St\ Albans",
"4418477", "Tongue",
"441428", "Haslemere",
"44239", "Portsmouth",
"441548", "Kingsbridge",
"441664", "Melton\ Mowbray",
"441280", "Buckingham",
"4419645", "Hornsea",
"441494", "High\ Wycombe",
"441704", "Southport",
"441453", "Dursley",
"44117", "Bristol",
"441286", "Caernarfon",
"441405", "Goole",
"441584", "Ludlow",
"441795", "Sittingbourne",
"441874", "Brecon",
"441335", "Ashbourne",
"441633", "Newport",
"441840", "Camelford",
"441278", "Bridgwater",
"441208", "Bodmin",
"441146", "Sheffield",
"441740", "Sedgefield",
"441475", "Greenock",
"441483", "Guildford",
"441256", "Basingstoke",
"441297", "Axminster",
"441202", "Bournemouth",
"4419641", "Hornsea\/Patrington",
"441935", "Yeovil",
"441593", "Lybster",
"441549", "Lairg",
"441895", "Uxbridge",
"441429", "Hartlepool",
"441554", "Llanelli",
"441250", "Blairgowrie",
"4419648", "Hornsea",
"441225", "Bath",
"441746", "Bridgnorth",
"44283", "Northern\ Ireland",
"441140", "Sheffield",
"441279", "Bishops\ Stortford",
"441827", "Tamworth",
"4414342", "Bellingham",
"44114702", "Sheffield",
"4418476", "Tongue",
"441295", "Banbury",
"44292", "Cardiff",
"441477", "Holmes\ Chapel",
"441506", "Bathgate",
"441772", "Preston",
"4415077", "Louth",
"441204", "Bolton",
"441937", "Wetherby",
"441786", "Stirling",
"441856", "Orkney",
"441669", "Rothbury",
"4416863", "Llanidloes",
"442871", "Londonderry",
"441558", "Llandeilo",
"441778", "Bourne",
"441808", "Tomatin",
"441227", "Canterbury",
"441879", "Scarinish",
"441443", "Pontypridd",
"441709", "Rotherham",
"4414236", "Harrogate",
"441499", "Inveraray",
"441825", "Uckfield",
"441780", "Stamford",
"4418907", "Ayton",
"441913", "Durham",
"441451", "Stow\-on\-the\-Wold",
"441358", "Ellon",
"441869", "Bicester",
"4414377", "Haverfordwest",
"441608", "Chipping\ Norton",
"441436", "Helensburgh",
"441982", "Builth\ Wells",
"4414234", "Boroughbridge",
"441306", "Dorking",
"441352", "Mold",
"441631", "Oban",
"442896", "Belfast",
"441656", "Bridgend",
"441697", "Brampton",
"441988", "Wigtown",
"441650", "Cemmaes\ Road",
"441467", "Inverurie",
"441300", "Cerne\ Abbas",
"442890", "Belfast",
"441959", "Westerham",
"441944", "West\ Heslerton",
"441389", "Dumbarton",
"441768", "Penrith",
"441625", "Macclesfield",
"441970", "Aberystwyth",
"441323", "Eastbourne",
"441604", "Northampton",
"4414348", "Hexham",
"4420", "London",
"441349", "Dingwall",
"441354", "Chatteris",
"441695", "Skelmersdale",
"4419642", "Hornsea",
"441733", "Peterborough",
"4416869", "Newtown",
"441984", "Watchet\ \(Williton\)",
"441269", "Ammanford",
"4418474", "Thurso",
"4419757", "Strathdon",
"442820", "Ballycastle",
"4414300", "North\ Cave\/Market\ Weighton",
"442826", "Northern\ Ireland",
"441948", "Whitchurch",
"441942", "Wigan",
"441465", "Girvan",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441764", "Crieff",
"441726", "St\ Austell",
"441245", "Chelmsford",
"4418909", "Ayton",
"4414230", "Harrogate\/Boroughbridge",
"441663", "New\ Mills",
"441583", "Carradale",
"441575", "Kirriemuir",
"441885", "Pencombe",
"441873", "Abergavenny",
"4419753", "Strathdon",
"441493", "Great\ Yarmouth",
"441287", "Guisborough",
"441449", "Stowmarket",
"441454", "Chipping\ Sodbury",
"441529", "Sleaford",
"4415079", "Alford\ \(Lincs\)",
"441720", "Isles\ of\ Scilly",
"441919", "Durham",
"441634", "Medway",
"441367", "Faringdon",
"441790", "Spilsby",
"441400", "Honington",
"4416974", "Raughton\ Head",
"4412291", "Barrow\-in\-Furness\/Millom",
"442868", "Kesh",
"441761", "Temple\ Cloud",
"441489", "Bishops\ Waltham",
"441330", "Banchory",
"4418512", "Stornoway",
"441543", "Cannock",
"4413395", "Aboyne",
"4418470", "Thurso\/Tongue",
"441845", "Thirsk",
"441599", "Kyle",
"44241", "Coventry",
"4417684", "Pooley\ Bridge",
"441458", "Glastonbury",
"4414304", "North\ Cave",
"4412298", "Barrow\-in\-Furness",
"441757", "Selby",
"441796", "Pitlochry",
"441577", "Kinross",
"441638", "Newmarket",
"441406", "Holbeach",
"441452", "Gloucester",
"441887", "Aberfeldy",
"441981", "Wormbridge",
"441273", "Brighton",
"441285", "Cirencester",
"4414373", "Clynderwen\ \(Clunderwen\)",
"4414306", "Market\ Weighton",
"4418903", "Coldstream",
"441530", "Coalville",
"441343", "Elgin",
"4415395", "Grange\-over\-Sands",
"4418511", "Great\ Bernera\/Stornoway",
"4412292", "Barrow\-in\-Furness",
"442880", "Carrickmore",
"441567", "Killin",
"441924", "Wakefield",
"441263", "Cromer",
"441687", "Mallaig",
"4419759", "Alford\ \(Aberdeen\)",
"441838", "Dalmally",
"441377", "Driffield",
"4418518", "Stornoway",
"442886", "Cookstown",
"4416867", "Llanidloes",
"441832", "Clopton",
"4415073", "Louth",
"441771", "Maud",
"441992", "Lea\ Valley",
"441234", "Bedford",
"441536", "Kettering",
"441863", "Ardgay",
"441565", "Knutsford",
"441922", "Walsall",
"44280", "Northern\ Ireland",
"441928", "Runcorn",
"442846", "Northern\ Ireland",
"44114700", "Sheffield",
"441647", "Moretonhampstead",
"44113", "Leeds",
"441905", "Worcester",
"441953", "Wymondham",
"441834", "Narberth",
"442840", "Banbridge",
"441994", "St\ Clears",
"441685", "Merthyr\ Tydfil",
"441673", "Market\ Rasen",
"441375", "Grays\ Thurrock",
"441383", "Dunfermline",
"4414379", "Haverfordwest",
"441329", "Fareham",
"441353", "Ely",
"441394", "Felixstowe",
"441655", "Maybole",
"441603", "Norwich",
"442895", "Belfast",
"441305", "Dorchester",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441929", "Wareham",
"441435", "Heathfield",
"441271", "Barnstaple",
"441983", "Isle\ of\ Wight",
"441620", "North\ Berwick",
"441626", "Newton\ Abbot",
"44114704", "Sheffield",
"442827", "Ballymoney",
"441322", "Dartford",
"441763", "Royston",
"44287", "Northern\ Ireland",
"4418473", "Thurso",
"441239", "Cardigan",
"441328", "Fakenham",
"441732", "Sevenoaks",
"441871", "Castlebay",
"44151", "Liverpool",
"441581", "New\ Luce",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441491", "Henley\-on\-Thames",
"441977", "Pontefract",
"441398", "Dulverton",
"441738", "Perth",
"441460", "Chard",
"4413392", "Aboyne",
"4418515", "Stornoway",
"442897", "Saintfield",
"4416866", "Newtown",
"441392", "Exeter",
"441307", "Forfar",
"4414233", "Boroughbridge",
"441943", "Guiseley",
"441466", "Huntly",
"441690", "Betws\-y\-Coed",
"4414307", "Market\ Weighton",
"441661", "Prudhoe",
"4417687", "Keswick",
"441324", "Falkirk",
"442879", "Magherafelt",
"442825", "Ballymena",
"441482", "Kingston\-upon\-Hull",
"441896", "Galashiels",
"441857", "Sanday",
"441787", "Sudbury",
"441592", "Kirkcaldy",
"441255", "Clacton\-on\-Sea",
"441951", "Colonsay",
"441476", "Grantham",
"441381", "Fortrose",
"441488", "Hungerford",
"4413391", "Aboyne\/Ballater",
"441671", "Newton\ Stewart",
"44131", "Edinburgh",
"441598", "Lynton",
"4412295", "Barrow\-in\-Furness",
"441145", "Sheffield",
"441524", "Lancaster",
"441444", "Haywards\ Heath",
"4413398", "Aboyne",
"441967", "Strontian",
"441745", "Rhyl",
"441226", "Barnsley",
"4418479", "Tongue",
"441639", "Neath",
"441914", "Tyneside",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"4416864", "Llanidloes",
"441855", "Ballachulish",
"441594", "Lydney",
"441785", "Stafford",
"441773", "Ripley",
"441553", "Kings\ Lynn",
"44286", "Northern\ Ireland",
"441484", "Huddersfield",
"441505", "Johnstone",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441296", "Aylesbury",
"441803", "Torquay",
"441257", "Coppull",
"44238", "Southampton",
"4414239", "Boroughbridge",
"442311", "Southampton",
"441290", "Cumnock",
"441528", "Laggan",
"441341", "Barmouth",
"4418900", "Coldstream\/Ayton",
"441912", "Tyneside",
"441442", "Hemel\ Hempstead",
"441261", "Banff",
"441522", "Lincoln",
"441918", "Tyneside",
"441747", "Shaftesbury",
"4414305", "North\ Cave",
"441866", "Kilchrenan",
"441380", "Devizes",
"441439", "Helmsley",
"4415396", "Sedbergh",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441925", "Warrington",
"441562", "Kidderminster",
"441670", "Morpeth",
"441309", "Forres",
"4416861", "Newtown\/Llanidloes",
"442843", "Newcastle\ \(Co\.\ Down\)",
"442899", "Northern\ Ireland",
"441950", "Sandwick",
"441659", "Sanquhar",
"441644", "New\ Galloway",
"441568", "Leominster",
"441235", "Abingdon",
"441931", "Shap",
"441837", "Okehampton",
"4416868", "Newtown",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441902", "Wolverhampton",
"441997", "Strathpeffer",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4418517", "Stornoway",
"441386", "Evesham",
"441676", "Meriden",
"4414349", "Bellingham",
"4413394", "Ballater",
"442877", "Limavady",
"441908", "Milton\ Keynes",
"441372", "Esher",
"441642", "Middlesbrough",
"441346", "Fraserburgh",
"4419643", "Patrington",
"441821", "Kinrossie",
"441564", "Lapworth",
"44247", "Coventry",
"441260", "Congleton",
"441684", "Malvern",
"442829", "Kilrea",
"442883", "Northern\ Ireland",
"441340", "Craigellachie\ \(Aberlour\)",
"441237", "Bideford",
"441904", "York",
"441835", "St\ Boswells",
"442310", "Portsmouth",
"441291", "Chepstow",
"441995", "Garstang",
"441364", "Ashburton",
"441270", "Crewe",
"441848", "Thornhill",
"441621", "Maldon",
"441244", "Chester",
"441259", "Alloa",
"441842", "Thetford",
"441546", "Lochgilphead",
"441288", "Bude",
"441540", "Kingussie",
"441420", "Alton",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441635", "Newbury",
"441403", "Horsham",
"441754", "Skegness",
"441749", "Shepton\ Mallet",
"441282", "Burnley",
"441884", "Tiverton",
"441793", "Swindon",
"441276", "Camberley",
"4414343", "Haltwhistle",
"44118", "Reading",
"441455", "Hinckley",
"441509", "Loughborough",
"441723", "Scarborough",
"441368", "Dunbar",
"441789", "Stratford\-upon\-Avon",
"442830", "Newry",
"441242", "Cheltenham",
"441461", "Gretna",
"441844", "Thame",
"4413882", "Stanhope\ \(Eastgate\)",
"441859", "Harris",
"441700", "Rothesay",
"441666", "Malmesbury",
"441490", "Corwen",
"4416862", "Llanidloes",
"4419649", "Hornsea",
"441248", "Bangor\ \(Gwynedd\)",
"441870", "Isle\ of\ Benbecula",
"441362", "Dereham",
"441580", "Cranbrook",
"442867", "Lisnaskea",
"4413396", "Ballater",
"441876", "Lochmaddy",
"441586", "Campbeltown",
"441969", "Leyburn",
"441284", "Bury\ St\ Edmunds",
"441706", "Rochdale",
"441752", "Plymouth",
"441572", "Oakham",
"4412297", "Millom",
"441457", "Glossop",
"441496", "Port\ Ellen",
"4415394", "Hawkshead",
"441882", "Kinloch\ Rannoch",
"441691", "Oswestry",
"441758", "Pwllheli",
"441578", "Lauder",
"441888", "Turriff",
"441637", "Newquay",
"441508", "Brooke",
"441858", "Market\ Harborough",
"4414302", "North\ Cave",
"44281", "Northern\ Ireland",
"441144", "Sheffield",
"442881", "Newtownstewart",
"441788", "Rugby",
"441369", "Dunoon",
"441502", "Lowestoft",
"441776", "Stranraer",
"441597", "Llandrindod\ Wells",
"441556", "Castle\ Douglas",
"441487", "Warboys",
"441293", "Crawley",
"441806", "Shetland",
"441852", "Kilmelford",
"441531", "Ledbury",
"4412296", "Barrow\-in\-Furness",
"441254", "Blackburn",
"441249", "Chippenham",
"441782", "Stoke\-on\-Trent",
"441968", "Penicuik",
"441915", "Sunderland",
"441550", "Llandovery",
"441770", "Isle\ of\ Arran",
"4413397", "Ballater",
"441525", "Leighton\ Buzzard",
"441445", "Gairloch",
"441962", "Winchester",
"441823", "Taunton",
"441889", "Rugeley",
"4418514", "Great\ Bernera",
"441744", "St\ Helens",
"441759", "Pocklington",
"4419640", "Hornsea\/Patrington",
"441579", "Liskeard",
"441854", "Ullapool",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441933", "Wellingborough",
"441784", "Staines",
"441252", "Aldershot",
"441206", "Colchester",
"441473", "Ipswich",
"44115", "Nottingham",
"441485", "Hunstanton",
"441258", "Blandford",
"441142", "Sheffield",
"441527", "Redditch",
"441289", "Berwick\-upon\-Tweed",
"441223", "Cambridge",
"442841", "Rostrevor",
"441748", "Richmond",
"441917", "Sunderland",
"441200", "Clitheroe",
"441974", "Llanon",
"44114701", "Sheffield",
"441395", "Budleigh\ Salterton",
"441654", "Machynlleth",
"442894", "Antrim",
"441304", "Dover",
"441721", "Peebles",
"442828", "Larne",
"441946", "Whitehaven",
"441463", "Inverness",
"442822", "Northern\ Ireland",
"441327", "Daventry",
"4413885", "Stanhope\ \(Eastgate\)",
"442892", "Lisburn",
"441978", "Wrexham",
"441356", "Brechin",
"441397", "Fort\ William",
"441302", "Doncaster",
"441606", "Northwich",
"441652", "Brigg",
"441760", "Swaffham",
"441438", "Stevenage",
"4414301", "North\ Cave\/Market\ Weighton",
"442898", "Belfast",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441972", "Glenborrodale",
"441308", "Bridport",
"441737", "Redhill",
"441986", "Bungay",
"441569", "Stonehaven",
"4416865", "Newtown",
"4418516", "Great\ Bernera",
"441432", "Hereford",
"441980", "Amesbury",
"441623", "Mansfield",
"441325", "Darlington",
"442824", "Northern\ Ireland",
"441379", "Diss",
"441689", "Orpington",
"441766", "Porthmadog",
"441600", "Monmouth",
"4414308", "Market\ Weighton",
"441909", "Worksop",
"4412294", "Barrow\-in\-Furness",
"441350", "Dunkeld",
"441425", "Ringwood",
"441545", "Llanarth",
"441899", "Biggar",
"441843", "Thanet",
"441939", "Wem",
"441630", "Market\ Drayton",
"4418905", "Ayton",
"441479", "Grantown\-on\-Spey",
"441724", "Scunthorpe",
"442866", "Enniskillen",
"441450", "Hawick",
"4414238", "Harrogate",
"441667", "Nairn",
"441497", "Hay\-on\-Wye",
"441456", "Glenurquhart",
"441275", "Clevedon",
"441971", "Scourie",
"441283", "Burton\-on\-Trent",
"441707", "Welwyn\ Garden\ City",
"441792", "Swansea",
"4414231", "Harrogate\/Boroughbridge",
"441431", "Helmsdale",
"441877", "Callander",
"441301", "Arrochar",
"441636", "Newark\-on\-Trent",
"441408", "Golspie",
"442891", "Bangor\ \(Co\.\ Down\)",
"441798", "Pulborough",
"441651", "Oldmeldrum",
"441332", "Derby",
"4415075", "Spilsby\ \(Horncastle\)",
"442837", "Armagh",
"44114703", "Sheffield",
"442821", "Martinstown",
"441728", "Saxmundham",
"4418478", "Thurso",
"441363", "Crediton",
"441665", "Alnwick",
"4414344", "Bellingham",
"441547", "Knighton",
"4413399", "Ballater",
"441427", "Gainsborough",
"441722", "Salisbury",
"4419646", "Patrington",
"441243", "Chichester",
"441299", "Bewdley",
"441334", "St\ Andrews",
"441277", "Brentwood",
"441829", "Tarporley",
"4418471", "Thurso\/Tongue",
"441495", "Pontypool",
"4412290", "Barrow\-in\-Furness\/Millom",
"441753", "Slough",
"441573", "Kelso",
"441404", "Honiton",
"441794", "Romsey",
"441883", "Caterham",
"441875", "Tranent",
"442842", "Kircubbin",
"441347", "Easingwold",
"441926", "Warwick",
"442848", "Northern\ Ireland",
"441267", "Carmarthen",
"441865", "Oxford",
"441563", "Kilmarnock",
"442884", "Northern\ Ireland",
"441141", "Sheffield",
"441629", "Matlock",
"441683", "Moffat",
"441675", "Coleshill",
"4419755", "Alford\ \(Aberdeen\)",
"441920", "Ware",
"441373", "Frome",
"441955", "Wick",
"441534", "Jersey",
"4414346", "Hexham",
"4418472", "Thurso",
"4418510", "Great\ Bernera\/Stornoway",
"441236", "Coatbridge",
"4419644", "Patrington",
"441903", "Worthing",
"442870", "Coleraine",
"441643", "Minehead",
"4413393", "Aboyne",
"442844", "Downpatrick",
"441830", "Kirkwhelpington",
"441957", "Mid\ Yell",
"4414232", "Harrogate",
"441501", "Harthill",
"442888", "Northern\ Ireland",
"441469", "Killingholme",
"4414375", "Clynderwen\ \(Clunderwen\)",
"442882", "Omagh",
"441677", "Bedale",
"441538", "Ipstones",
"441387", "Dumfries",
"441692", "North\ Walsham",
"4414378", "Haverfordwest",
"4418902", "Coldstream",
"441357", "Strathaven",
"441698", "Motherwell",
"441736", "Penzance",
"4412293", "Millom",
"441987", "Ebbsfleet",
"4415242", "Hornby",
"44114705", "Sheffield",
"441751", "Pickering",
"441571", "Lochinver",
"442823", "Northern\ Ireland",
"441624", "Isle\ of\ Man",
"442889", "Fivemiletown",
"441730", "Petersfield",
"441361", "Duns",
"4415072", "Spilsby\ \(Horncastle\)",
"441767", "Sandy",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441539", "Kendal",
"441462", "Hitchin",
"441945", "Wisbech",
"441241", "Arbroath",
"44121", "Birmingham",
"441320", "Fort\ Augustus",
"4414347", "Hexham",
"441985", "Warminster",
"441433", "Hathersage",
"442893", "Ballyclare",
"4418519", "Great\ Bernera",
"441303", "Folkestone",
"442849", "Northern\ Ireland",
"4419758", "Strathdon",
"441694", "Church\ Stretton",
"441355", "East\ Kilbride",
"441653", "Malton",
"441628", "Maidenhead",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"4419467", "Gosforth",
"441841", "Newquay\ \(Padstow\)",
"441464", "Insch",
"441765", "Ripon",
"441947", "Whitby",
"441622", "Maidstone",
"441326", "Falmouth",
"441503", "Looe",
"441474", "Gravesend",
"441729", "Settle",
"441910", "Tyneside\/Durham\/Sunderland",
"441805", "Torrington",
"441934", "Weston\-super\-Mare",
"441207", "Consett",
"441292", "Ayr",
"441775", "Spalding",
"441555", "Lanark",
"4412299", "Millom",
"441440", "Haverhill",
"441520", "Lochcarron",
"441298", "Buxton",
"441963", "Wincanton",
"441224", "Aberdeen",
"441822", "Tavistock",
"4419752", "Alford\ \(Aberdeen\)",
"4419647", "Patrington",
"441446", "Barry",
"441526", "Martin",
"441641", "Strathy",
"441828", "Coupar\ Angus",
"4413390", "Aboyne\/Ballater",
"4418475", "Thurso",
"441916", "Tyneside",
"441938", "Welshpool",
"4413873", "Langholm",
"4418901", "Coldstream\/Ayton",
"441143", "Sheffield",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441371", "Great\ Dunmow",
"44161", "Manchester",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"4415078", "Alford\ \(Lincs\)",
"441294", "Ardrossan",
"441932", "Weybridge",
"441253", "Blackpool",
"441892", "Tunbridge\ Wells",
"441807", "Ballindalloch",
"4418513", "Stornoway",
"441205", "Boston",
"441472", "Grimsby",
"441557", "Kirkcudbright",
"441777", "Retford",
"44114709", "Sheffield",
"441590", "Lymington",
"441228", "Carlisle",
"4414235", "Harrogate",
"441480", "Huntingdon",
"441799", "Saffron\ Walden",
"441409", "Holsworthy",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441743", "Shrewsbury",
"441561", "Laurencekirk",
"4418908", "Coldstream",
"441824", "Ruthin",
"4414372", "Clynderwen\ \(Clunderwen\)",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-9]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;