package VMS::ICC;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw();
@EXPORT_OK = qw(&new_service &accept_connection &open_connection
		&read_data &write_data &close_connection &delete_service);
$VERSION = '0.02';


bootstrap VMS::ICC $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__

=head1 NAME

VMS::ICC - VMS ICC systems service interface

=head1 SYNOPSIS

  use VMS::ICC;
  $service_handle = new_service($service_name, $logical_name, $logical_table);
  $connection_handle = accept_connection($service_handle);
  $connection_handle = open_connection($service, $node);
  $data = read_data($connection_handle);
  $status = write_data($connection_handle, $data, $async);
  $status = close_connection($connection_handle);
  $status = delete_service($service_handle);
  $old_debug = VMS::ICC::debug($new_level);

=head1 DESCRIPTION

The VMS::ICC module provides an interface into the IntraCluster Communication
services.

=over 4

=item new_service

Registers a service in the cluster. The service_name, logical_name and
logical_table parameters are all optional--if you leave one or more
out, or pass them as undef, VMS::ICC will use the default values. 

Since connection accepts are done in AST routines, and there's no good
way to register a perl AST routine, VMS::ICC automatically accepts any
connection request and puts it on an internal queue. The queue is
currently limited to 25 entries, and any connection requests made
while the queue is full will be refused. (Calling accept_connection
from perl takes a connect request off the internal queue, opening up a
slot for another inbound connection)

This returns a scalar that represents this particular service, though
at the moment the scalar is unused and a program can only have one
open service at a time.

=item accept_connection

Accepts a connection and returns a handle to it, or undef if there
aren't any pending connections. The service_handle parameter is the
same as what's returned by new_service, though it's currently ignored.

=item open_connection

Opens a connection to a server out there someplace. Makes the
connection to the service you specified, optionally on the node you
specified. (If no node parameter is passed, the ICC services choose
from amongst all the services registered with that name in the cluster)

=item read_data

Reads a message from the specified connection. This will block waiting
for a message to arrive on the specified connection.

Currently messages are limited to a maximum of 1000 bytes.

=item write_data

Writes data to the specified connection. The data scalar is converted
to a string (if it isn't already one) and sent to the other end. If
the async flag is set this will return immediately, otherwise it
blocks until the message is read on the other end.

=item close_connection

Closes the specified connection.

=item delete_service

Deregisters the service and closes any pending accepted but
unprocessed connections. 

=item debug

Turns on all sorts of debugging logic. This takes an integer. Bit 0
turns on tracing, bit 1 turns on system service status messages, and
bit 2 turns on generall chatty stuff.

=head1 LIMITATIONS

Right now a program can only provide one service at a time. This is a
limitation that may be lifted in the future.

It's not possible to wait on multiple connections for data, though
this limitation may also be lifted in the future. (Or you can use
threads if you'd rather)

=head1 AUTHOR

Dan Sugalski <DSugalski@cantor.com>

=head1 SEE ALSO

perl(1).

=cut
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 